/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class RelContributionParameters
extends ReportParameters {
    private int chartType = 4;

    public RelContributionParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public RelContributionParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, double d, BUnit bUnit, int n2, Lexicon lexicon, boolean bl, int n3, double d2) {
        super(reportInputArray, reportPeriod, n, d, bUnit, false, lexicon, bl, n3, d2);
        this.chartType = n2;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        this.setPeriod(reportParameters.getPeriod());
        int n = reportParameters.getNormalization();
        if (n == 2) {
            this.setNormalization(n);
        }
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public int getChartType() {
        return this.chartType;
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        this.chartType = dataInput.readInt();
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.chartType);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.lex.getText("relativeContribution") + "\n");
        stringBuffer.append("  " + this.lex.getText("period") + "       : ").append(this.getPeriod()).append("\n");
        stringBuffer.append("  " + this.lex.getText("normalization") + ": ");
        switch (this.getNormalization()) {
            case 0: {
                stringBuffer.append(this.lex.getText("none") + "\n");
                break;
            }
            case 2: {
                stringBuffer.append(this.lex.getText("floorArea") + "\n");
                break;
            }
            case 4: {
                stringBuffer.append(this.lex.getText("weather") + "\n");
            }
        }
        stringBuffer.append("  " + this.lex.getText("chartType") + "   : ");
        switch (this.chartType) {
            case 4: {
                stringBuffer.append(this.lex.getText("pie") + "\n");
            }
            case 2: {
                stringBuffer.append(this.lex.getText("bar") + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

