/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.BaselineReportPeriod;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportConst;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class PointTrendingParameters
extends ReportParameters
implements ReportConst {
    public static final int DEFAULT_INTERVAL = 15;
    public static final int VERSION = -411;
    private int interval = 15;
    private ReportInput corr1;
    private ReportInput corr2;
    private int corr2lag;
    private boolean showRegression = true;
    private BaselineReportPeriod baselinePeriod = null;
    private ReportInput baselineSource = null;
    private ReportInput baseline = null;
    private boolean applyBaseline = true;
    private int baselineColor = ChartColors.getColorCount() - 1;

    public PointTrendingParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public PointTrendingParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, int n2, double d, BUnit bUnit, ReportInput reportInput, ReportInput reportInput2, int n3, boolean bl, BaselineReportPeriod baselineReportPeriod, ReportInput reportInput3, ReportInput reportInput4, boolean bl2, int n4, Lexicon lexicon, boolean bl3, int n5, double d2) {
        super(reportInputArray, reportPeriod, n2, d, bUnit, false, lexicon, bl3, n5, d2);
        this.interval = n;
        this.corr1 = reportInput;
        this.corr2 = reportInput2;
        this.corr2lag = n3;
        this.showRegression = bl;
        this.baselinePeriod = baselineReportPeriod;
        this.baselineSource = reportInput3;
        this.baseline = reportInput4;
        this.applyBaseline = bl2;
        this.baselineColor = n4;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        ReportPeriod reportPeriod = reportParameters.getPeriod();
        this.setPeriod(new ReportPeriod(reportPeriod.getCustomPeriod(), reportPeriod.getStartTime(), reportPeriod.getEndTime(), 127, this.lex));
        int n = reportParameters.getNormalization();
        if (n == 2 || n == 4) {
            this.setNormalization(n);
        } else {
            this.setNormalization(0);
        }
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public ReportInput getCorrelationInput1() {
        return this.corr1;
    }

    public ReportInput getCorrelationInput2() {
        return this.corr2;
    }

    public boolean showRegressionLine() {
        return this.showRegression;
    }

    public int getCorrelation2Lag() {
        return this.corr2lag;
    }

    public int getInterval() {
        return this.interval;
    }

    public long getIntervalMillis() {
        return (long)this.interval * 60L * 1000L;
    }

    public BTimeZone getTimeZone() {
        if (this.getInputs() == null || this.getInputs().length == 0) {
            return BTimeZone.getLocal();
        }
        try {
            return ((SiteDataPoint)this.getInputs()[0].getInputItem(0)).getDataPoint().getTimeZone();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return BTimeZone.getLocal();
        }
    }

    public RegularTimeParameters getTimeParameters() {
        return new RegularTimeParameters(this.getPeriod().getStartTime(), this.getPeriod().getEndTime(), new TimeInterval(this.getInterval(), 3), this.getTimeZone());
    }

    public RegularTimeParameters getBaselineTimeParameters() {
        return new RegularTimeParameters(this.getBaselinePeriod().getStartTime(), this.getBaselinePeriod().getEndTime(), new TimeInterval(this.getInterval(), 3), this.getTimeZone());
    }

    public BaselineReportPeriod getBaselinePeriod() {
        return this.baselinePeriod;
    }

    public ReportInput getBaselineSource() {
        return this.baselineSource;
    }

    public ReportInput getBaseline() {
        return this.baseline;
    }

    public boolean getApplyBaseline() {
        return this.applyBaseline;
    }

    public int getBaselineColor() {
        return this.baselineColor;
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        ReportInput[] reportInputArray = this.getInputs();
        int n = dataInput.readInt();
        if (n != -411) {
            this.interval = n;
            this.baselinePeriod = null;
            this.applyBaseline = true;
            this.baselineColor = ChartColors.getColorCount() - 1;
            this.baselineSource = null;
            this.baseline = null;
        } else {
            this.interval = dataInput.readInt();
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = dataInput.readInt();
        if (n2 >= 0) {
            this.corr1 = reportInputArray[n2];
        } else if (n2 == -2) {
            bl = true;
        }
        n2 = dataInput.readInt();
        if (n2 >= 0) {
            this.corr2 = reportInputArray[n2];
        } else if (n2 == -2) {
            bl2 = true;
        }
        this.corr2lag = dataInput.readInt();
        this.showRegression = dataInput.readBoolean();
        if (n == -411) {
            this.baselinePeriod = new BaselineReportPeriod(this.lex);
            this.baselinePeriod.load(dataInput);
            this.baselinePeriod.setReferencePeriod(this.getPeriod());
            this.applyBaseline = dataInput.readBoolean();
            this.baselineColor = dataInput.readInt();
            boolean bl3 = dataInput.readBoolean();
            if (!bl3 && (n2 = dataInput.readInt()) >= 0) {
                reportInputArray = this.getInputs();
                this.baselineSource = reportInputArray[n2];
                this.baseline = this.baselineSource.getCopy();
                this.baseline.setName(dataInput.readUTF());
                this.baseline.setColor(ChartColors.getColor(this.getBaselineColor()));
                if (bl) {
                    this.corr1 = this.baseline;
                }
                if (bl2) {
                    this.corr2 = this.baseline;
                }
            }
        }
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(-411);
        dataOutput.writeInt(this.interval);
        dataOutput.writeInt(this.getIndexOf(this.corr1));
        dataOutput.writeInt(this.getIndexOf(this.corr2));
        dataOutput.writeInt(this.corr2lag);
        dataOutput.writeBoolean(this.showRegression);
        this.baselinePeriod.save(dataOutput);
        dataOutput.writeBoolean(this.applyBaseline);
        dataOutput.writeInt(this.baselineColor);
        if (this.baselineSource == null) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            dataOutput.writeInt(this.getIndexOf(this.baselineSource));
            dataOutput.writeUTF(this.baseline.getName());
        }
    }

    private int getIndexOf(ReportInput reportInput) {
        ReportInput[] reportInputArray = this.getInputs();
        if (reportInputArray != null) {
            for (int i = 0; i < reportInputArray.length; ++i) {
                if (reportInputArray[i] != reportInput) continue;
                return i;
            }
        }
        if (this.getBaseline() != null && reportInput != null && reportInput.getName().equals(this.getBaseline().getName())) {
            return -2;
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("Point Trending\n");
        stringBuffer.append("  Period       : ").append(this.getPeriod()).append("\n");
        stringBuffer.append("  Normalization: ");
        switch (this.getNormalization()) {
            case 0: {
                stringBuffer.append("none");
                break;
            }
            case 1: {
                stringBuffer.append("baseline");
                break;
            }
            case 2: {
                stringBuffer.append("floor area");
                break;
            }
            case 4: {
                stringBuffer.append("weather");
            }
        }
        return stringBuffer.toString();
    }
}

