/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.BaselineReportPeriod;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class LoadDurationParameters
extends ReportParameters {
    public static final int DEFAULT_INTERVAL = 1;
    private int interval = 1;
    private int numPlottedPoints = 100;
    private BaselineReportPeriod baselinePeriod = null;
    private ReportInput baselineSource = null;
    private ReportInput baseline = null;
    private boolean applyBaseline = true;
    private int baselineColor = ChartColors.getColorCount() - 1;

    public LoadDurationParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public LoadDurationParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, int n2, int n3, double d, BUnit bUnit, BaselineReportPeriod baselineReportPeriod, ReportInput reportInput, ReportInput reportInput2, boolean bl, int n4, Lexicon lexicon, boolean bl2, int n5, double d2) {
        super(reportInputArray, reportPeriod, n3, d, bUnit, false, lexicon, bl2, n5, d2);
        this.interval = n;
        this.numPlottedPoints = n2;
        this.baselinePeriod = baselineReportPeriod;
        this.baselineSource = reportInput;
        this.baseline = reportInput2;
        this.applyBaseline = bl;
        this.baselineColor = n4;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        this.setPeriod(reportParameters.getPeriod());
        this.setNormalization(reportParameters.getNormalization());
        this.setNormalTemperature(reportParameters.getNormalTemperature());
        this.setNormalTemperatureUnit(reportParameters.getNormalTemperatureUnit());
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public int getInterval() {
        return this.interval;
    }

    public int getNumPlottedPoints() {
        return this.numPlottedPoints;
    }

    public BaselineReportPeriod getBaselinePeriod() {
        return this.baselinePeriod;
    }

    public ReportInput getBaselineSource() {
        return this.baselineSource;
    }

    public ReportInput getBaseline() {
        return this.baseline;
    }

    public boolean getApplyBaseline() {
        return this.applyBaseline;
    }

    public int getBaselineColor() {
        return this.baselineColor;
    }

    public RegularTimeParameters getTimeParameters() {
        return new RegularTimeParameters(this.getPeriod().getStartTime(), this.getPeriod().getEndTime(), new TimeInterval(15L, 3), this.getTimeZone());
    }

    public RegularTimeParameters getBaselineTimeParameters() {
        return new RegularTimeParameters(this.getBaselinePeriod().getStartTime(), this.getBaselinePeriod().getEndTime(), new TimeInterval(15L, 3), this.getTimeZone());
    }

    private BTimeZone getTimeZone() {
        if (this.getInputs() == null || this.getInputs().length == 0) {
            return BTimeZone.getLocal();
        }
        try {
            return ((SiteDataPoint)this.getInputs()[0].getInputItem(0)).getDataPoint().getTimeZone();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return BTimeZone.getLocal();
        }
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        int n;
        this.interval = dataInput.readInt();
        this.numPlottedPoints = dataInput.readInt();
        this.baselinePeriod = new BaselineReportPeriod(this.lex);
        this.baselinePeriod.load(dataInput);
        this.baselinePeriod.setReferencePeriod(this.getPeriod());
        this.applyBaseline = dataInput.readBoolean();
        this.baselineColor = dataInput.readInt();
        boolean bl = dataInput.readBoolean();
        if (!bl && (n = dataInput.readInt()) >= 0) {
            ReportInput[] reportInputArray = this.getInputs();
            this.baselineSource = reportInputArray[n];
            this.baseline = this.baselineSource.getCopy();
            this.baseline.setName(dataInput.readUTF());
            this.baseline.setColor(ChartColors.getColor(this.getBaselineColor()));
        }
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.interval);
        dataOutput.writeInt(this.numPlottedPoints);
        this.baselinePeriod.save(dataOutput);
        dataOutput.writeBoolean(this.applyBaseline);
        dataOutput.writeInt(this.baselineColor);
        if (this.baselineSource == null) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            dataOutput.writeInt(this.getIndexOf(this.baselineSource));
            dataOutput.writeUTF(this.baseline.getName());
        }
    }

    private int getIndexOf(ReportInput reportInput) {
        ReportInput[] reportInputArray = this.getInputs();
        if (reportInputArray != null) {
            for (int i = 0; i < reportInputArray.length; ++i) {
                if (reportInputArray[i] != reportInput) continue;
                return i;
            }
        }
        return -1;
    }
}

