/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.BaselineReportPeriod;
import com.tridium.eas.api.DayOfWeek;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartColorCellRenderer;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultLineConfig;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.reports.DurationValuePair;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.EasReportTable;
import com.tridium.eas.ui.reports.InputValueColors;
import com.tridium.eas.ui.reports.InterpolatedScalarTimeSeries;
import com.tridium.eas.ui.reports.InterpolatedTimeSeries;
import com.tridium.eas.ui.reports.LoadDurationHeaderCellRenderer;
import com.tridium.eas.ui.reports.LoadDurationParameters;
import com.tridium.eas.ui.reports.LoadDurationSeries;
import com.tridium.eas.ui.reports.LoadDurationTableModel;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportInputListCellRenderer;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.BaselineReportPeriodEditor;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.EasTable;
import com.tridium.eas.ui.widgets.FixedSizePanel;
import com.tridium.eas.ui.widgets.GridBagManager;
import com.tridium.eas.ui.widgets.MaxSizePanel;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.eas.ui.widgets.TemperatureEditor;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.eas.util.CompoundUnitUtil;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class LoadDuration
extends EasReport
implements EasDataListener {
    public static final String TEMPLATE_ID = "loadDuration";
    private Chart chart;
    private EasTable table;
    private Config config;
    private boolean holdUpdates = false;
    private HashMap minMaxByUnit = null;
    private boolean reportRunning = false;

    public String getName() {
        return this.lex.getText(TEMPLATE_ID);
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected JComponent getReportContent() {
        if (this.chart == null) {
            this.chart = new Chart(this.lex);
            this.chart.setTitle(this.getName());
            this.chart.setChartStatus(this);
        }
        return this.chart;
    }

    protected JComponent getReportDetails() {
        if (this.table == null) {
            this.table = new EasReportTable((TableModel)new LoadDurationTableModel(this.lex), false, this.lex);
        }
        return this.table.getScrollPane();
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        ChartModel chartModel = new ChartModel();
        this.chart.setModel(chartModel);
        chartModel.setTitle(this.getName());
        this.getInputList().getModel().addEasDataListener(this);
        this.setRunReportEnabled(false);
        this.lang = this.getParameter("lang", "en");
        this.lex = BEasApplet.lex;
    }

    public ReportParameters createEmptyParameters() {
        return new LoadDurationParameters(this.lex);
    }

    public ReportParameters getReportParameters(boolean bl) {
        return new LoadDurationParameters(this.getInputList().getModel().getInputs(), this.config.getPeriod(!bl), this.config.getInterval(), this.config.getNumPlottedPoints(), this.config.getNormalization(), this.config.getNormalTemperature(), this.config.getNormalTemperatureUnit(), this.config.getBaselinePeriod(!bl), this.config.getBaselineSourceSeries(), this.config.getBaselineSeries(), this.config.getApplyBaseline(), this.config.getBaselineColor(), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    public void setReportParameters(ReportParameters reportParameters) {
        LoadDurationParameters loadDurationParameters = (LoadDurationParameters)reportParameters;
        this.getInputList().getModel().setInputs(loadDurationParameters.getInputs());
        this.config.setInterval(loadDurationParameters.getInterval());
        this.config.setNumPlottedPoints(loadDurationParameters.getNumPlottedPoints());
        this.config.setPeriod(loadDurationParameters.getPeriod());
        this.config.setNormalization(loadDurationParameters.getNormalization());
        this.config.setNormalTemperature(loadDurationParameters.getNormalTemperature());
        this.config.setNormalTemperatureUnit(loadDurationParameters.getNormalTemperatureUnit());
        this.config.setBaselinePeriod(loadDurationParameters.getBaselinePeriod());
        this.config.setBaselineSeries(loadDurationParameters.getBaselineSource());
        this.config.setBaselineColor(loadDurationParameters.getBaselineColor());
        this.config.setApplyBaseline(loadDurationParameters.getApplyBaseline());
        this.setDataCleanse(loadDurationParameters.getDataCleanse());
        this.setDataCleanseWindow(loadDurationParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(loadDurationParameters.getDataCleansePercentage());
        this.updateEnabledStates();
    }

    public void runReport(ReportParameters reportParameters) {
        if (!this.reportRunning) {
            LoadDurationParameters loadDurationParameters = (LoadDurationParameters)reportParameters;
            ProgressThread progressThread = new ProgressThread(this, loadDurationParameters);
            progressThread.start();
        }
    }

    private TimeSeries getTimeSeries(ReportInput reportInput, LoadDurationParameters loadDurationParameters) {
        TimeSeries timeSeries;
        ReportPeriod reportPeriod = loadDurationParameters.getPeriod();
        int n = reportPeriod.getDaysOfWeek();
        if (reportInput.getUnit() == null || reportInput.getUnit().isNull()) {
            timeSeries = new InterpolatedScalarTimeSeries(loadDurationParameters.getTimeParameters(), reportInput, loadDurationParameters.isNormalizedByFloorArea(), loadDurationParameters.isNormalizedByTemperature(), loadDurationParameters.getNormalTemperature(), loadDurationParameters.getNormalTemperatureUnit(), n, this.lex, loadDurationParameters.getDataCleanse(), loadDurationParameters.getDataCleanseWindow(), loadDurationParameters.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
        } else {
            timeSeries = new InterpolatedTimeSeries(loadDurationParameters.getTimeParameters(), reportInput.getUnit(), loadDurationParameters.isNormalizedByFloorArea(), loadDurationParameters.isNormalizedByTemperature(), loadDurationParameters.getNormalTemperature(), loadDurationParameters.getNormalTemperatureUnit(), n, this.lex, loadDurationParameters.getDataCleanse(), loadDurationParameters.getDataCleanseWindow(), loadDurationParameters.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
            ((InterpolatedTimeSeries)timeSeries).addInput(reportInput, false, 0);
        }
        BUnit bUnit = reportInput.getUnit();
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        if (reportInput.hasNormalizingPoint()) {
            try {
                bUnit = CompoundUnitUtil.make(bUnit, reportInput.getNormalizingPoint().getUnit());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.minMaxByUnit.containsKey(bUnit)) {
            MinMaxValues minMaxValues = (MinMaxValues)this.minMaxByUnit.get(bUnit);
            double d = timeSeries.getMin();
            double d2 = timeSeries.getMax();
            if (d < minMaxValues.getMin()) {
                minMaxValues.setMin(d);
            }
            if (d2 > minMaxValues.getMax()) {
                minMaxValues.setMax(d2);
            }
        } else {
            this.minMaxByUnit.put(bUnit, new MinMaxValues(timeSeries.getMin(), timeSeries.getMax()));
        }
        return timeSeries;
    }

    private static BTimeZone getTimeZone(ReportInput reportInput) {
        try {
            return ((SiteDataPoint)reportInput.getInputItem(0)).getDataPoint().getTimeZone();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return BTimeZone.getLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEnabledStates() {
        ReportInput[] reportInputArray = this;
        synchronized (this) {
            if (this.holdUpdates) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.holdUpdates = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.getInputList().getModel().enableAllInputs();
            reportInputArray = this.getInputList().getModel().getInputs();
            boolean bl = false;
            int n = this.getInputList().getItemCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                ReportInputItem[] reportInputItemArray;
                if ((this.config.getNormalization() & 4) != 0) {
                    reportInputItemArray = reportInputArray[i].getInputItems();
                    for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                        if (((SiteDataPoint)reportInputItemArray[n2]).getOutdoorAirTempDataPoint() == null) {
                            this.getInputList().getModel().disableInput(i);
                            continue;
                        }
                        bl = true;
                    }
                    continue;
                }
                if ((this.config.getNormalization() & 2) > 0) {
                    reportInputItemArray = reportInputArray[i].getInputItems();
                    for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                        try {
                            if (((SiteDataPoint)reportInputItemArray[n2]).getDataPoint().getFloorAreaValue() == 0.0) {
                                this.getInputList().getModel().disableInput(i);
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        catch (EasException easException) {
                            easException.printStackTrace();
                            this.getInputList().getModel().disableInput(i);
                        }
                    }
                    continue;
                }
                bl = true;
            }
            this.setRunReportEnabled(bl);
            this.holdUpdates = false;
            return;
        }
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
        this.updateEnabledStates();
        for (int i = 0; i < dataEditedEvent.getEditedData().length; ++i) {
            this.config.removeInput((ReportInput)dataEditedEvent.getEditedData()[i]);
        }
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        for (int i = 0; i < dataEditedEvent.getEditedData().length; ++i) {
            this.config.addInput((ReportInput)dataEditedEvent.getEditedData()[i]);
        }
        this.dataChanged(dataEditedEvent);
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        if (this.holdUpdates) {
            return;
        }
        if (dataEditedEvent.getSource() == this.getInputList().getModel() && dataEditedEvent.getEditedData().length > 0) {
            this.updateEnabledStates();
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            book.append(this.chart, pageFormat);
            Iterator iterator = this.table.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
        }
        return book;
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            this.chart.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chart.setShowGrid(bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    private class ProgressThread
    extends Thread {
        private LoadDuration report;
        private LoadDurationParameters params;

        public ProgressThread(LoadDuration loadDuration2, LoadDurationParameters loadDurationParameters) {
            super("LoadDurationProgress");
            this.report = loadDuration2;
            this.params = loadDurationParameters;
        }

        public void run() {
            LoadDuration.this.reportRunning = true;
            LoadDuration.this.setCursor(Cursor.getPredefinedCursor(3));
            ProgressMonitor progressMonitor = new ProgressMonitor(this.report, LoadDuration.this.lex.getText("loadDurationProgress"), "", 1, 100);
            progressMonitor.setProgress(1);
            progressMonitor.setMillisToDecideToPopup(500);
            try {
                Object object;
                final ChartModel chartModel = new ChartModel();
                chartModel.setTitle(LoadDuration.this.lex.getText(LoadDuration.TEMPLATE_ID));
                LoadDuration.this.minMaxByUnit = new HashMap();
                final ReportPeriod reportPeriod = this.params.getPeriod();
                int n = reportPeriod.getDaysOfWeek();
                ReportInput[] reportInputArray = this.params.getInputs();
                if (reportInputArray == null) {
                    progressMonitor.close();
                    LoadDuration.this.setCursor(Cursor.getDefaultCursor());
                    LoadDuration.this.reportRunning = false;
                    return;
                }
                progressMonitor.setMinimum(1);
                progressMonitor.setMaximum((reportInputArray.length + 1) * 2);
                TimeSeries[] timeSeriesArray = new TimeSeries[reportInputArray.length + 1];
                ReportInput[] reportInputArray2 = new ReportInput[reportInputArray.length + 1];
                int n2 = 0;
                for (int i = 0; i < reportInputArray.length; ++i) {
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        LoadDuration.this.setCursor(Cursor.getDefaultCursor());
                        LoadDuration.this.reportRunning = false;
                        return;
                    }
                    progressMonitor.setProgress(i + 1);
                    if (!reportInputArray[i].isEnabled() || this.params.getBaselineSource() != null && reportInputArray[i].equals(this.params.getBaselineSource()) && !this.params.getApplyBaseline()) continue;
                    progressMonitor.setNote(LoadDuration.this.lex.getText("retrievingDataFor") + " " + reportInputArray[i].getName());
                    timeSeriesArray[n2] = LoadDuration.this.getTimeSeries(reportInputArray[i], this.params);
                    reportInputArray2[n2] = reportInputArray[i];
                    ++n2;
                }
                if (progressMonitor.isCanceled()) {
                    progressMonitor.close();
                    LoadDuration.this.setCursor(Cursor.getDefaultCursor());
                    LoadDuration.this.reportRunning = false;
                    return;
                }
                progressMonitor.setProgress(reportInputArray.length + 1);
                ReportInput reportInput = this.params.getBaseline();
                if (reportInput != null && reportInput.isEnabled()) {
                    int n3;
                    progressMonitor.setNote(LoadDuration.this.lex.getText("retrievingDataFor") + " " + reportInput.getName());
                    if (reportInput.getUnit() == null || reportInput.getUnit().isNull()) {
                        object = new InterpolatedScalarTimeSeries(this.params.getTimeParameters(), reportInput, this.params.isNormalizedByFloorArea(), this.params.isNormalizedByTemperature(), this.params.getNormalTemperature(), this.params.getNormalTemperatureUnit(), n, LoadDuration.this.lex, this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
                        n3 = ((Series)object).getRowCount();
                        timeSeriesArray[n2] = new InterpolatedScalarTimeSeries(this.params.getBaselineTimeParameters(), reportInput, this.params.isNormalizedByFloorArea(), this.params.isNormalizedByTemperature(), this.params.getNormalTemperature(), this.params.getNormalTemperatureUnit(), LoadDuration.this.lex, true, n3, this.params.getTimeParameters(), n, this.params.getBaselineTimeParameters(), this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
                        ((InterpolatedScalarTimeSeries)timeSeriesArray[n2]).setTimeParameters(this.params.getTimeParameters());
                    } else {
                        object = new InterpolatedTimeSeries(this.params.getBaselineTimeParameters(), reportInput.getUnit(), this.params.isNormalizedByFloorArea(), this.params.isNormalizedByTemperature(), this.params.getNormalTemperature(), this.params.getNormalTemperatureUnit(), n, this.params.getBaselineTimeParameters(), LoadDuration.this.lex, this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
                        n3 = this.params.getTimeParameters().getLocalTimePopulation().getSize();
                        int n4 = ((InterpolatedTimeSeries)object).addInput(reportInput, true, n3);
                        ((InterpolatedTimeSeries)object).setTimeParameters(this.params.getTimeParameters());
                        timeSeriesArray[n2] = object;
                    }
                    reportInputArray2[n2] = reportInput;
                    object = reportInput.getUnit();
                    if (object == null) {
                        object = BUnit.NULL;
                    }
                    if (reportInput.hasNormalizingPoint()) {
                        object = CompoundUnitUtil.make((BUnit)object, reportInput.getNormalizingPoint().getUnit());
                    }
                    if (LoadDuration.this.minMaxByUnit.containsKey(object)) {
                        MinMaxValues minMaxValues = (MinMaxValues)LoadDuration.this.minMaxByUnit.get(object);
                        double d = timeSeriesArray[n2].getMin();
                        double d2 = timeSeriesArray[n2].getMax();
                        if (d < minMaxValues.getMin()) {
                            minMaxValues.setMin(d);
                        }
                        if (d2 > minMaxValues.getMax()) {
                            minMaxValues.setMax(d2);
                        }
                    } else {
                        LoadDuration.this.minMaxByUnit.put(object, new MinMaxValues(timeSeriesArray[n2].getMin(), timeSeriesArray[n2].getMax()));
                    }
                }
                object = new DayOfWeek(n);
                final LoadDurationTableModel loadDurationTableModel = new LoadDurationTableModel(LoadDuration.this.lex);
                for (int i = 0; i <= n2; ++i) {
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        LoadDuration.this.setCursor(Cursor.getDefaultCursor());
                        LoadDuration.this.reportRunning = false;
                        return;
                    }
                    progressMonitor.setProgress(reportInputArray.length + i + 2);
                    TimeSeries timeSeries = timeSeriesArray[i];
                    if (timeSeries == null) break;
                    progressMonitor.setNote(LoadDuration.this.lex.getText("computingLoadDuration") + " " + reportInputArray2[i].getName());
                    BUnit bUnit = reportInputArray2[i].getUnit();
                    if (bUnit == null) {
                        bUnit = BUnit.NULL;
                    }
                    if (reportInputArray2[i].hasNormalizingPoint()) {
                        bUnit = CompoundUnitUtil.make(bUnit, reportInputArray2[i].getNormalizingPoint().getUnit());
                    }
                    MinMaxValues minMaxValues = (MinMaxValues)LoadDuration.this.minMaxByUnit.get(bUnit);
                    double d = minMaxValues.getMin();
                    double d3 = minMaxValues.getMax();
                    int n5 = this.params.getNumPlottedPoints();
                    double d4 = (d3 - d) / (double)n5;
                    DurationValuePair[] durationValuePairArray = new DurationValuePair[n5];
                    double d5 = d3;
                    BTimeZone bTimeZone = LoadDuration.getTimeZone(reportInputArray2[i]);
                    Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
                    long l = 0L;
                    for (int j = 0; j < n5; ++j) {
                        if (progressMonitor.isCanceled()) {
                            progressMonitor.close();
                            LoadDuration.this.setCursor(Cursor.getDefaultCursor());
                            LoadDuration.this.reportRunning = false;
                            return;
                        }
                        long l2 = 0L;
                        l = 0L;
                        for (int k = 0; k < timeSeries.getRowCount(); ++k) {
                            if (progressMonitor.isCanceled()) {
                                progressMonitor.close();
                                LoadDuration.this.setCursor(Cursor.getDefaultCursor());
                                LoadDuration.this.reportRunning = false;
                                return;
                            }
                            calendar.setTime(new Date(timeSeries.getTimestamp(k)));
                            if (!((DayOfWeek)object).included(calendar)) continue;
                            l += 900000L;
                            if (!(timeSeries.getValue(k, 0) >= d5)) continue;
                            l2 += 900000L;
                        }
                        durationValuePairArray[j] = new DurationValuePair(d5, l2);
                        d5 = j == n5 - 2 ? d : (d5 -= d4);
                        if (!(d5 < d)) continue;
                        d5 = d;
                    }
                    BUnit bUnit2 = reportInputArray2[i].getUnit();
                    if (reportInputArray2[i].hasNormalizingPoint()) {
                        bUnit2 = CompoundUnitUtil.make(bUnit2, reportInputArray2[i].getNormalizingPoint().getUnit());
                    }
                    if (this.params.isNormalizedByFloorArea()) {
                        bUnit2 = CompoundUnitUtil.make(bUnit2, ((SiteDataPoint)reportInputArray2[i].getInputItem(0)).getDataPoint().getFloorAreaUnit());
                    }
                    LoadDurationSeries loadDurationSeries = new LoadDurationSeries(durationValuePairArray, reportInputArray2[i], bUnit2, this.params.getInterval(), l);
                    InputValueColors inputValueColors = new InputValueColors(reportInputArray2[i]);
                    chartModel.addSeries(loadDurationSeries, new DefaultLineConfig(2, false, inputValueColors), null, null);
                    loadDurationTableModel.addSeries(loadDurationSeries, inputValueColors);
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        LoadDuration.this.table.setModel(loadDurationTableModel);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(reportPeriod.getDateRangeString());
                        if (ProgressThread.this.params.getBaseline() != null && ProgressThread.this.params.getBaseline().isEnabled()) {
                            stringBuffer.append("\n(" + ((ProgressThread)ProgressThread.this).LoadDuration.this.lex.getText("baseline") + " ");
                            stringBuffer.append(ProgressThread.this.params.getBaselinePeriod().getDateRangeString());
                            stringBuffer.append(")");
                        }
                        LoadDuration.this.chart.setModel(chartModel);
                        LoadDuration.this.chart.setSubtitle(stringBuffer.toString());
                        LoadDuration.this.table.setTitle(((ProgressThread)ProgressThread.this).LoadDuration.this.lex.getText(LoadDuration.TEMPLATE_ID));
                        LoadDuration.this.table.setSubtitle(stringBuffer.toString());
                        LoadDuration.this.table.resetSorting();
                        int n = LoadDuration.this.table.getModel().getColumnCount();
                        for (int i = 0; i < n; ++i) {
                            LoadDuration.this.table.getColumnModel().getColumn(i).setHeaderRenderer(new LoadDurationHeaderCellRenderer());
                        }
                        LoadDuration.this.table.getTableHeader().repaint();
                        LoadDuration.this.table.revalidate();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            progressMonitor.close();
            LoadDuration.this.setCursor(Cursor.getDefaultCursor());
            LoadDuration.this.reportRunning = false;
        }
    }

    private class MinMaxValues {
        private double min;
        private double max;

        public MinMaxValues(double d, double d2) {
            this.min = d;
            this.max = d2;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public void setMin(double d) {
            this.min = d;
        }

        public void setMax(double d) {
            this.max = d;
        }
    }

    private class Config
    extends JComponent
    implements ActionListener {
        private XpComboBox interval;
        private NumberTextField numPointsField;
        private ReportPeriodEditor periodEditor;
        private JCheckBox normFloorArea;
        private JCheckBox normWeather;
        private TemperatureEditor tempEditor;
        private boolean initializing = true;
        private JPanel baselinePanel;
        private JToggleButton showBaselineDetails;
        private JLabel baselineSummary;
        private BaselineReportPeriodEditor baselinePeriodEditor;
        private XpComboBox baselineSeries;
        private JRadioButton displayBaseline;
        private JRadioButton displayBoth;
        private XpComboBox baselineColorCombo;

        public Config() {
            LoadDuration.this.lex = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            JPanel jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(LoadDuration.this.lex.getText(LoadDuration.TEMPLATE_ID)));
            int n2 = 0;
            GridBagManager gridBagManager = new GridBagManager(jPanel);
            gridBagManager.insets(new Insets(0, 0, 4, 2));
            gridBagManager.anchor(17);
            JLabel jLabel = new JLabel(LoadDuration.this.lex.getText("intervalDomain"));
            jLabel.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, n2, jLabel);
            this.interval = new XpComboBox();
            this.interval.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    if (Config.this.initializing) {
                        return;
                    }
                    LoadDurationSeries[] loadDurationSeriesArray = ((LoadDurationTableModel)LoadDuration.this.table.getModel()).getLoadDurationSeries();
                    if (loadDurationSeriesArray == null || loadDurationSeriesArray.length <= 0) {
                        return;
                    }
                    for (n = 0; n < loadDurationSeriesArray.length; ++n) {
                        if (loadDurationSeriesArray[n] == null) continue;
                        loadDurationSeriesArray[n].setInterval(Config.this.getInterval());
                    }
                    LoadDuration.this.chart.rebuild();
                    LoadDuration.this.chart.repaint();
                    ((LoadDurationTableModel)LoadDuration.this.table.getModel()).fireTableStructureChanged();
                    LoadDuration.this.table.resetSorting();
                    n = LoadDuration.this.table.getModel().getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        LoadDuration.this.table.getColumnModel().getColumn(i).setHeaderRenderer(new LoadDurationHeaderCellRenderer());
                    }
                    LoadDuration.this.table.getTableHeader().repaint();
                    LoadDuration.this.table.revalidate();
                }
            });
            this.interval.setFont(font);
            this.interval.addItem(LoadDuration.this.lex.getText("minutes"));
            this.interval.addItem(LoadDuration.this.lex.getText("hours"));
            this.interval.addItem(LoadDuration.this.lex.getText("days"));
            this.interval.addItem(LoadDuration.this.lex.getText("%"));
            this.interval.setSelectedIndex(1);
            gridBagManager.add(100, 100, 1, 1, 1, n2++, this.interval);
            jLabel = new JLabel(LoadDuration.this.lex.getText("numPlottedPoints"));
            jLabel.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, n2, jLabel);
            this.numPointsField = new NumberTextField(7, true);
            this.numPointsField.setAllowNegative(false);
            gridBagManager.add(100, 100, 1, 1, 1, n2++, this.numPointsField);
            this.numPointsField.setFont(font);
            this.numPointsField.setText("100");
            this.add(jPanel);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.periodEditor = new ReportPeriodEditor(LoadDuration.this.lex);
            this.periodEditor.setBorder(BorderFactory.createTitledBorder(LoadDuration.this.lex.getText("period")));
            this.add(this.periodEditor);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(this.periodEditor, gridBagConstraints);
            JPanel jPanel2 = new JPanel(false);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            jPanel2.setLayout(gridBagLayout2);
            int n3 = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.weightx = 100.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            MaxSizePanel maxSizePanel = new MaxSizePanel(200, 600);
            maxSizePanel.setLayout(new BorderLayout());
            this.showBaselineDetails = new JToggleButton(LoadDuration.this.lex.getText("showDetails"));
            this.showBaselineDetails.setFont(font);
            this.showBaselineDetails.addActionListener(this);
            this.baselineSummary = new JLabel("  " + LoadDuration.this.lex.getText("noBaseline"));
            this.baselineSummary.setForeground(UIManager.getColor("Table.foreground"));
            this.baselineSummary.setFont(font);
            maxSizePanel.add((Component)this.showBaselineDetails, "West");
            maxSizePanel.add((Component)this.baselineSummary, "Center");
            jPanel2.add(maxSizePanel);
            gridBagConstraints2.gridy = n3++;
            gridBagLayout2.setConstraints(maxSizePanel, gridBagConstraints2);
            this.baselinePanel = new JPanel(false);
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            this.baselinePanel.setLayout(gridBagLayout3);
            int n4 = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.weightx = 100.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 2;
            this.baselinePeriodEditor = new BaselineReportPeriodEditor(false, LoadDuration.this.lex, this.periodEditor, true);
            BaselineReportPeriod baselineReportPeriod = (BaselineReportPeriod)this.baselinePeriodEditor.getValue(true);
            baselineReportPeriod.setReferencePeriod(this.getPeriod(true));
            this.baselinePeriodEditor.setValue(baselineReportPeriod);
            this.baselinePeriodEditor.setBorder(BorderFactory.createTitledBorder(LoadDuration.this.lex.getText("period")));
            this.baselinePanel.add(this.baselinePeriodEditor);
            gridBagConstraints3.gridy = n4++;
            gridBagLayout3.setConstraints(this.baselinePeriodEditor, gridBagConstraints3);
            this.baselineSeries = new XpComboBox();
            this.baselineSeries.addActionListener(this);
            this.baselineSeries.addItem(LoadDuration.this.lex.getText("noBaseline"));
            this.baselineSeries.setRenderer(new ReportInputListCellRenderer(30));
            FixedSizePanel fixedSizePanel = new FixedSizePanel(this.baselineSeries);
            this.baselinePanel.add(fixedSizePanel);
            gridBagConstraints3.gridy = n4++;
            gridBagLayout3.setConstraints(fixedSizePanel, gridBagConstraints3);
            JPanel jPanel3 = new JPanel(new GridBagLayout(), false);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.gridheight = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.insets = new Insets(2, 2, 0, 0);
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.fill = 0;
            JPanel jPanel4 = new JPanel(false);
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            jPanel4.setLayout(gridBagLayout4);
            int n5 = 0;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints5.weightx = 100.0;
            gridBagConstraints5.weighty = 0.0;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.gridheight = 1;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.fill = 2;
            JLabel jLabel2 = new JLabel(LoadDuration.this.lex.getText("baselineColor"));
            jLabel2.setForeground(UIManager.getColor("Table.foreground"));
            jLabel2.setFont(font);
            jPanel4.add(jLabel2);
            gridBagConstraints5.gridy = n5++;
            gridBagLayout4.setConstraints(jLabel2, gridBagConstraints5);
            this.baselineColorCombo = new XpComboBox();
            this.baselineColorCombo.setFont(font);
            this.baselineColorCombo.setRenderer(new ChartColorCellRenderer());
            int n6 = 0;
            int n7 = 0;
            while (n7 < ChartColors.getColorCount()) {
                this.baselineColorCombo.addItem(new Integer(n7));
                n6 = n7++;
            }
            this.baselineColorCombo.setSelectedIndex(n6);
            jPanel4.add(this.baselineColorCombo);
            gridBagConstraints5.gridy = n5++;
            gridBagLayout4.setConstraints(this.baselineColorCombo, gridBagConstraints5);
            jPanel3.add((Component)jPanel4, gridBagConstraints4);
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.weightx = 100.0;
            gridBagConstraints4.fill = 2;
            JPanel jPanel5 = new JPanel(false);
            GridBagLayout gridBagLayout5 = new GridBagLayout();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            jPanel5.setLayout(gridBagLayout5);
            int n8 = 0;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints6.weightx = 100.0;
            gridBagConstraints6.weighty = 0.0;
            gridBagConstraints6.gridwidth = 1;
            gridBagConstraints6.gridheight = 1;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.anchor = 18;
            gridBagConstraints6.fill = 2;
            this.displayBoth = new JRadioButton(LoadDuration.this.lex.getText("displayBoth"), true);
            this.displayBoth.addActionListener(this);
            this.displayBoth.setFont(font);
            jPanel5.add(this.displayBoth);
            gridBagConstraints6.gridy = n8++;
            gridBagLayout5.setConstraints(this.displayBoth, gridBagConstraints6);
            this.displayBaseline = new JRadioButton(LoadDuration.this.lex.getText("displayBaseline"), false);
            this.displayBaseline.addActionListener(this);
            this.displayBaseline.setFont(font);
            jPanel5.add(this.displayBaseline);
            gridBagConstraints6.gridy = n8++;
            gridBagLayout5.setConstraints(this.displayBaseline, gridBagConstraints6);
            jPanel5.setBorder(BorderFactory.createEtchedBorder());
            jPanel3.add((Component)jPanel5, gridBagConstraints4);
            this.baselinePanel.add(jPanel3);
            gridBagConstraints3.gridy = n4++;
            gridBagLayout3.setConstraints(jPanel3, gridBagConstraints3);
            this.baselinePanel.setVisible(this.showBaselineDetails.isSelected());
            jPanel2.add(this.baselinePanel);
            gridBagConstraints2.gridy = n3++;
            gridBagLayout2.setConstraints(this.baselinePanel, gridBagConstraints2);
            jPanel2.setBorder(BorderFactory.createTitledBorder(LoadDuration.this.lex.getText("baseline")));
            this.add(jPanel2);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            JPanel jPanel6 = new JPanel(false);
            GridBagManager gridBagManager2 = new GridBagManager(jPanel6);
            gridBagManager2.anchor(17);
            this.add(jPanel6);
            this.normFloorArea = new JCheckBox(LoadDuration.this.lex.getText("floorArea"));
            this.normFloorArea.addActionListener(this);
            this.normFloorArea.setFont(font);
            gridBagManager2.add(0, 0, 2, 1, 0, 0, this.normFloorArea);
            this.normWeather = new JCheckBox(LoadDuration.this.lex.getText("degreeDay"));
            this.normWeather.addActionListener(this);
            this.normWeather.setFont(font);
            gridBagManager2.add(0, 100, 1, 1, 0, 1, this.normWeather);
            this.tempEditor = new TemperatureEditor(65, BUnit.getUnit((String)"fahrenheit"), LoadDuration.this.lex);
            gridBagManager2.add(100, 100, 1, 1, 1, 1, this.tempEditor);
            jPanel6.setBorder(BorderFactory.createTitledBorder(LoadDuration.this.lex.getText("normalization")));
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
            JLabel jLabel3 = new JLabel("");
            this.add(jLabel3);
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
            this.initializing = false;
        }

        public int getInterval() {
            int n = this.interval.getSelectedIndex();
            switch (n) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return 1;
        }

        public void setInterval(int n) {
            this.initializing = true;
            if (n == 0) {
                this.interval.setSelectedIndex(0);
            } else if (n == 2) {
                this.interval.setSelectedIndex(2);
            } else if (n == 3) {
                this.interval.setSelectedIndex(3);
            } else {
                this.interval.setSelectedIndex(1);
            }
            this.initializing = false;
        }

        public int getNumPlottedPoints() {
            return this.numPointsField.getIntValue();
        }

        public void setNumPlottedPoints(int n) {
            this.numPointsField.setText(Integer.toString(n));
        }

        public ReportPeriod getPeriod(boolean bl) {
            return (ReportPeriod)this.periodEditor.getValue(bl);
        }

        public void setPeriod(ReportPeriod reportPeriod) {
            this.periodEditor.setValue(reportPeriod);
        }

        public int getNormalization() {
            int n = 0;
            if (this.normFloorArea.isSelected()) {
                n |= 2;
            }
            if (this.normWeather.isSelected()) {
                n |= 4;
            }
            return n;
        }

        public void setNormalization(int n) {
            this.normFloorArea.setSelected((n & 2) != 0);
            this.normWeather.setSelected((n & 4) != 0);
        }

        public double getNormalTemperature() {
            return this.tempEditor.getValue();
        }

        public void setNormalTemperature(double d) {
            this.tempEditor.setValue(d);
        }

        public BUnit getNormalTemperatureUnit() {
            return this.tempEditor.getUnit();
        }

        public void setNormalTemperatureUnit(BUnit bUnit) {
            this.tempEditor.setUnit(bUnit);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.showBaselineDetails) {
                this.baselinePanel.setVisible(this.showBaselineDetails.isSelected());
                LoadDuration.this.getMainSplit().validate();
                if (this.showBaselineDetails.isSelected()) {
                    this.showBaselineDetails.setText(LoadDuration.this.lex.getText("hideDetails"));
                } else {
                    this.showBaselineDetails.setText(LoadDuration.this.lex.getText("showDetails"));
                }
            } else if (object == this.baselineSeries) {
                ReportInput reportInput = this.getBaselineSeries();
                if (reportInput != null) {
                    this.baselineSummary.setText("  " + this.getBaselineSourceSeries().getName());
                } else {
                    this.baselineSummary.setText("  " + LoadDuration.this.lex.getText("noBaseline"));
                }
            } else if (object == this.displayBoth) {
                this.displayBaseline.setSelected(!this.displayBoth.isSelected());
            } else if (object == this.displayBaseline) {
                this.displayBoth.setSelected(!this.displayBaseline.isSelected());
            } else {
                LoadDuration.this.updateEnabledStates();
            }
        }

        public BaselineReportPeriod getBaselinePeriod(boolean bl) {
            return (BaselineReportPeriod)this.baselinePeriodEditor.getValue(bl);
        }

        public void setBaselinePeriod(BaselineReportPeriod baselineReportPeriod) {
            if (baselineReportPeriod == null) {
                BaselineReportPeriod baselineReportPeriod2 = new BaselineReportPeriod(EasLocalTime.getCurrentTime(), EasLocalTime.getCurrentTime(), this.getPeriod(true).getDaysOfWeek(), LoadDuration.this.lex);
                baselineReportPeriod2.setReferencePeriod(this.getPeriod(true));
                this.baselinePeriodEditor.setValue(baselineReportPeriod2);
            } else {
                this.baselinePeriodEditor.setValue(baselineReportPeriod);
            }
        }

        public void removeInput(ReportInput reportInput) {
            this.baselineSeries.removeItem(reportInput);
        }

        public void addInput(ReportInput reportInput) {
            if (this.indexOf(this.baselineSeries, reportInput) < 0) {
                this.baselineSeries.addItem(reportInput);
            }
        }

        public int indexOf(XpComboBox xpComboBox, Object object) {
            for (int i = 0; i < xpComboBox.getItemCount(); ++i) {
                if (!xpComboBox.getItemAt(i).equals(object)) continue;
                return i;
            }
            return -1;
        }

        public void setBaselineSeries(ReportInput reportInput) {
            if (reportInput == null) {
                this.baselineSeries.setSelectedItem(LoadDuration.this.lex.getText("noBaseline"));
            } else {
                this.baselineSeries.setSelectedItem(reportInput);
            }
        }

        public ReportInput getBaselineSourceSeries() {
            if (this.baselineSeries.getSelectedItem() instanceof ReportInput) {
                return (ReportInput)this.baselineSeries.getSelectedItem();
            }
            return null;
        }

        public ReportInput getBaselineSeries() {
            if (this.baselineSeries.getSelectedItem() instanceof ReportInput) {
                ReportInput reportInput = ((ReportInput)this.baselineSeries.getSelectedItem()).getCopy();
                reportInput.setName(LoadDuration.this.lex.getText("baseline") + ": " + reportInput.getName());
                reportInput.setColor(ChartColors.getColor(this.getBaselineColor()));
                return reportInput;
            }
            return null;
        }

        public void setBaselineColor(int n) {
            this.baselineColorCombo.setSelectedIndex(n);
        }

        public int getBaselineColor() {
            return this.baselineColorCombo.getSelectedIndex();
        }

        public void setApplyBaseline(boolean bl) {
            if (bl) {
                this.displayBoth.setSelected(true);
                this.displayBaseline.setSelected(false);
            } else {
                this.displayBoth.setSelected(false);
                this.displayBaseline.setSelected(true);
            }
        }

        public boolean getApplyBaseline() {
            return this.displayBoth.isSelected();
        }
    }
}

