/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.function.LinearFunction;
import com.tridium.eas.function.LinearRegression;
import com.tridium.eas.function.Subpopulation;
import com.tridium.eas.ui.chart.FloatSeries;
import com.tridium.eas.ui.chart.Series;
import java.awt.Color;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class LinearRegressionSeries
extends FloatSeries {
    private int yValueIndex;
    private int xValueIndex;
    private Series xSeries;
    private Series ySeries;
    private LinearFunction regressionFunction;
    private Color color;
    private int lag;
    private Lexicon lex;
    private boolean useCustomMax = false;
    private boolean useCustomMin = false;
    private double maxValue = -1.0;

    public LinearRegressionSeries(Series series, Series series2, int n, int n2, Color color, Lexicon lexicon) {
        this(series, series2, n, n2, color, 0, lexicon);
    }

    public LinearRegressionSeries(Series series, Series series2, int n, int n2, Color color, int n3, Lexicon lexicon) {
        this.xSeries = series;
        this.ySeries = series2;
        this.xValueIndex = n;
        this.yValueIndex = n2;
        this.lag = n3;
        this.lex = lexicon;
        this.regressionFunction = n3 == 0 ? LinearRegression.getLinearRegressionFunction(series.getValuePopulation(n), series.getValueMean(n), series2.getValuePopulation(n2), series2.getValueMean(n2)) : (n3 > 0 ? LinearRegression.getLinearRegressionFunction(new Subpopulation(series.getValuePopulation(n), n3, series.getRowCount() - n3), new Subpopulation(series2.getValuePopulation(n2), 0, series.getRowCount() - n3)) : LinearRegression.getLinearRegressionFunction(new Subpopulation(series.getValuePopulation(n), 0, series.getRowCount() + n3), new Subpopulation(series2.getValuePopulation(n2), -1 * n3, series.getRowCount() + n3)));
        this.color = color;
    }

    public LinearRegressionSeries(Series series, Series series2, int n, int n2, Color color, int n3, Lexicon lexicon, boolean bl, double d) {
        this(series, series2, n, n2, color, n3, lexicon);
        this.useCustomMin = true;
        this.useCustomMax = bl;
        this.maxValue = d;
    }

    public LinearRegressionSeries(Series series, Series series2, int n, int n2, Color color, int n3, Lexicon lexicon, double d, double d2, boolean bl, double d3) {
        this.xSeries = series;
        this.ySeries = series2;
        this.xValueIndex = n;
        this.yValueIndex = n2;
        this.lag = n3;
        this.lex = lexicon;
        this.regressionFunction = new LinearFunction(d, d2);
        this.color = color;
        this.useCustomMin = true;
        this.useCustomMax = bl;
        this.maxValue = d3;
    }

    public String getSeriesName() {
        return this.lex.getText("linearRegression");
    }

    public int getRowCount() {
        return 2;
    }

    public int getValueType() {
        return 0;
    }

    public Color getValueColor(int n) {
        return this.color;
    }

    public double getValue(int n, int n2) {
        return this.regressionFunction.getScalar(this.getDouble(n));
    }

    public BUnit getValueUnits() {
        return this.ySeries.getValueUnits();
    }

    public double getMin(int n) {
        return Math.min(this.getValue(0, 0), this.getValue(1, 0));
    }

    public double getMax(int n) {
        return Math.max(this.getValue(0, 0), this.getValue(1, 0));
    }

    public double getDouble(int n) {
        if (n == 0) {
            return this.getMinDouble();
        }
        return this.getMaxDouble();
    }

    public double getMinDouble() {
        double d = this.xSeries.getMin(this.xValueIndex);
        if (this.useCustomMin) {
            d = Math.min(0.0, d);
        }
        return d;
    }

    public double getMaxDouble() {
        double d = this.xSeries.getMax(this.xValueIndex);
        if (this.useCustomMax && this.maxValue > this.getMinDouble()) {
            d = this.maxValue;
        }
        return d;
    }

    public BUnit getDoubleUnits() {
        return this.xSeries.getValueUnits();
    }

    public LinearFunction getRegressionFunction() {
        return this.regressionFunction;
    }
}

