/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DayOfWeek;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.FuncDataSummary;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.RepeatingPopulation;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class InterpolatedTimeSeries
extends TimeSeries
implements ValueColors {
    private ArrayList populationByInput = null;
    private String axisTitle = null;
    private ArrayList inputList = null;
    private BUnit unit = null;
    private RegularTimeParameters timeParms = null;
    private BUnit normalTemperatureUnit = null;
    private double normalTemperature;
    private boolean isNormalizedByFloorArea = false;
    private boolean isNormalizedByTemperature = false;
    private int incl_wdays = -1;
    private RegularTimeParameters baselineTimeParms = null;
    private boolean useBaseline = false;
    private Lexicon lex;
    private boolean dataCleanse = false;
    private int dataCleanseWindow = 4;
    private double dataCleansePercentage = 100.0;
    private boolean dpNormalization = false;
    private DataPoint normalizer = null;

    public InterpolatedTimeSeries(RegularTimeParameters regularTimeParameters, ReportInput reportInput, boolean bl, boolean bl2, double d, BUnit bUnit, Lexicon lexicon, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        this(regularTimeParameters, reportInput.getUnit(), bl, bl2, d, bUnit, lexicon, bl3, n, d2, bl4, dataPoint);
        this.addInput(reportInput, false, 0);
    }

    public InterpolatedTimeSeries(RegularTimeParameters regularTimeParameters, BUnit bUnit, boolean bl, boolean bl2, double d, BUnit bUnit2, Lexicon lexicon, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        this.timeParms = regularTimeParameters;
        this.inputList = new ArrayList();
        this.populationByInput = new ArrayList();
        this.axisTitle = null;
        this.unit = bUnit;
        this.isNormalizedByFloorArea = bl;
        this.isNormalizedByTemperature = bl2;
        this.normalTemperature = d;
        this.normalTemperatureUnit = bUnit2;
        this.incl_wdays = -1;
        this.useBaseline = false;
        this.lex = lexicon;
        this.dataCleanse = bl3;
        this.dataCleanseWindow = n;
        this.dataCleansePercentage = d2;
        this.dpNormalization = bl4;
        this.normalizer = dataPoint;
    }

    public InterpolatedTimeSeries(RegularTimeParameters regularTimeParameters, BUnit bUnit, boolean bl, boolean bl2, double d, BUnit bUnit2, int n, Lexicon lexicon, boolean bl3, int n2, double d2, boolean bl4, DataPoint dataPoint) {
        this.timeParms = regularTimeParameters;
        this.inputList = new ArrayList();
        this.populationByInput = new ArrayList();
        this.axisTitle = null;
        this.unit = bUnit;
        this.isNormalizedByFloorArea = bl;
        this.isNormalizedByTemperature = bl2;
        this.normalTemperature = d;
        this.normalTemperatureUnit = bUnit2;
        this.incl_wdays = n;
        this.useBaseline = false;
        this.lex = lexicon;
        this.dataCleanse = bl3;
        this.dataCleanseWindow = n2;
        this.dataCleansePercentage = d2;
        this.dpNormalization = bl4;
        this.normalizer = dataPoint;
    }

    public InterpolatedTimeSeries(RegularTimeParameters regularTimeParameters, BUnit bUnit, boolean bl, boolean bl2, double d, BUnit bUnit2, int n, RegularTimeParameters regularTimeParameters2, Lexicon lexicon, boolean bl3, int n2, double d2, boolean bl4, DataPoint dataPoint) {
        this.timeParms = regularTimeParameters;
        this.inputList = new ArrayList();
        this.populationByInput = new ArrayList();
        this.axisTitle = null;
        this.unit = bUnit;
        this.isNormalizedByFloorArea = bl;
        this.isNormalizedByTemperature = bl2;
        this.normalTemperature = d;
        this.normalTemperatureUnit = bUnit2;
        this.incl_wdays = n;
        this.baselineTimeParms = regularTimeParameters2;
        this.useBaseline = true;
        this.lex = lexicon;
        this.dataCleanse = bl3;
        this.dataCleanseWindow = n2;
        this.dataCleansePercentage = d2;
        this.dpNormalization = bl4;
        this.normalizer = dataPoint;
    }

    public String getSeriesName() {
        return " ";
    }

    public int getRowCount() {
        int n = this.getPopulation(0).getSize();
        int n2 = this.getValueCount();
        for (int i = 1; i < n2; ++i) {
            try {
                n = Math.min(n, this.getPopulation(i).getSize());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public int getValueCount() {
        return this.populationByInput.size();
    }

    public double getMin(int n) {
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                d = Math.min(d, this.getValue(i, n));
                continue;
            }
            bl = true;
            d = this.getValue(i, n);
        }
        return d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getValueCount(); ++i) {
            stringBuffer.append(this.lex.getText("value") + " " + i + " " + this.lex.getText("Min") + " " + this.getMin(i) + " " + this.lex.getText("max") + " " + this.getMax(i) + "\n");
        }
        return stringBuffer.toString();
    }

    public double getMax(int n) {
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                d = Math.max(d, this.getValue(i, n));
                continue;
            }
            bl = true;
            d = this.getValue(i, n);
        }
        return d;
    }

    public double getValue(int n, int n2) {
        return this.getValueUnits().fromNormal(this.getPopulation(n2).getUnit().toNormal(this.getPopulation(n2).getSample(n)));
    }

    public int getValueType() {
        return 0;
    }

    public ReportInput getInput(int n) {
        return (ReportInput)this.inputList.get(n);
    }

    public Population getPopulation(int n) {
        return (Population)this.populationByInput.get(n);
    }

    public BUnit getValueUnits() {
        return this.getValueCount() == 0 ? this.unit : this.getPopulation(0).getUnit();
    }

    public int addInput(ReportInput reportInput) {
        return this.addInput(reportInput, false, 0);
    }

    public int addInput(ReportInput reportInput, boolean bl, int n) {
        if (!reportInput.isEnabled()) {
            return -1;
        }
        try {
            Object object;
            ReportInputItem[] reportInputItemArray = reportInput.getInputItems();
            TSDataSummary tSDataSummary = null;
            if (reportInputItemArray.length == 0) {
                return -1;
            }
            if (reportInputItemArray.length == 1) {
                tSDataSummary = ((SiteDataPoint)reportInputItemArray[0]).getDataPoint().getDataSummary(this.timeParms.getStartTime(), this.timeParms.getEndTime(), this.unit, this.incl_wdays, 0, this.timeParms.getInterval(), this.isNormalizedByFloorArea, this.isNormalizedByTemperature, this.normalTemperatureUnit, this.normalTemperature, this.dataCleanse, this.dataCleanseWindow, this.dataCleansePercentage, this.dpNormalization, this.normalizer);
            } else {
                object = new DataPoint[reportInputItemArray.length];
                for (int i = 0; i < reportInputItemArray.length; ++i) {
                    object[i] = ((SiteDataPoint)reportInputItemArray[i]).getDataPoint();
                }
                tSDataSummary = FuncDataSummary.getResult((DataPoint[])object, this.unit, this.timeParms.getStartTime(), this.timeParms.getEndTime(), this.incl_wdays, 0, this.timeParms.getInterval(), this.isNormalizedByFloorArea, object[0].getFloorAreaUnit(), this.isNormalizedByTemperature, this.normalTemperature, this.normalTemperatureUnit, this.dataCleanse, this.dataCleanseWindow, this.dataCleansePercentage, this.dpNormalization, this.normalizer);
            }
            object = ((SiteDataPoint)reportInputItemArray[0]).getDataPoint();
            if (((DataPoint)object).getRcSubTypeObj() == RcSubtype.CONSUMPTION || ((DataPoint)object).getRcSubTypeObj() == RcSubtype.REACTIVE_ENERGY || ((DataPoint)object).getRcSubTypeObj() == RcSubtype.APPARENT_ENERGY) {
                if (bl) {
                    this.addPopulation(new RepeatingPopulation(tSDataSummary.getConsumptionPopulation(), n));
                } else {
                    this.addPopulation(tSDataSummary.getConsumptionPopulation());
                }
            } else if (((DataPoint)object).getRcSubTypeObj() == RcSubtype.DEMAND || ((DataPoint)object).getRcSubTypeObj() == RcSubtype.REACTIVE_POWER || ((DataPoint)object).getRcSubTypeObj() == RcSubtype.APPARENT_POWER) {
                if (bl) {
                    this.addPopulation(new RepeatingPopulation(tSDataSummary.getDemandPopulation(), n));
                } else {
                    this.addPopulation(tSDataSummary.getDemandPopulation());
                }
            } else if (bl) {
                this.addPopulation(new RepeatingPopulation(tSDataSummary.getMeanPopulation(), n));
            } else {
                this.addPopulation(tSDataSummary.getMeanPopulation());
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return -1;
        }
        int n2 = this.inputList.size();
        this.inputList.add(reportInput);
        return n2;
    }

    protected void addPopulation(Population population) {
        this.populationByInput.add(population);
    }

    public String getRowName(int n) {
        return "";
    }

    public Color getValueColor(int n) {
        return this.getInput(n).getColor();
    }

    public String getValueName(int n) {
        return this.getInput(n).getName();
    }

    public long getTimestamp(int n) {
        return this.timeParms.getLocalTime(n);
    }

    public long getMinTimestamp() {
        return this.timeParms.getStartTime().getTimestamp(BTimeZone.getLocal());
    }

    public long getMaxTimestamp() {
        return this.timeParms.getEndTime().getTimestamp(BTimeZone.getLocal());
    }

    public Population getTimestampPopulation() {
        return this.timeParms.getLocalTimePopulation();
    }

    public void disaggregate(ReportInput reportInput, ReportInput[] reportInputArray) {
        this.removeInput(reportInput);
        for (int i = 0; i < reportInputArray.length; ++i) {
            this.addInput(reportInputArray[i], false, 0);
        }
    }

    public void reaggregate(ReportInput reportInput, ReportInput[] reportInputArray) {
        this.addInput(reportInput, false, 0);
        for (int i = 0; i < reportInputArray.length; ++i) {
            this.removeInput(reportInputArray[i]);
        }
    }

    protected void removeInput(ReportInput reportInput) {
        int n = this.inputList.indexOf(reportInput);
        if (n >= 0) {
            this.inputList.remove(reportInput);
            this.populationByInput.remove(reportInput);
        }
    }

    public List getInputList() {
        return this.inputList;
    }

    public RegularTimeParameters getTimeParameters() {
        return this.timeParms;
    }

    public void setTimeParameters(RegularTimeParameters regularTimeParameters) {
        this.timeParms = regularTimeParameters;
    }

    public Population getValuePopulation(int n) {
        if (this.popList == null) {
            this.popList = new ArrayList();
        }
        while (this.popList.size() <= n) {
            this.popList.add(null);
        }
        DoWFilterValuePopulation doWFilterValuePopulation = new DoWFilterValuePopulation(n);
        this.popList.set(n, doWFilterValuePopulation);
        return doWFilterValuePopulation;
    }

    public class DoWFilterValuePopulation
    extends Series.ValuePopulation {
        public DoWFilterValuePopulation(int n) {
            super(n);
        }

        public boolean isValid(int n) {
            RegularTimeParameters regularTimeParameters;
            long l;
            if (InterpolatedTimeSeries.this.useBaseline) {
                l = InterpolatedTimeSeries.this.baselineTimeParms.getLocalTime(n % InterpolatedTimeSeries.this.baselineTimeParms.getLocalNumIntervals());
                regularTimeParameters = InterpolatedTimeSeries.this.baselineTimeParms;
            } else {
                l = InterpolatedTimeSeries.this.getTimestamp(n);
                regularTimeParameters = InterpolatedTimeSeries.this.timeParms;
            }
            Calendar calendar = Calendar.getInstance((TimeZone)regularTimeParameters.getDefaultTimeZone().tzSupport());
            calendar.setTime(new Date(l));
            DayOfWeek dayOfWeek = new DayOfWeek(InterpolatedTimeSeries.this.incl_wdays);
            return dayOfWeek.included(calendar);
        }
    }
}

