/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.ExceptionSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.ui.reports.ExceptionReportParameters;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import java.util.ArrayList;
import javax.baja.util.Lexicon;

public class ExceptionReportSummaryTableModel
extends AbstractRowMappedTableModel {
    public static final int INPUT_COL = 0;
    public static final int EXCEPTIONS_COL = 1;
    private ReportInput[] inputs = new ReportInput[0];
    private ExceptionSummary[] summaries = new ExceptionSummary[0];
    private Lexicon lex;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$ReportInput;
    static /* synthetic */ Class class$java$lang$Number;

    public ExceptionReportSummaryTableModel(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public boolean retrieveSummaryData(ExceptionReportParameters exceptionReportParameters) {
        ReportInput[] reportInputArray = exceptionReportParameters.getInputs();
        this.inputs = new ReportInput[reportInputArray.length];
        for (int i = 0; i < reportInputArray.length; ++i) {
            this.inputs[i] = reportInputArray[i].getCopy();
        }
        ArrayList<ExceptionSummary> arrayList = new ArrayList<ExceptionSummary>();
        try {
            for (int i = 0; i < this.inputs.length; ++i) {
                if (!this.inputs[i].isEnabled()) continue;
                DataPoint dataPoint = ((SiteDataPoint)this.inputs[i].getInputItem(0)).getDataPoint();
                double d = exceptionReportParameters.getUpperLimit();
                double d2 = exceptionReportParameters.getLowerLimit();
                if ((exceptionReportParameters.getComparisonMethod() & 0xC0) > 0 && dataPoint.getUnit() != null && !dataPoint.getUnit().isNull()) {
                    d = dataPoint.getUnit().fromNormal(this.inputs[i].getUnit().toNormal(d));
                    d2 = dataPoint.getUnit().fromNormal(this.inputs[i].getUnit().toNormal(d2));
                }
                arrayList.add(ExceptionSummary.getExceptionSummary(dataPoint, exceptionReportParameters.getReportPeriod().getStartTime(), exceptionReportParameters.getReportPeriod().getEndTime(), new TimeInterval(exceptionReportParameters.getRollupIntervalMinutes(), 3), exceptionReportParameters.getDaysOfWeek(), exceptionReportParameters.getStartHour(), exceptionReportParameters.getStartMinute(), exceptionReportParameters.getEndHour(), exceptionReportParameters.getEndMinute(), exceptionReportParameters.getExclusive(), exceptionReportParameters.useTemperatureCorrection(), exceptionReportParameters.getBaselinePeriod().getStartTime(), exceptionReportParameters.getBaselinePeriod().getDurationMinutes() / exceptionReportParameters.getRollupIntervalMinutes(), exceptionReportParameters.getMaxExceptions(), exceptionReportParameters.getComparisonMethod(), d, d2, exceptionReportParameters.getDataCleanse(), exceptionReportParameters.getDataCleanseWindow(), exceptionReportParameters.getDataCleansePercentage(), this.inputs[i].hasNormalizingPoint(), this.inputs[i].getNormalizingPoint()));
            }
        }
        catch (EasException easException) {
            this.summaries = new ExceptionSummary[0];
            this.inputs = new ReportInput[0];
            easException.printStackTrace();
            return false;
        }
        this.summaries = new ExceptionSummary[arrayList.size()];
        arrayList.toArray(this.summaries);
        this.fireTableStructureChanged();
        return true;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return class$com$tridium$eas$ui$reports$ReportInput == null ? (class$com$tridium$eas$ui$reports$ReportInput = ExceptionReportSummaryTableModel.class$("com.tridium.eas.ui.reports.ReportInput")) : class$com$tridium$eas$ui$reports$ReportInput;
            }
            case 1: {
                return class$java$lang$Number == null ? (class$java$lang$Number = ExceptionReportSummaryTableModel.class$("java.lang.Number")) : class$java$lang$Number;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return " ";
            }
            case 1: {
                return "# " + this.lex.getText("exceptions");
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.inputs == null || this.summaries == null ? 0 : this.inputs.length;
    }

    public Object getModelValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.inputs[n];
            }
            case 1: {
                return new Integer(this.summaries[n].getViolationsTotal());
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public ExceptionSummary getSummaryAt(int n) {
        return this.summaries[n];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

