/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.BaselinePeriod;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.util.Lexicon;

public class ExceptionReportParameters
extends ReportParameters {
    private BaselinePeriod baselinePeriod;
    private int rollupIntervalMinutes = 15;
    private double lowerLimit = -0.15;
    private double upperLimit = 0.15;
    private int comparisonMethod = 12;
    private int maxExceptions = 1000;
    private int temperatureColor = 6;
    private boolean useTemperatureCorrection = false;
    private int daysOfWeek = 127;
    private int startHr = 0;
    private int startMin = 0;
    private int endHr = 24;
    private int endMin = 0;
    private boolean exclusive = false;
    public static final int VERSION = -411;

    public ExceptionReportParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public ExceptionReportParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, BaselinePeriod baselinePeriod, int n, double d, double d2, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2, Lexicon lexicon, boolean bl3, int n10, double d3) {
        super(reportInputArray, reportPeriod, 0, lexicon, bl3, n10, d3);
        this.baselinePeriod = baselinePeriod;
        this.rollupIntervalMinutes = n;
        this.lowerLimit = d;
        this.upperLimit = d2;
        this.comparisonMethod = n2;
        this.maxExceptions = n3;
        this.useTemperatureCorrection = bl;
        this.temperatureColor = n4;
        this.daysOfWeek = n5;
        this.startHr = n6;
        this.startMin = n7;
        this.endHr = n8;
        this.endMin = n9;
        this.exclusive = bl2;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        ReportPeriod reportPeriod = reportParameters.getPeriod();
        this.setPeriod(new ReportPeriod(reportPeriod.getCustomPeriod(), reportPeriod.getStartTime(), reportPeriod.getEndTime(), 127, this.lex));
        this.setNormalization(reportParameters.getNormalization());
        this.baselinePeriod = new BaselinePeriod(this.getPeriod(), this.getPeriod().getStartTime(), 1, this.lex);
        this.comparisonMethod = 12;
        this.lowerLimit = -0.15;
        this.upperLimit = 0.15;
        this.maxExceptions = 1000;
        this.temperatureColor = 6;
        this.rollupIntervalMinutes = 360;
        this.daysOfWeek = 127;
        this.startHr = 0;
        this.startMin = 0;
        this.endHr = 24;
        this.endMin = 0;
        this.exclusive = false;
        this.useTemperatureCorrection = false;
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        this.baselinePeriod = new BaselinePeriod(this.lex);
        this.baselinePeriod.load(dataInput);
        this.baselinePeriod.setReportPeriod(this.getReportPeriod());
        this.rollupIntervalMinutes = dataInput.readInt();
        this.lowerLimit = dataInput.readDouble();
        this.upperLimit = dataInput.readDouble();
        this.comparisonMethod = dataInput.readInt();
        this.maxExceptions = dataInput.readInt();
        this.useTemperatureCorrection = dataInput.readBoolean();
        this.temperatureColor = dataInput.readInt();
        int n = dataInput.readInt();
        if (n != -411) {
            this.daysOfWeek = n;
            this.startHr = 0;
            this.startMin = 0;
            this.endHr = 24;
            this.endMin = 0;
            this.exclusive = false;
        } else {
            this.daysOfWeek = dataInput.readInt();
            this.startHr = dataInput.readInt();
            this.startMin = dataInput.readInt();
            this.endHr = dataInput.readInt();
            this.endMin = dataInput.readInt();
            this.exclusive = dataInput.readBoolean();
        }
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        this.baselinePeriod.save(dataOutput);
        dataOutput.writeInt(this.rollupIntervalMinutes);
        dataOutput.writeDouble(this.lowerLimit);
        dataOutput.writeDouble(this.upperLimit);
        dataOutput.writeInt(this.comparisonMethod);
        dataOutput.writeInt(this.maxExceptions);
        dataOutput.writeBoolean(this.useTemperatureCorrection);
        dataOutput.writeInt(this.temperatureColor);
        dataOutput.writeInt(-411);
        dataOutput.writeInt(this.daysOfWeek);
        dataOutput.writeInt(this.startHr);
        dataOutput.writeInt(this.startMin);
        dataOutput.writeInt(this.endHr);
        dataOutput.writeInt(this.endMin);
        dataOutput.writeBoolean(this.exclusive);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("Exception Report\n");
        stringBuffer.append("  Report Period       : ").append(this.getReportPeriod()).append("\n");
        stringBuffer.append("  Baseline Period     : ").append(this.getBaselinePeriod()).append("\n");
        stringBuffer.append("  Rollup Interval     : ").append(this.getRollupIntervalMinutes()).append("\n");
        stringBuffer.append("  Lower Limit         : ").append(this.getLowerLimit()).append("\n");
        stringBuffer.append("  Upper Limit         : ").append(this.getUpperLimit()).append("\n");
        stringBuffer.append("  Comparison          : ").append(this.getComparisonMethod()).append("\n");
        stringBuffer.append("  Max                 : ").append(this.getMaxExceptions()).append("\n");
        return stringBuffer.toString();
    }

    public ReportPeriod getReportPeriod() {
        return super.getPeriod();
    }

    public void setBaselinePeriod(BaselinePeriod baselinePeriod) {
        this.baselinePeriod = baselinePeriod;
    }

    public BaselinePeriod getBaselinePeriod() {
        return this.baselinePeriod;
    }

    public void setRollupIntervalMinutes(int n) {
        this.rollupIntervalMinutes = n;
    }

    public int getRollupIntervalMinutes() {
        return this.rollupIntervalMinutes;
    }

    public long getRollupIntervalMillis() {
        return (long)this.getRollupIntervalMinutes() * 60L * 1000L;
    }

    public void setLowerLimit(double d) {
        this.lowerLimit = d;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setUpperLimit(double d) {
        this.upperLimit = d;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setComparisonMethod(int n) {
        this.comparisonMethod = n;
    }

    public int getComparisonMethod() {
        return this.comparisonMethod;
    }

    public void setMaxExceptions(int n) {
        this.maxExceptions = n;
    }

    public int getMaxExceptions() {
        return this.maxExceptions;
    }

    public void setTemperatureColor(int n) {
        this.temperatureColor = n;
    }

    public int getTemperatureColor() {
        return this.temperatureColor;
    }

    public boolean useTemperatureCorrection() {
        return this.useTemperatureCorrection;
    }

    public void setUseTemperatureCorrection(boolean bl) {
        this.useTemperatureCorrection = bl;
    }

    public void setDaysOfWeek(int n) {
        this.daysOfWeek = n;
    }

    public int getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setStartHour(int n) {
        this.startHr = n;
    }

    public int getStartHour() {
        return this.startHr;
    }

    public void setStartMinute(int n) {
        this.startMin = n;
    }

    public int getStartMinute() {
        return this.startMin;
    }

    public void setEndHour(int n) {
        this.endHr = n;
    }

    public int getEndHour() {
        return this.endHr;
    }

    public void setEndMinute(int n) {
        this.endMin = n;
    }

    public int getEndMinute() {
        return this.endMin;
    }

    public void setExclusive(boolean bl) {
        this.exclusive = bl;
    }

    public boolean getExclusive() {
        return this.exclusive;
    }
}

