/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.ExceptionSummary;
import com.tridium.eas.function.Population;
import com.tridium.eas.ui.reports.ExceptionReportParameters;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import com.tridium.eas.util.CompoundUnitUtil;
import java.util.Date;
import javax.baja.util.Lexicon;

public class ExceptionReportDetailTableModel
extends AbstractRowMappedTableModel {
    private static int[] columnTypes;
    public static final int TIMESTAMP_TYPE = 0;
    public static final int BASELINE_VALUE_TYPE = 1;
    public static final int ACTUAL_VALUE_TYPE = 2;
    public static final int DIFFERENCE_TYPE = 3;
    private ReportInput input;
    private ExceptionReportParameters parms;
    private ExceptionSummary summary;
    private Population baselinePopulation;
    private Population observedPopulation;
    private Population diffPopulation;
    private Lexicon lex;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Number;

    public ExceptionReportDetailTableModel(ReportInput reportInput, ExceptionReportParameters exceptionReportParameters, ExceptionSummary exceptionSummary, Lexicon lexicon) throws EasException {
        this.input = reportInput;
        this.parms = exceptionReportParameters;
        this.summary = exceptionSummary;
        this.lex = lexicon;
        if (reportInput.getUnit() == null || reportInput.getUnit().isNull()) {
            this.baselinePopulation = exceptionSummary.getBaselinePopulation();
            this.observedPopulation = exceptionSummary.getObservedPopulation();
            this.diffPopulation = exceptionSummary.getDiffPopulation();
        } else {
            this.baselinePopulation = exceptionSummary.getBaselinePopulation(reportInput.hasNormalizingPoint() ? CompoundUnitUtil.make(reportInput.getUnit(), reportInput.getNormalizingPoint().getUnit()) : reportInput.getUnit());
            this.observedPopulation = exceptionSummary.getObservedPopulation(reportInput.hasNormalizingPoint() ? CompoundUnitUtil.make(reportInput.getUnit(), reportInput.getNormalizingPoint().getUnit()) : reportInput.getUnit());
            this.diffPopulation = (exceptionSummary.getLimitType() & 0xC) > 0 ? exceptionSummary.getDiffPopulation() : exceptionSummary.getDiffPopulation(reportInput.hasNormalizingPoint() ? CompoundUnitUtil.make(reportInput.getUnit(), reportInput.getNormalizingPoint().getUnit()) : reportInput.getUnit());
        }
        columnTypes = (exceptionSummary.getLimitType() & 0xC0) > 0 ? new int[]{0, 2} : new int[]{0, 1, 2, 3};
        this.retrieveDetailData();
    }

    public boolean retrieveDetailData() {
        return true;
    }

    public Class getColumnClass(int n) {
        switch (columnTypes[n]) {
            case 0: {
                return class$java$util$Date == null ? (class$java$util$Date = ExceptionReportDetailTableModel.class$("java.util.Date")) : class$java$util$Date;
            }
            case 1: 
            case 2: 
            case 3: {
                return class$java$lang$Number == null ? (class$java$lang$Number = ExceptionReportDetailTableModel.class$("java.lang.Number")) : class$java$lang$Number;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public String getColumnName(int n) {
        switch (columnTypes[n]) {
            case 0: {
                return this.lex.getText("time");
            }
            case 1: {
                String string = this.lex.getText("baseline");
                try {
                    string = string + " (" + this.baselinePopulation.getUnit().toString() + ")";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return string;
            }
            case 2: {
                String string = this.lex.getText("observed");
                try {
                    string = string + " (" + this.observedPopulation.getUnit().toString() + ")";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return string;
            }
            case 3: {
                String string = this.lex.getText("difference");
                if ((this.summary.getLimitType() & 0xC) == 0) {
                    try {
                        string = string + " (" + this.diffPopulation.getUnit().toString() + ")";
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return string;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getColumnCount() {
        return columnTypes.length;
    }

    public int getRowCount() {
        return this.summary == null ? 0 : this.summary.getViolationsTotal();
    }

    private int getViolationIndex(int n) {
        return this.summary.getViolations()[n];
    }

    public Object getModelValueAt(int n, int n2) {
        try {
            switch (columnTypes[n2]) {
                case 0: {
                    return new Date(this.summary.getDefaultTime(this.getViolationIndex(n)));
                }
                case 2: {
                    return new Double(this.observedPopulation.getSample(this.getViolationIndex(n)));
                }
                case 1: {
                    return new Double(this.baselinePopulation.getSample(this.getViolationIndex(n)));
                }
                case 3: {
                    return new Double(this.diffPopulation.getSample(this.getViolationIndex(n)));
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return null;
        }
    }

    public int getColumnType(int n) {
        return columnTypes[n];
    }

    public int getColumnIndex(int n) {
        for (int i = 0; i < columnTypes.length; ++i) {
            if (columnTypes[i] != n) continue;
            return i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

