/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.BEasService;
import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.TSDataIrregular;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.EquipmentOperationParameters;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.SiteDataPoint;
import java.awt.Color;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class EquipmentOperationSeries
extends TimeSeries
implements ValueColors {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private ReportInput input;
    private EquipmentOperationParameters params;
    private TSDataIrregular result;
    private long runtime;
    private int numCycles;
    private Lexicon lex;

    public EquipmentOperationSeries(ReportInput reportInput, EquipmentOperationParameters equipmentOperationParameters, Lexicon lexicon) {
        this.input = reportInput;
        this.params = equipmentOperationParameters;
        this.lex = lexicon;
    }

    public void load() throws EasException {
        ReportPeriod reportPeriod = this.params.getPeriod();
        EasLocalTime easLocalTime = reportPeriod.getStartTime();
        EasLocalTime easLocalTime2 = reportPeriod.getEndTime();
        this.numCycles = 0;
        this.runtime = 0L;
        DataPoint dataPoint = ((SiteDataPoint)this.input.getInputItem(0)).getDataPoint();
        this.result = dataPoint.getRawData(easLocalTime, easLocalTime2);
        int n = this.result.getSize();
        long l = -1L;
        long l2 = -1L;
        boolean bl = false;
        boolean bl2 = false;
        if (n > 0) {
            bl2 = this.result.getBool(0);
        }
        for (int i = 0; i < n; ++i) {
            l2 = this.result.getLocalTime(i);
            bl = this.result.getBool(i);
            if (bl && l == -1L) {
                l = l2;
            }
            if (!bl) {
                if (l != -1L) {
                    this.runtime += l2 - l;
                }
                l = -1L;
            }
            if (bl && !bl2) {
                ++this.numCycles;
            }
            bl2 = bl;
        }
        if (bl) {
            this.runtime += this.params.getPeriod().getEndTimeMillis(BTimeZone.getLocal()) - l2;
        }
    }

    public String getSeriesName() {
        return null;
    }

    public ReportInput getInput() {
        return this.input;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public int getNumCycles() {
        return this.numCycles;
    }

    public int getRowCount() {
        return this.result.getSize();
    }

    public int getValueCount() {
        return 1;
    }

    public String getValueName(int n) {
        return this.input.getName();
    }

    public int getValueType() {
        return 3;
    }

    public double getValue(int n, int n2) {
        boolean bl = this.result.getBool(n);
        if (bl) {
            return 1.0;
        }
        return 0.0;
    }

    public Color getValueColor(int n) {
        return this.input.getColor();
    }

    public String getValueLabel(int n, int n2) {
        boolean bl = this.result.getBool(n);
        if (bl) {
            return this.lex.getText("on");
        }
        return this.lex.getText("off");
    }

    public double getMin(int n) {
        return 0.0;
    }

    public double getMax(int n) {
        return 1.0;
    }

    public double getMin() {
        return 0.0;
    }

    public double getMax() {
        return 1.0;
    }

    public BUnit getValueUnits() {
        return BEasService.MULTISTATE;
    }

    public long getTimestamp(int n) {
        return this.result.getLocalTime(n);
    }

    public long getMinTimestamp() {
        return this.params.getPeriod().getStartTimeMillis(BTimeZone.getLocal());
    }

    public long getMaxTimestamp() {
        return this.params.getPeriod().getEndTimeMillis(BTimeZone.getLocal());
    }
}

