/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.FuncAggregatedData;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.SiteSummary;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.reports.EnterpriseRankingParameters;
import com.tridium.eas.ui.reports.Rank;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.SiteInputItem;
import java.awt.Color;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class EnterpriseRankingSeries
extends Series
implements ValueColors {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private EnterpriseRankingParameters params;
    private Rank[] ranking;
    private double[] range;
    private Lexicon lex;

    public EnterpriseRankingSeries(EnterpriseRankingParameters enterpriseRankingParameters, Lexicon lexicon) {
        this.params = enterpriseRankingParameters;
        this.ranking = this.ranking;
        this.lex = lexicon;
    }

    public String getSeriesName() {
        return null;
    }

    public ReportInput getInput(int n) {
        if (this.ranking[n] == null) {
            return null;
        }
        return this.ranking[n].getInput();
    }

    public void load(EasSession easSession, InputList inputList) {
        int n;
        this.range = null;
        ReportInput[] reportInputArray = this.params.getInputs();
        Site[] siteArray = null;
        boolean[] blArray = null;
        DataPoint[] dataPointArray = null;
        if (reportInputArray != null && reportInputArray.length != 0) {
            siteArray = new Site[reportInputArray.length];
            blArray = new boolean[reportInputArray.length];
            dataPointArray = new DataPoint[reportInputArray.length];
            for (n = 0; n < reportInputArray.length; ++n) {
                siteArray[n] = ((SiteInputItem)reportInputArray[n].getInputItem(0)).getSite();
                blArray[n] = reportInputArray[n].hasNormalizingPoint();
                dataPointArray[n] = reportInputArray[n].getNormalizingPoint();
            }
        } else {
            blArray = new boolean[]{};
            dataPointArray = new DataPoint[]{};
        }
        if (this.isTotal(this.params.getRcSubtype())) {
            n = 1;
        } else if (this.isPeak(this.params.getRcSubtype())) {
            n = 5;
        } else {
            return;
        }
        if (this.params.getOrder() == 1) {
            n *= -1;
        }
        EasLocalTime easLocalTime = this.params.getPeriod().getStartTime();
        EasLocalTime easLocalTime2 = this.params.getPeriod().getEndTime();
        String string = null;
        if ((this.params.getNormalization() & 2) != 0) {
            string = "floorarea";
        }
        boolean bl = (this.params.getNormalization() & 4) != 0;
        RcType rcType = this.params.getRcType();
        int n2 = rcType == null ? RcType.OTHER.getCode() : rcType.getCode();
        RcSubtype rcSubtype = this.params.getRcSubtype();
        int n3 = rcSubtype == null ? RcSubtype.OTHER.getCode() : rcSubtype.getCode();
        SiteSummary[] siteSummaryArray = null;
        try {
            siteSummaryArray = FuncAggregatedData.getResult(siteArray, n2, n3, true, this.params.getResultSize(), string, n, easLocalTime, easLocalTime2, this.params.getPeriod().getDaysOfWeek(), 0, 3, 15, bl, this.params.getNormalTemperature(), this.params.getNormalTemperatureUnit(), easSession, this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), blArray, dataPointArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (siteSummaryArray != null) {
            this.createRanking(easSession, inputList, reportInputArray, siteSummaryArray);
        }
    }

    private void createRanking(EasSession easSession, InputList inputList, ReportInput[] reportInputArray, SiteSummary[] siteSummaryArray) {
        int n = siteSummaryArray == null ? 0 : siteSummaryArray.length;
        int n2 = reportInputArray == null ? 0 : reportInputArray.length;
        this.ranking = new Rank[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            long l = siteSummaryArray[i].getSiteId();
            for (int j = 0; j < n2; ++j) {
                object = ((SiteInputItem)reportInputArray[j].getInputItem(0)).getSite();
                if (l != (long)((EasObject)object).getId()) continue;
                this.ranking[i] = new Rank(reportInputArray[j], siteSummaryArray[i]);
                break;
            }
            if (this.ranking[i] != null) continue;
            try {
                Site site = siteSummaryArray[i].getSite(easSession);
                object = new ReportInput(null, null, new SiteInputItem(site, this.lex), this.lex);
                inputList.getModel().addInput((ReportInput)object);
                this.ranking[i] = new Rank((ReportInput)object, siteSummaryArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean isTotal(RcSubtype rcSubtype) {
        return rcSubtype == RcSubtype.CONSUMPTION || rcSubtype == RcSubtype.VOLUME || rcSubtype == RcSubtype.APPARENT_ENERGY || rcSubtype == RcSubtype.REACTIVE_ENERGY;
    }

    private boolean isPeak(RcSubtype rcSubtype) {
        return rcSubtype == RcSubtype.DEMAND || rcSubtype == RcSubtype.PEAK_FLOW || rcSubtype == RcSubtype.APPARENT_POWER || rcSubtype == RcSubtype.REACTIVE_POWER;
    }

    public int getRowCount() {
        return this.ranking.length;
    }

    public String getRowName(int n) {
        try {
            if (this.ranking[n] == null) {
                return null;
            }
            return this.ranking[n].getInput().getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Error";
        }
    }

    public int getValueCount() {
        return this.ranking.length;
    }

    public int getValueType() {
        return 0;
    }

    public double getValue(int n, int n2) {
        if (n != n2 || this.ranking[n2] == null) {
            return 0.0;
        }
        RcSubtype rcSubtype = this.params.getRcSubtype();
        if ((rcSubtype == null || this.isTotal(rcSubtype)) && this.ranking[n2].getResult().isValid()) {
            return this.ranking[n2].getResult().getTotalConsumption();
        }
        if (this.isPeak(rcSubtype) && this.ranking[n2].getResult().isValid()) {
            return this.ranking[n2].getResult().getPeakDemand();
        }
        return 0.0;
    }

    public Color getValueColor(int n) {
        if (this.ranking[n] == null) {
            return Color.black;
        }
        return this.ranking[n].getInput().getColor();
    }

    public double getMin(int n) {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[0];
    }

    public double getMax(int n) {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[1];
    }

    private void computeRange() {
        this.range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        int n = this.getValueCount();
        for (int i = 0; i < n; ++i) {
            double d = this.getValue(i, i);
            this.range[0] = Math.min(this.range[0], d);
            this.range[1] = Math.max(this.range[1], d);
        }
        if (this.range[0] == this.range[1]) {
            this.range[1] = this.range[1] + 100.0;
        }
    }

    public double getMinRowTotal() {
        return this.getMin();
    }

    public double getMaxRowTotal() {
        return this.getMax();
    }

    public BUnit getValueUnits() {
        if (this.ranking == null || this.ranking.length == 0 || this.ranking[0] == null) {
            return null;
        }
        return this.ranking[0].getResult().getConsumptionUnit();
    }
}

