/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultBarConfig;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.EasReportTable;
import com.tridium.eas.ui.reports.EnterpriseRankingParameters;
import com.tridium.eas.ui.reports.EnterpriseRankingSeries;
import com.tridium.eas.ui.reports.EnterpriseRankingTableModel;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.widgets.EasTable;
import com.tridium.eas.ui.widgets.GridBagManager;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.eas.ui.widgets.TemperatureEditor;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Iterator;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class EnterpriseRanking
extends EasReport {
    public static final String TEMPLATE_ID = "entRanking";
    private Chart chart;
    private EasTable table;
    private Config config;
    static /* synthetic */ Class class$com$tridium$eas$api$DataPoint;
    static /* synthetic */ Class class$com$tridium$eas$api$Meter;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$SiteInputItem;

    public String getName() {
        return this.lex.getText("enterpriseRank");
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected JComponent getReportContent() {
        if (this.chart == null) {
            this.chart = new Chart(this.lex);
            this.chart.setChartStatus(this);
        }
        return this.chart;
    }

    protected JComponent getReportDetails() {
        if (this.table == null) {
            this.table = new EasReportTable((TableModel)new EnterpriseRankingTableModel(this.lex), false, this.lex);
        }
        return this.table.getScrollPane();
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        ChartModel chartModel = new ChartModel();
        chartModel.setTitle(this.getName());
        this.chart.setModel(chartModel);
        this.lang = this.getParameter("lang", "en");
        this.lex = BEasApplet.lex;
    }

    public boolean allowLoadUserObject(Class clazz) {
        if ((class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = EnterpriseRanking.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = EnterpriseRanking.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter).isAssignableFrom(clazz)) {
            return false;
        }
        return super.allowLoadUserObject(clazz);
    }

    public Class getInputItemClass() {
        return class$com$tridium$eas$ui$reports$SiteInputItem == null ? (class$com$tridium$eas$ui$reports$SiteInputItem = EnterpriseRanking.class$("com.tridium.eas.ui.reports.SiteInputItem")) : class$com$tridium$eas$ui$reports$SiteInputItem;
    }

    public ReportParameters createEmptyParameters() {
        return new EnterpriseRankingParameters(this.lex);
    }

    public ReportParameters getReportParameters(boolean bl) {
        SpecificType specificType = this.config.getSpecificType();
        return new EnterpriseRankingParameters(this.getInputList().getModel().getInputs(), this.config.getPeriod(!bl), this.config.getOrder(), this.config.getResultSize(), specificType.type, specificType.subtype, this.config.getDataPointName(), this.config.getNormalization(), this.config.getNormalTemperature(), this.config.getNormalTemperatureUnit(), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    public void setReportParameters(ReportParameters reportParameters) {
        EnterpriseRankingParameters enterpriseRankingParameters = (EnterpriseRankingParameters)reportParameters;
        this.config.setOrder(enterpriseRankingParameters.getOrder());
        this.config.setResultSize(enterpriseRankingParameters.getResultSize());
        this.config.setSpecificType(new SpecificType(enterpriseRankingParameters.getRcType(), enterpriseRankingParameters.getRcSubtype(), this.lex));
        this.config.setDataPointName(enterpriseRankingParameters.getDataPointName());
        this.getInputList().getModel().setInputs(enterpriseRankingParameters.getInputs());
        this.config.setPeriod(enterpriseRankingParameters.getPeriod());
        this.config.setNormalization(enterpriseRankingParameters.getNormalization());
        this.config.setNormalTemperature(enterpriseRankingParameters.getNormalTemperature());
        this.config.setNormalTemperatureUnit(enterpriseRankingParameters.getNormalTemperatureUnit());
        this.setDataCleanse(enterpriseRankingParameters.getDataCleanse());
        this.setDataCleanseWindow(enterpriseRankingParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(enterpriseRankingParameters.getDataCleansePercentage());
    }

    public void runReport(ReportParameters reportParameters) {
        EnterpriseRankingParameters enterpriseRankingParameters = (EnterpriseRankingParameters)reportParameters;
        EnterpriseRankingSeries enterpriseRankingSeries = new EnterpriseRankingSeries(enterpriseRankingParameters, this.lex);
        enterpriseRankingSeries.load(this.getSession(), this.getInputList());
        ReportPeriod reportPeriod = enterpriseRankingParameters.getPeriod();
        String string = reportPeriod.getDateRangeString();
        this.chart.setSubtitle(string);
        this.chart.getModel().setSeries(enterpriseRankingSeries, new DefaultBarConfig(enterpriseRankingSeries), null, null);
        this.table.setModel(new EnterpriseRankingTableModel(enterpriseRankingSeries, this.lex));
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            book.append(this.chart, pageFormat);
            Iterator iterator = this.table.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
        }
        return book;
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            this.chart.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chart.setShowGrid(bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SpecificType {
        public RcType type;
        public RcSubtype subtype;
        private String str;
        private Lexicon lex;

        public SpecificType(RcType rcType, RcSubtype rcSubtype, Lexicon lexicon) {
            rcType.description = lexicon.getText(rcType.description);
            this.type = rcType;
            this.lex = lexicon;
            rcSubtype.description = lexicon.getText(rcSubtype.description);
            this.subtype = rcSubtype;
        }

        public String toString() {
            if (this.str == null) {
                this.str = this.type.getDescription(this.lex);
                if (this.type != RcType.PRODUCTION_UNITS && this.type != RcType.OTHER_CONSUMPTION && this.subtype != null) {
                    this.str = this.str + " " + this.subtype.getDescription(this.lex);
                }
            }
            return this.str;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SpecificType)) {
                return false;
            }
            SpecificType specificType = (SpecificType)object;
            return specificType.type == this.type && specificType.subtype == this.subtype;
        }
    }

    private class Config
    extends JComponent {
        private XpComboBox orderChoice;
        private NumberTextField sizeField;
        private XpComboBox dpChoice;
        private ReportPeriodEditor periodEditor;
        private JCheckBox normFloorArea;
        private JCheckBox normWeather;
        private TemperatureEditor tempEditor;

        public Config() {
            Object object;
            EnterpriseRanking.this.lex = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            JPanel jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(EnterpriseRanking.this.lex.getText("ranking")));
            int n2 = 0;
            GridBagManager gridBagManager = new GridBagManager(jPanel);
            gridBagManager.insets(new Insets(0, 0, 4, 2));
            gridBagManager.anchor(17);
            JLabel jLabel = new JLabel(EnterpriseRanking.this.lex.getText("order"));
            jLabel.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, n2, jLabel);
            this.orderChoice = new XpComboBox();
            this.orderChoice.setFont(font);
            this.orderChoice.addItem(EnterpriseRanking.this.lex.getText("highest"));
            this.orderChoice.addItem(EnterpriseRanking.this.lex.getText("lowest"));
            gridBagManager.add(100, 100, 1, 1, 1, n2++, this.orderChoice);
            jLabel = new JLabel(EnterpriseRanking.this.lex.getText("resultSize"));
            jLabel.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, n2, jLabel);
            this.sizeField = new NumberTextField(3, true);
            this.sizeField.setAllowNegative(false);
            gridBagManager.add(100, 100, 1, 1, 1, n2++, this.sizeField);
            this.sizeField.setFont(font);
            this.sizeField.setText("10");
            jLabel = new JLabel(EnterpriseRanking.this.lex.getText("dataPoint"));
            jLabel.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, n2, jLabel);
            this.dpChoice = new XpComboBox();
            this.dpChoice.setFont(font);
            RcType[] rcTypeArray = RcType.getAll();
            for (int i = 0; i < rcTypeArray.length; ++i) {
                if (rcTypeArray[i] == RcType.OTHER || rcTypeArray[i] == RcType.OUTSIDE_AIR_TEMP) continue;
                object = rcTypeArray[i].getValidSubtypes();
                if (((RcSubtype[])object).length == 0) {
                    this.dpChoice.addItem(new SpecificType(rcTypeArray[i], null, EnterpriseRanking.this.lex));
                    continue;
                }
                for (int j = 0; j < ((RcSubtype[])object).length; ++j) {
                    if (object[j] == RcSubtype.OTHER || object[j] == RcSubtype.POWER_FACTOR) continue;
                    this.dpChoice.addItem(new SpecificType(rcTypeArray[i], object[j], EnterpriseRanking.this.lex));
                }
            }
            gridBagManager.add(100, 100, 1, 1, 1, n2++, this.dpChoice);
            this.add(jPanel);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.periodEditor = new ReportPeriodEditor(EnterpriseRanking.this.lex);
            this.periodEditor.setBorder(BorderFactory.createTitledBorder(EnterpriseRanking.this.lex.getText("period")));
            this.add(this.periodEditor);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(this.periodEditor, gridBagConstraints);
            JPanel jPanel2 = new JPanel(false);
            object = new GridBagManager(jPanel2);
            ((GridBagManager)object).anchor(17);
            this.add(jPanel2);
            this.normFloorArea = new JCheckBox(EnterpriseRanking.this.lex.getText("floorArea"));
            this.normFloorArea.setFont(font);
            ((GridBagManager)object).add(0, 0, 2, 1, 0, 0, this.normFloorArea);
            this.normWeather = new JCheckBox(EnterpriseRanking.this.lex.getText("degreeDay"));
            this.normWeather.setFont(font);
            ((GridBagManager)object).add(0, 100, 1, 1, 0, 1, this.normWeather);
            this.tempEditor = new TemperatureEditor(65, BUnit.getUnit((String)"fahrenheit"), EnterpriseRanking.this.lex);
            ((GridBagManager)object).add(100, 100, 1, 1, 1, 1, this.tempEditor);
            jPanel2.setBorder(BorderFactory.createTitledBorder(EnterpriseRanking.this.lex.getText("normalization")));
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            JLabel jLabel2 = new JLabel("");
            this.add(jLabel2);
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        }

        public int getOrder() {
            return this.orderChoice.getSelectedIndex();
        }

        public void setOrder(int n) {
            this.orderChoice.setSelectedIndex(n);
        }

        public int getResultSize() {
            return this.sizeField.getIntValue();
        }

        public void setResultSize(int n) {
            this.sizeField.setText(Integer.toString(n));
        }

        public SpecificType getSpecificType() {
            return (SpecificType)this.dpChoice.getSelectedItem();
        }

        public void setSpecificType(SpecificType specificType) {
            int n = this.dpChoice.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!this.dpChoice.getItemAt(i).equals(specificType)) continue;
                this.dpChoice.setSelectedIndex(i);
                break;
            }
        }

        public String getDataPointName() {
            return null;
        }

        public void setDataPointName(String string) {
        }

        public ReportPeriod getPeriod(boolean bl) {
            return (ReportPeriod)this.periodEditor.getValue(bl);
        }

        public void setPeriod(ReportPeriod reportPeriod) {
            this.periodEditor.setValue(reportPeriod);
        }

        public int getNormalization() {
            int n = 0;
            if (this.normFloorArea.isSelected()) {
                n |= 2;
            }
            if (this.normWeather.isSelected()) {
                n |= 4;
            }
            return n;
        }

        public void setNormalization(int n) {
            this.normFloorArea.setSelected((n & 2) != 0);
            this.normWeather.setSelected((n & 4) != 0);
        }

        public double getNormalTemperature() {
            return this.tempEditor.getValue();
        }

        public void setNormalTemperature(double d) {
            this.tempEditor.setValue(d);
        }

        public BUnit getNormalTemperatureUnit() {
            return this.tempEditor.getUnit();
        }

        public void setNormalTemperatureUnit(BUnit bUnit) {
            this.tempEditor.setUnit(bUnit);
        }
    }
}

