/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.reports.AverageProfileSeries;
import com.tridium.eas.ui.reports.AvgProfileParameters;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import com.tridium.eas.util.CompoundUnitUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.baja.sys.BAbsTime;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class AverageProfileTableModel
extends AbstractRowMappedTableModel {
    private AvgProfileParameters params;
    private AverageProfileSeries[] seriesList;
    private String[] timeLabels;
    private boolean holdUpdates = false;
    private int rowCount = -1;
    private Lexicon lex;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public AverageProfileTableModel(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public void setHoldUpdates(boolean bl) {
        if (bl == this.holdUpdates) {
            return;
        }
        this.holdUpdates = bl;
        if (!this.holdUpdates) {
            this.fireTableStructureChanged();
        }
    }

    private void reset() {
        this.rowCount = -1;
        this.timeLabels = null;
    }

    public void setData(AvgProfileParameters avgProfileParameters, AverageProfileSeries[] averageProfileSeriesArray) {
        this.params = avgProfileParameters;
        this.seriesList = averageProfileSeriesArray;
        this.reset();
        if (!this.holdUpdates) {
            this.fireTableStructureChanged();
        }
    }

    public void addSeries(AverageProfileSeries averageProfileSeries) {
        if (this.seriesList == null) {
            this.seriesList = new AverageProfileSeries[]{averageProfileSeries};
        } else {
            AverageProfileSeries[] averageProfileSeriesArray = new AverageProfileSeries[this.seriesList.length + 1];
            System.arraycopy(this.seriesList, 0, averageProfileSeriesArray, 0, this.seriesList.length);
            averageProfileSeriesArray[this.seriesList.length] = averageProfileSeries;
            this.seriesList = averageProfileSeriesArray;
        }
        this.reset();
        if (!this.holdUpdates) {
            this.fireTableStructureChanged();
        }
    }

    public void addSeries(AverageProfileSeries[] averageProfileSeriesArray) {
        if (this.seriesList == null) {
            this.seriesList = averageProfileSeriesArray;
        } else {
            AverageProfileSeries[] averageProfileSeriesArray2 = new AverageProfileSeries[this.seriesList.length + averageProfileSeriesArray.length];
            System.arraycopy(this.seriesList, 0, averageProfileSeriesArray2, 0, this.seriesList.length);
            System.arraycopy(averageProfileSeriesArray, 0, averageProfileSeriesArray2, this.seriesList.length, averageProfileSeriesArray.length);
            this.seriesList = averageProfileSeriesArray2;
        }
        this.reset();
        if (!this.holdUpdates) {
            this.fireTableStructureChanged();
        }
    }

    public void addSeries(Collection collection) {
        if (this.seriesList == null) {
            this.seriesList = collection.toArray(new AverageProfileSeries[0]);
        } else {
            AverageProfileSeries[] averageProfileSeriesArray = new AverageProfileSeries[this.seriesList.length + collection.size()];
            System.arraycopy(this.seriesList, 0, averageProfileSeriesArray, 0, this.seriesList.length);
            int n = this.seriesList.length;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                averageProfileSeriesArray[n++] = (AverageProfileSeries)iterator.next();
            }
            this.seriesList = averageProfileSeriesArray;
        }
        this.reset();
        if (!this.holdUpdates) {
            this.fireTableStructureChanged();
        }
    }

    public void removeSeries(AverageProfileSeries averageProfileSeries) {
        int n = this.seriesList == null ? 0 : this.seriesList.length;
        for (int i = 0; i < n; ++i) {
            if (this.seriesList[i] != averageProfileSeries) continue;
            this.removeSeries(i);
            break;
        }
    }

    public void removeSeries(int n) {
        int n2 = this.seriesList == null ? 0 : this.seriesList.length;
        AverageProfileSeries[] averageProfileSeriesArray = new AverageProfileSeries[this.seriesList.length - 1];
        if (n > 0) {
            System.arraycopy(this.seriesList, 0, averageProfileSeriesArray, 0, n);
        }
        if (n < n2 - 1) {
            System.arraycopy(this.seriesList, n + 1, averageProfileSeriesArray, n, n2 - n - 1);
        }
        this.seriesList = averageProfileSeriesArray;
        this.reset();
        if (!this.holdUpdates) {
            this.fireTableStructureChanged();
        }
    }

    public int getRowCount() {
        if (this.rowCount == -1) {
            if (this.seriesList == null) {
                return 0;
            }
            this.rowCount = 0;
            int n = this.seriesList == null ? 0 : this.seriesList.length;
            for (int i = 0; i < n; ++i) {
                this.rowCount = Math.max(this.rowCount, this.seriesList[i].getRowCount());
            }
        }
        return this.rowCount;
    }

    public int getColumnCount() {
        if (this.seriesList == null || this.seriesList.length == 0) {
            return 2;
        }
        return 1 + this.seriesList.length;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return this.lex.getText("timeOfDay");
        }
        if (this.seriesList == null || this.seriesList.length == 0) {
            return this.lex.getText("inputName");
        }
        ReportInput reportInput = this.seriesList[n - 1].getInput();
        BUnit bUnit = reportInput.getUnit();
        if (bUnit != null) {
            try {
                if (reportInput.hasNormalizingPoint()) {
                    bUnit = CompoundUnitUtil.make(bUnit, reportInput.getNormalizingPoint().getUnit());
                }
                if (this.params.isNormalizedByFloorArea()) {
                    bUnit = CompoundUnitUtil.make(bUnit, ((SiteDataPoint)reportInput.getInputItem(0)).getDataPoint().getFloorAreaUnit());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String string = reportInput.getName();
        if (bUnit == null) {
            return string;
        }
        return string + " (" + bUnit.toString() + ")";
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$java$lang$String == null ? (class$java$lang$String = AverageProfileTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return class$java$lang$Number == null ? (class$java$lang$Number = AverageProfileTableModel.class$("java.lang.Number")) : class$java$lang$Number;
    }

    public Object getModelValueAt(int n, int n2) {
        if (n2 == 0) {
            if (this.timeLabels == null) {
                this.timeLabels = new String[this.getRowCount()];
                int n3 = this.params.getInterval();
                int n4 = 0;
                StringBuffer stringBuffer = new StringBuffer(5);
                BTimeZone bTimeZone = this.params.getTimeZone();
                ReportPeriod reportPeriod = this.params.getPeriod();
                long l = reportPeriod.getStartTimeMillis(bTimeZone);
                long l2 = reportPeriod.getEndTimeMillis(bTimeZone);
                long l3 = l2 - l;
                boolean bl = BAbsTime.make((long)l, (BTimeZone)bTimeZone).inDaylightTime();
                boolean bl2 = BAbsTime.make((long)l2, (BTimeZone)bTimeZone).inDaylightTime();
                boolean bl3 = l3 <= 86400000L && !bl && bl2 || l3 <= 90000000L && bl && !bl2;
                for (int i = 0; i < this.timeLabels.length; ++i) {
                    int n5 = n4 / 60;
                    int n6 = n4 % 60;
                    if (bl3) {
                        BAbsTime bAbsTime = BAbsTime.make((long)(l + (long)n4 * 60L * 1000L), (BTimeZone)bTimeZone);
                        n5 = bAbsTime.getHour();
                        n6 = bAbsTime.getMinute();
                    }
                    stringBuffer.append(n5);
                    stringBuffer.append(':');
                    if (n6 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n6);
                    this.timeLabels[i] = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    n4 += n3;
                }
            }
            return this.timeLabels[n];
        }
        double d = this.seriesList[n2 - 1].getValue(n, 0);
        return new Double(d);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

