/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.FuncDataSummary;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.AvgProfileParameters;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import java.awt.Color;
import javax.baja.sys.BAbsTime;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class AverageProfileSeries
extends Series
implements ValueColors {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private ReportInput input;
    private AvgProfileParameters params;
    private TSDataSummary result;
    private TSDataSummary[] results;
    private double[] range;
    private RcSubtype rcSubtype;
    private Lexicon lex;

    public AverageProfileSeries(ReportInput reportInput, AvgProfileParameters avgProfileParameters, Lexicon lexicon) {
        this.input = reportInput;
        this.params = avgProfileParameters;
        this.lex = lexicon;
    }

    public AverageProfileSeries(ReportInput reportInput, AvgProfileParameters avgProfileParameters, TSDataSummary tSDataSummary, Lexicon lexicon) {
        this.input = reportInput;
        this.params = avgProfileParameters;
        this.result = tSDataSummary;
        this.lex = lexicon;
        this.results = reportInput.getInputItemCount() == 1 ? new TSDataSummary[]{tSDataSummary} : new TSDataSummary[reportInput.getInputItemCount()];
        try {
            this.rcSubtype = ((SiteDataPoint)reportInput.getInputItem(0)).getDataPoint().getRcSubTypeObj();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.rcSubtype = RcSubtype.OTHER;
        }
    }

    public String getSeriesName() {
        return this.lex.getText("avgProfile");
    }

    public ReportInput getInput() {
        return this.input;
    }

    public int getInputItemCount() {
        return this.input.getInputItemCount();
    }

    public ReportInputItem getInputItem(int n) {
        return this.input.getInputItem(n);
    }

    public TSDataSummary getResultForIndex(int n) {
        try {
            if (this.results[n] == null) {
                ReportInputItem[] reportInputItemArray = this.input.getInputItems();
                ReportPeriod reportPeriod = this.params.getPeriod();
                int n2 = this.params.getInterval();
                DataPoint[] dataPointArray = new DataPoint[]{((SiteDataPoint)reportInputItemArray[n]).getDataPoint()};
                int n3 = 24;
                BTimeZone bTimeZone = dataPointArray[0].getTimeZone();
                long l = reportPeriod.getStartTimeMillis(bTimeZone);
                long l2 = reportPeriod.getEndTimeMillis(bTimeZone);
                long l3 = l2 - l;
                boolean bl = BAbsTime.make((long)l, (BTimeZone)bTimeZone).inDaylightTime();
                boolean bl2 = BAbsTime.make((long)l2, (BTimeZone)bTimeZone).inDaylightTime();
                if (l3 <= 90000000L && bl && !bl2) {
                    n3 = 25;
                } else if (l3 <= 86400000L && !bl && bl2) {
                    n3 = 23;
                }
                this.results[n] = FuncDataSummary.getCycled(dataPointArray, this.input.getUnit(), reportPeriod.getStartTime(), reportPeriod.getEndTime(), reportPeriod.getDaysOfWeek(), 0, new TimeInterval(n2, 3), n3 * (60 / n2), this.params.isNormalizedByFloorArea(), dataPointArray[0].getFloorAreaUnit(), this.params.isNormalizedByTemperature(), this.params.getNormalTemperature(), this.params.getNormalTemperatureUnit(), this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), this.input.hasNormalizingPoint(), this.input.getNormalizingPoint());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.results[n];
    }

    public TSDataSummary getResultForInputItem(ReportInputItem reportInputItem) {
        int n = this.input.getInputItemCount();
        for (int i = 0; i < n; ++i) {
            if (this.input.getInputItem(i) != reportInputItem) continue;
            return this.getResultForIndex(i);
        }
        return null;
    }

    public AvgProfileParameters getParameters() {
        return this.params;
    }

    public void setParameters(AvgProfileParameters avgProfileParameters) {
        this.params = avgProfileParameters;
    }

    public int getRowCount() {
        return this.result.getSize();
    }

    public double getValue(int n, int n2) {
        try {
            return this.result.getDataSummary(n).getAvgDemand();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0;
        }
    }

    public int getValueType() {
        return 0;
    }

    public BUnit getValueUnits() {
        return this.result.getValueUnit();
    }

    public Color getValueColor(int n) {
        return this.input.getColor();
    }

    public double getMin(int n) {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[0];
    }

    public double getMax(int n) {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[1];
    }

    private void computeRange() {
        int n = this.getRowCount();
        this.range = new double[2];
        if (n == 0) {
            this.range[0] = 0.0;
            this.range[1] = 100.0;
            return;
        }
        this.range[0] = Double.MAX_VALUE;
        this.range[1] = -1.7976931348623157E308;
        for (int i = 0; i < n; ++i) {
            double d = this.getValue(i, 0);
            this.range[0] = Math.min(this.range[0], d);
            this.range[1] = Math.max(this.range[1], d);
        }
        if (n == 1) {
            this.range[0] = this.range[0] - 10.0;
            this.range[1] = this.range[1] + 10.0;
        }
    }

    public void load() {
        this.range = null;
        ReportInputItem[] reportInputItemArray = this.input.getInputItems();
        int n = this.params.getInterval();
        ReportPeriod reportPeriod = this.params.getPeriod();
        try {
            this.rcSubtype = ((SiteDataPoint)reportInputItemArray[0]).getDataPoint().getRcSubTypeObj();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.rcSubtype = RcSubtype.OTHER;
        }
        try {
            int n2;
            int n3 = reportInputItemArray.length;
            DataPoint[] dataPointArray = new DataPoint[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                dataPointArray[n2] = ((SiteDataPoint)reportInputItemArray[n2]).getDataPoint();
            }
            this.results = new TSDataSummary[n3];
            n2 = 24;
            if (n3 > 0) {
                BTimeZone bTimeZone = dataPointArray[0].getTimeZone();
                long l = reportPeriod.getStartTimeMillis(bTimeZone);
                long l2 = reportPeriod.getEndTimeMillis(bTimeZone);
                long l3 = l2 - l;
                boolean bl = BAbsTime.make((long)l, (BTimeZone)bTimeZone).inDaylightTime();
                boolean bl2 = BAbsTime.make((long)l2, (BTimeZone)bTimeZone).inDaylightTime();
                if (l3 <= 90000000L && bl && !bl2) {
                    n2 = 25;
                } else if (l3 <= 86400000L && !bl && bl2) {
                    n2 = 23;
                }
            }
            this.result = FuncDataSummary.getCycled(dataPointArray, this.input.getUnit(), reportPeriod.getStartTime(), reportPeriod.getEndTime(), reportPeriod.getDaysOfWeek(), 0, new TimeInterval(n, 3), n2 * (60 / n), this.params.isNormalizedByFloorArea(), dataPointArray[0].getFloorAreaUnit(), this.params.isNormalizedByTemperature(), this.params.getNormalTemperature(), this.params.getNormalTemperatureUnit(), this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), this.input.hasNormalizingPoint(), this.input.getNormalizingPoint());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

