/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class AggregationAnalysisParameters
extends ReportParameters {
    private int chartValue = 0;

    public AggregationAnalysisParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public AggregationAnalysisParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, double d, BUnit bUnit, int n2, Lexicon lexicon, boolean bl, int n3, double d2) {
        super(reportInputArray, reportPeriod, n, d, bUnit, false, lexicon, bl, n3, d2);
        this.chartValue = n2;
    }

    public int getChartValue() {
        return this.chartValue;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        int n = reportParameters.getPeriod().getStartTime().getYear();
        this.setPeriod(new ReportPeriod(new EasLocalTime(n, 0, 1), new EasLocalTime(n + 1, 0, 1), 127, this.lex));
        this.setNormalization(reportParameters.getNormalization());
        this.setNormalTemperature(reportParameters.getNormalTemperature());
        this.setNormalTemperatureUnit(reportParameters.getNormalTemperatureUnit());
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    protected boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        this.chartValue = dataInput.readInt();
        return true;
    }

    protected void saveParams(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.chartValue);
    }
}

