/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.reports.AggregationAnalysis;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import java.text.DateFormatSymbols;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class AggAnalysisTableModel
extends AbstractRowMappedTableModel {
    public static final int MONTH = 0;
    public static final int CONSUMPTION = 1;
    public static final int PEAK = 2;
    public static final int MIN = 3;
    public static final int LOAD_FACTOR = 4;
    private AggregationAnalysis.MonthData[] months;
    private double total;
    private double peak;
    private double min;
    private double loadFactor;
    private DateFormatSymbols dateSymbols;
    private BUnit consumptionUnit;
    private BUnit demandUnit;
    private Lexicon lex;
    private String lang;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public AggAnalysisTableModel(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public AggAnalysisTableModel(Lexicon lexicon, AggregationAnalysis.MonthData[] monthDataArray, BUnit bUnit, BUnit bUnit2, int n) {
        int n2;
        int n3;
        this.lex = lexicon;
        this.months = monthDataArray;
        this.demandUnit = bUnit2;
        this.consumptionUnit = bUnit;
        if (monthDataArray != null) {
            this.min = Double.MAX_VALUE;
            n3 = monthDataArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                this.total += monthDataArray[n2].consumption;
                if (monthDataArray[n2].peakDemand != 0.0) {
                    this.peak = Math.max(this.peak, monthDataArray[n2].peakDemand);
                }
                if (monthDataArray[n2].minDemand == 0.0) continue;
                this.min = Math.min(this.min, monthDataArray[n2].minDemand);
            }
            if (this.min == Double.MAX_VALUE) {
                this.min = 0.0;
            }
        } else {
            this.min = 0.0;
        }
        if (this.peak != 0.0) {
            n3 = ReportPeriod.getDaysInYear(n);
            n2 = n3 * 24;
            this.loadFactor = this.total / (this.peak * (double)n2);
        } else {
            this.loadFactor = 0.0;
        }
    }

    public int getRowCount() {
        if (this.months == null) {
            return 0;
        }
        return this.months.length + 1;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return this.lex.getText("month");
            }
            case 1: {
                if (this.consumptionUnit == null) {
                    return this.lex.getText("totalConsumption");
                }
                return this.lex.getText("totalConsumption") + " (" + this.consumptionUnit.toString() + ")";
            }
            case 2: {
                if (this.demandUnit == null) {
                    return this.lex.getText("peak");
                }
                return this.lex.getText("peak") + " (" + this.demandUnit.toString() + ")";
            }
            case 3: {
                if (this.demandUnit == null) {
                    return this.lex.getText("Min");
                }
                return this.lex.getText("Min") + " (" + this.demandUnit.toString() + ")";
            }
            case 4: {
                return this.lex.getText("loadFactor");
            }
        }
        return this.lex.getText("error");
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$java$lang$String == null ? (class$java$lang$String = AggAnalysisTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return class$java$lang$Number == null ? (class$java$lang$Number = AggAnalysisTableModel.class$("java.lang.Number")) : class$java$lang$Number;
    }

    public Object getModelValueAt(int n, int n2) {
        if (n2 == 0) {
            if (n == this.getRowCount() - 1) {
                return this.lex.getText("summary");
            }
            if (this.dateSymbols == null) {
                this.dateSymbols = new DateFormatSymbols();
            }
            return this.lex.getText(this.dateSymbols.getMonths()[n]);
        }
        double d = 0.0;
        if (n != this.getRowCount() - 1) {
            if (this.months != null) {
                switch (n2) {
                    case 1: {
                        d = this.months[n].consumption;
                        break;
                    }
                    case 2: {
                        d = this.months[n].peakDemand;
                        break;
                    }
                    case 3: {
                        d = this.months[n].minDemand;
                        break;
                    }
                    case 4: {
                        d = this.months[n].loadFactor;
                        break;
                    }
                    default: {
                        d = 0.0;
                        break;
                    }
                }
            }
        } else {
            switch (n2) {
                case 1: {
                    d = this.total;
                    break;
                }
                case 2: {
                    d = this.peak;
                    break;
                }
                case 3: {
                    d = this.min;
                    break;
                }
                case 4: {
                    d = this.loadFactor;
                    break;
                }
                default: {
                    d = 0.0;
                }
            }
        }
        return new Double(d);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

