/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.partitioning;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.ui.dbconfig.EasList;
import com.tridium.eas.ui.partitioning.EasPartitionClient;
import com.tridium.eas.ui.partitioning.PartitionConfigPanel;
import com.tridium.eas.ui.partitioning.PartitioningListCellRenderer;
import com.tridium.eas.ui.widgets.SortedListModel;
import com.tridium.eas.ui.widgets.UserObjectComparator;
import java.awt.Dimension;
import javax.swing.ListModel;

public class UserList
extends EasList {
    private String[] users;
    private EasSession session = null;

    public UserList(PartitionConfigPanel partitionConfigPanel) {
        this.setModel(new SortedListModel(new UserObjectComparator()));
        this.setCellRenderer(new PartitioningListCellRenderer(partitionConfigPanel));
    }

    public void init(EasSession easSession) {
        this.session = easSession;
    }

    public EasSession getSession() {
        return this.session;
    }

    public void refreshData(boolean bl) {
        if (!bl) {
            this.refreshData(this.users);
            return;
        }
        SortedListModel sortedListModel = (SortedListModel)this.getModel();
        sortedListModel.removeAllElements();
        try {
            this.users = EasPartitionClient.retrieveUserNames(this.getSession());
            if (this.users != null) {
                for (int i = 0; i < this.users.length; ++i) {
                    sortedListModel.addElement(this.users[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refreshData(String[] stringArray) {
        this.users = stringArray;
        SortedListModel sortedListModel = (SortedListModel)this.getModel();
        sortedListModel.removeAllElements();
        try {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    sortedListModel.addElement(stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getSelectedUser() {
        return (String)this.getSelectedValue();
    }

    public String[] getSelectedUsers() {
        Object[] objectArray = this.getSelectedValues();
        String[] stringArray = null;
        if (objectArray != null) {
            int n = objectArray.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)objectArray[i];
            }
        }
        return stringArray;
    }

    public void setSelected(int n, boolean bl) {
        if (bl) {
            this.addSelectionInterval(n, n);
        } else {
            this.removeSelectionInterval(n, n);
        }
    }

    public void setSelectedValues(Object[] objectArray) {
        this.clearSelection();
        ListModel listModel = this.getModel();
        int n = listModel.getSize();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                for (int j = 0; j < n; ++j) {
                    Object e = listModel.getElementAt(j);
                    if (!object.equals(e)) continue;
                    this.setSelected(j, true);
                }
            }
        }
    }

    public void selectAll() {
        this.setSelectedValues(this.users);
    }

    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = super.getPreferredSize();
        int n2 = 175;
        if (dimension.width > n2) {
            n2 = dimension.width;
        }
        if (dimension.height > (n = 550)) {
            n = dimension.height;
        }
        return new Dimension(n2, n);
    }
}

