/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.partitioning;

import com.tridium.eas.api.EasPartition;
import com.tridium.eas.api.EasProtected;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.ui.RateList;
import com.tridium.eas.cost.ui.RateListParentPanel;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasEditorListener;
import com.tridium.eas.ui.dbconfig.GroupTree;
import com.tridium.eas.ui.partitioning.EasPartitionClient;
import com.tridium.eas.ui.partitioning.NewPartitionDialog;
import com.tridium.eas.ui.partitioning.PartitionList;
import com.tridium.eas.ui.partitioning.UserList;
import com.tridium.eas.ui.partitioning.WrapperCheckListCellRenderer;
import com.tridium.eas.ui.partitioning.WrapperTreeCellRenderer;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.ListPopupHandler;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.Hashtable;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class PartitionConfigPanel
extends JPanel
implements ResourceManager,
ListSelectionListener,
TreeSelectionListener,
ActionListener,
RateListParentPanel,
TreeModelListener {
    private UserList users = null;
    private RateList rates = null;
    private PartitionList partitions = null;
    private GroupTree sites = null;
    private JCheckBox applySubSitesCheckBox = null;
    private GroupTree groups = null;
    private JCheckBox applySubGroupsCheckBox = null;
    private PartitionPopup partitionPopup = null;
    private EasComboBox objectChoiceComboBox;
    private CardLayout objectsLayout;
    private JPanel objectsPanel;
    private JButton refreshButton;
    private JButton newButton;
    private JButton deleteButton;
    private JPanel mainSplit;
    private JToolBar toolbar = null;
    private EasApplication easApplication;
    private boolean lastChange = true;
    private boolean loadingList = false;
    private JButton selectAllPartitionsButton;
    private JButton deselectAllPartitionsButton;
    private JButton selectAllObjectsButton;
    private JButton deselectAllObjectsButton;
    private JButton applyButton;
    private JButton discardChangesButton;
    private JButton directionButton;
    boolean objectsForPartitionDirection = true;
    private Hashtable[] partitionToObjectsCache = new Hashtable[4];
    private Hashtable[] objectToPartitionsCache = new Hashtable[4];
    static /* synthetic */ Class class$com$tridium$eas$api$Site;
    static /* synthetic */ Class class$com$tridium$eas$api$Meter;
    static /* synthetic */ Class class$com$tridium$eas$api$DataPoint;
    static /* synthetic */ Class class$com$tridium$eas$api$StaticGroup;

    public PartitionConfigPanel(EasApplication easApplication) {
        this.easApplication = easApplication;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getApplicationContent(), "Center");
    }

    public Image loadImage(String string) {
        return this.easApplication.loadImage(string);
    }

    public Image getIconImage(int n) {
        return this.easApplication.getIconImage(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initApplication(boolean bl) {
        if (bl) {
            this.loadingList = true;
            try {
                this.partitions.init(this.easApplication.getSession());
                this.partitions.refreshData(true);
                this.partitions.setEnabled(true);
                this.users.init(this.easApplication.getSession());
                this.users.refreshData(true);
                this.users.setEnabled(true);
                this.rates.init(this.easApplication.getSession());
                this.rates.refreshData(true);
                this.rates.setEnabled(true);
                Lexicon lexicon = BEasApplet.lex;
                this.sites.init(this.easApplication.getSession());
                this.sites.setModel(new FilterTreeModel(new FilterRootNode((Filter)new AllSitesFilter(this.easApplication.getSession(), lexicon), new Class[]{class$com$tridium$eas$api$Site == null ? (class$com$tridium$eas$api$Site = PartitionConfigPanel.class$("com.tridium.eas.api.Site")) : class$com$tridium$eas$api$Site, class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = PartitionConfigPanel.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter, class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = PartitionConfigPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint})));
                this.sites.getModel().addTreeModelListener(this);
                this.groups.init(this.easApplication.getSession());
                this.groups.setModel(new FilterTreeModel(new FilterRootNode((Filter)new StaticGroupFilter(this.easApplication.getSession(), lexicon), new Class[]{class$com$tridium$eas$api$StaticGroup == null ? (class$com$tridium$eas$api$StaticGroup = PartitionConfigPanel.class$("com.tridium.eas.api.StaticGroup")) : class$com$tridium$eas$api$StaticGroup})));
            }
            finally {
                this.loadingList = false;
            }
        }
    }

    public JToolBar getToolBar() {
        return this.getApplicationToolBar(new int[]{17, 29, 16});
    }

    private JToolBar getApplicationToolBar(int[] nArray) {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        Lexicon lexicon = BEasApplet.lex;
        block5: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 29: {
                    this.newButton = new EasButton((ResourceManager)this, new int[]{41, 29}, lexicon.getText("newPartition"));
                    this.newButton.addActionListener(this);
                    this.toolbar.add(this.newButton);
                    continue block5;
                }
                case 17: {
                    this.refreshButton = new EasButton((ResourceManager)this, 17, lexicon.getText("refresh"));
                    this.refreshButton.addActionListener(this);
                    this.toolbar.add(this.refreshButton);
                    this.toolbar.addSeparator();
                    continue block5;
                }
                case 16: {
                    this.deleteButton = new EasButton((ResourceManager)this, 16, lexicon.getText("deletePartition"));
                    this.deleteButton.addActionListener(this);
                    this.toolbar.add(this.deleteButton);
                }
            }
        }
        return this.toolbar;
    }

    private JComponent getApplicationContent() {
        this.easApplication.queueIconImage("/com/tridium/eas/ui/images/partition.png", 41);
        this.easApplication.queueIconImage("/com/tridium/eas/ui/images/user.png", 42);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/rate.png", 306);
        if (this.mainSplit == null) {
            Lexicon lexicon = BEasApplet.lex;
            this.mainSplit = new JPanel(new BorderLayout(), false);
            this.add((Component)this.mainSplit, "Center");
            JPanel jPanel = new JPanel(new BorderLayout(), false);
            JPanel jPanel2 = new JPanel(new BorderLayout(), false);
            jPanel2.setBorder(BorderFactory.createTitledBorder(lexicon.getText("availablePartitions")));
            jPanel2.add((Component)this.buildAvailablePartitionsContents(lexicon), "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout(1), false);
            this.selectAllPartitionsButton = new JButton(lexicon.getText("selectAll"));
            this.selectAllPartitionsButton.setEnabled(false);
            this.selectAllPartitionsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PartitionConfigPanel.this.selectAllPartitions();
                }
            });
            jPanel3.add(this.selectAllPartitionsButton);
            this.deselectAllPartitionsButton = new JButton(lexicon.getText("deselectAll"));
            this.deselectAllPartitionsButton.setEnabled(false);
            this.deselectAllPartitionsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PartitionConfigPanel.this.deselectAllPartitions();
                }
            });
            jPanel3.add(this.deselectAllPartitionsButton);
            jPanel2.add((Component)jPanel3, "South");
            jPanel.add((Component)jPanel2, "West");
            JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            jPanel4.add((Component)this.buildPartitionAssignmentEditorContent(lexicon), gridBagConstraints);
            jPanel.add((Component)jPanel4, "Center");
            JPanel jPanel5 = new JPanel(new BorderLayout(), false);
            jPanel5.setBorder(BorderFactory.createTitledBorder(lexicon.getText("objectsAvailableToPartition")));
            jPanel5.add((Component)this.buildAvailableObjectsContents(lexicon), "Center");
            JPanel jPanel6 = new JPanel(new FlowLayout(1), false);
            this.selectAllObjectsButton = new JButton(lexicon.getText("selectAll"));
            this.selectAllObjectsButton.setEnabled(false);
            this.selectAllObjectsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PartitionConfigPanel.this.selectAllObjects();
                }
            });
            jPanel6.add(this.selectAllObjectsButton);
            this.deselectAllObjectsButton = new JButton(lexicon.getText("deselectAll"));
            this.deselectAllObjectsButton.setEnabled(false);
            this.deselectAllObjectsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PartitionConfigPanel.this.deselectAllObjects();
                }
            });
            jPanel6.add(this.deselectAllObjectsButton);
            jPanel5.add((Component)jPanel6, "South");
            jPanel.add((Component)jPanel5, "East");
            this.mainSplit.add((Component)jPanel, "Center");
            JPanel jPanel7 = new JPanel(new FlowLayout(1), false);
            this.applyButton = new JButton(lexicon.getText("applyChanges"));
            this.applyButton.setEnabled(false);
            this.applyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (PartitionConfigPanel.this.applyChanges()) {
                        PartitionConfigPanel.this.setPartitionSelectionEnabled(true);
                    }
                }
            });
            jPanel7.add(this.applyButton);
            this.discardChangesButton = new JButton(lexicon.getText("discardChanges"));
            this.discardChangesButton.setEnabled(false);
            this.discardChangesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PartitionConfigPanel.this.discardChanges();
                    PartitionConfigPanel.this.setPartitionSelectionEnabled(true);
                }
            });
            jPanel7.add(this.discardChangesButton);
            this.mainSplit.add((Component)jPanel7, "South");
        }
        return this.mainSplit;
    }

    private JComponent buildAvailableObjectsContents(Lexicon lexicon) {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.objectChoiceComboBox = new EasComboBox(new String[]{lexicon.getText("users"), lexicon.getText("rates"), lexicon.getText("sites"), lexicon.getText("groups")});
        this.objectChoiceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PartitionConfigPanel.this.objectsLayout.show(PartitionConfigPanel.this.objectsPanel, Integer.toString(PartitionConfigPanel.this.objectChoiceComboBox.getSelectedIndex()));
                if (PartitionConfigPanel.this.objectsForPartitionDirection) {
                    PartitionConfigPanel.this.loadObjectsForPartition();
                } else {
                    PartitionConfigPanel.this.loadPartitionsForObject();
                }
            }
        });
        jPanel.add((Component)this.objectChoiceComboBox.getPanel(), "North");
        this.objectsLayout = new CardLayout();
        this.objectsPanel = new JPanel(this.objectsLayout, false);
        this.users = new UserList(this);
        this.users.addListSelectionListener(this);
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel();
        this.users.addMouseListener(objectListSelectionModel);
        this.users.setSelectionModel(objectListSelectionModel);
        this.users.getSelectionModel().setSelectionMode(2);
        this.objectsPanel.add((Component)new JScrollPane(this.users), Integer.toString(0));
        this.rates = new RateList(this);
        this.rates.setCellRenderer(new WrapperCheckListCellRenderer(this.rates.getCellRenderer(), this));
        this.rates.setRateEditor(this);
        objectListSelectionModel = new ObjectListSelectionModel();
        this.rates.addMouseListener(objectListSelectionModel);
        this.rates.setSelectionModel(objectListSelectionModel);
        this.rates.getSelectionModel().setSelectionMode(2);
        this.objectsPanel.add((Component)new JScrollPane(this.rates), Integer.toString(1));
        this.sites = new GroupTree(this){

            public void mousePressed(MouseEvent mouseEvent) {
                boolean bl = (mouseEvent.getModifiers() & 4) != 0;
                boolean bl2 = mouseEvent.isControlDown();
                TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                if (bl) {
                    if (bl2) {
                        this.addSelectionPath(treePath);
                    } else {
                        this.setSelectionPath(treePath);
                    }
                }
            }
        };
        this.sites.addTreeSelectionListener(this);
        this.sites.setCellRenderer(new WrapperTreeCellRenderer(this.sites.getCellRenderer(), this));
        ObjectTreeSelectionModel objectTreeSelectionModel = new ObjectTreeSelectionModel(this.sites.getSelectionModel());
        this.sites.addMouseListener(objectTreeSelectionModel);
        this.sites.setSelectionModel(objectTreeSelectionModel);
        this.sites.getSelectionModel().setSelectionMode(4);
        this.applySubSitesCheckBox = new JCheckBox(lexicon.getText("applyToSubObjects"));
        this.applySubSitesCheckBox.setSelected(true);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        jPanel2.add((Component)new JScrollPane(this.sites), "Center");
        jPanel2.add((Component)this.applySubSitesCheckBox, "South");
        this.objectsPanel.add((Component)jPanel2, Integer.toString(2));
        this.groups = new GroupTree(this){

            public void mousePressed(MouseEvent mouseEvent) {
                boolean bl = (mouseEvent.getModifiers() & 4) != 0;
                boolean bl2 = mouseEvent.isControlDown();
                TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                if (bl) {
                    if (bl2) {
                        this.addSelectionPath(treePath);
                    } else {
                        this.setSelectionPath(treePath);
                    }
                }
            }
        };
        this.groups.addTreeSelectionListener(this);
        this.groups.setCellRenderer(new WrapperTreeCellRenderer(this.groups.getCellRenderer(), this));
        objectTreeSelectionModel = new ObjectTreeSelectionModel(this.groups.getSelectionModel());
        this.groups.addMouseListener(objectTreeSelectionModel);
        this.groups.setSelectionModel(objectTreeSelectionModel);
        this.groups.getSelectionModel().setSelectionMode(4);
        this.applySubGroupsCheckBox = new JCheckBox(lexicon.getText("applyToSubObjects"));
        this.applySubGroupsCheckBox.setSelected(true);
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        jPanel3.add((Component)new JScrollPane(this.groups), "Center");
        jPanel3.add((Component)this.applySubGroupsCheckBox, "South");
        this.objectsPanel.add((Component)jPanel3, Integer.toString(3));
        this.objectsLayout.show(this.objectsPanel, Integer.toString(0));
        jPanel.add((Component)this.objectsPanel, "Center");
        return jPanel;
    }

    private JComponent buildAvailablePartitionsContents(Lexicon lexicon) {
        this.partitions = new PartitionList(this);
        this.partitions.addListSelectionListener(this);
        PartitionListSelectionModel partitionListSelectionModel = new PartitionListSelectionModel();
        this.partitions.addMouseListener(partitionListSelectionModel);
        this.partitions.setSelectionModel(partitionListSelectionModel);
        this.partitions.getSelectionModel().setSelectionMode(0);
        this.partitions.setPopupHandler(new ListPopupHandler(){

            public void openPopup(Object object, int n, int n2, int n3) {
                if (PartitionConfigPanel.this.partitions.isEnabled()) {
                    if (PartitionConfigPanel.this.partitionPopup == null) {
                        Lexicon lexicon = BEasApplet.lex;
                        PartitionConfigPanel.this.partitionPopup = new PartitionPopup(lexicon);
                    }
                    boolean bl = false;
                    int[] nArray = PartitionConfigPanel.this.partitions.getSelectedIndices();
                    if (nArray != null && nArray.length == 1 && nArray[0] == n) {
                        bl = true;
                    }
                    PartitionConfigPanel.this.partitionPopup.show(PartitionConfigPanel.this.partitions, bl, n2, n3);
                }
            }
        });
        this.partitions.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int[] nArray;
                if (keyEvent.getKeyCode() == 155) {
                    PartitionConfigPanel.this.createPartition();
                } else if ((keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) && (nArray = PartitionConfigPanel.this.partitions.getSelectedIndices()) != null && nArray.length == 1) {
                    PartitionConfigPanel.this.deletePartition();
                }
            }
        });
        return new JScrollPane(this.partitions);
    }

    private JComponent buildPartitionAssignmentEditorContent(Lexicon lexicon) {
        this.directionButton = new JButton(lexicon.getText("objectsForPartition") + " -->");
        this.directionButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionConfigPanel.this.loadingList = true;
                try {
                    Lexicon lexicon = BEasApplet.lex;
                    boolean bl = PartitionConfigPanel.this.objectsForPartitionDirection = !PartitionConfigPanel.this.objectsForPartitionDirection;
                    if (PartitionConfigPanel.this.objectsForPartitionDirection) {
                        PartitionConfigPanel.this.directionButton.setText(lexicon.getText("objectsForPartition") + " -->");
                        PartitionConfigPanel.this.users.getSelectionModel().setSelectionMode(2);
                        PartitionConfigPanel.this.rates.getSelectionModel().setSelectionMode(2);
                        PartitionConfigPanel.this.sites.getSelectionModel().setSelectionMode(4);
                        PartitionConfigPanel.this.groups.getSelectionModel().setSelectionMode(4);
                        PartitionConfigPanel.this.partitions.getSelectionModel().setSelectionMode(0);
                    } else {
                        PartitionConfigPanel.this.directionButton.setText("<-- " + lexicon.getText("partitionsForObject"));
                        PartitionConfigPanel.this.users.getSelectionModel().setSelectionMode(0);
                        PartitionConfigPanel.this.rates.getSelectionModel().setSelectionMode(0);
                        PartitionConfigPanel.this.sites.getSelectionModel().setSelectionMode(1);
                        PartitionConfigPanel.this.groups.getSelectionModel().setSelectionMode(1);
                        PartitionConfigPanel.this.partitions.getSelectionModel().setSelectionMode(2);
                    }
                    PartitionConfigPanel.this.partitions.clearSelection();
                    PartitionConfigPanel.this.users.clearSelection();
                    PartitionConfigPanel.this.rates.clearSelection();
                    PartitionConfigPanel.this.sites.clearSelection();
                    PartitionConfigPanel.this.groups.clearSelection();
                    PartitionConfigPanel.this.partitions.repaint();
                    PartitionConfigPanel.this.users.repaint();
                    PartitionConfigPanel.this.rates.repaint();
                    PartitionConfigPanel.this.sites.repaint();
                    PartitionConfigPanel.this.groups.repaint();
                    PartitionConfigPanel.this.selectAllPartitionsButton.setEnabled(false);
                    PartitionConfigPanel.this.deselectAllPartitionsButton.setEnabled(false);
                    PartitionConfigPanel.this.selectAllObjectsButton.setEnabled(false);
                    PartitionConfigPanel.this.deselectAllObjectsButton.setEnabled(false);
                    PartitionConfigPanel.this.revalidate();
                }
                finally {
                    PartitionConfigPanel.this.loadingList = false;
                }
            }
        });
        return this.directionButton;
    }

    public void setPartitionSelectionEnabled(boolean bl) {
        if (bl != this.lastChange) {
            EventObject eventObject = new EventObject(this);
            if (bl) {
                ((EasEditorListener)((Object)this.easApplication)).editingStopped(eventObject);
            } else {
                ((EasEditorListener)((Object)this.easApplication)).editingStarted(eventObject);
            }
        }
        this.lastChange = bl;
        if (this.objectsForPartitionDirection) {
            this.partitions.setEnabled(bl);
        } else {
            this.users.setEnabled(bl);
            this.rates.setEnabled(bl);
            this.sites.setEnabled(bl);
            this.groups.setEnabled(bl);
            this.objectChoiceComboBox.setEnabled(bl);
        }
        this.directionButton.setEnabled(bl);
        this.applyButton.setEnabled(!bl);
        this.discardChangesButton.setEnabled(!bl);
    }

    private boolean unsavedChangesExist() {
        if (this.applyButton != null) {
            return this.applyButton.isEnabled();
        }
        return false;
    }

    private boolean applyChanges() {
        if (this.objectsForPartitionDirection) {
            return this.saveObjectsForPartition();
        }
        return this.savePartitionsForObject();
    }

    private void discardChanges() {
        if (this.objectsForPartitionDirection) {
            this.loadObjectsForPartition();
        } else {
            this.loadPartitionsForObject();
        }
    }

    private boolean saveObjectsForPartition() {
        EasPartition easPartition = this.partitions.getSelectedPartition();
        if (easPartition == null) {
            return false;
        }
        Object[] objectArray = null;
        int n = this.objectChoiceComboBox.getSelectedIndex();
        try {
            boolean bl = false;
            switch (n) {
                case 0: {
                    String[] stringArray = this.users.getSelectedUsers();
                    bl = EasPartitionClient.storeUsersForPartition(this.easApplication.getSession(), easPartition, stringArray);
                    objectArray = stringArray;
                    break;
                }
                case 1: {
                    EasProtected[] easProtectedArray = PartitionConfigPanel.convertToEasProtectedArray(this.rates.getSelectedValues());
                    bl = EasPartitionClient.storeObjectsForPartition(this.easApplication.getSession(), easPartition, easProtectedArray, 4);
                    objectArray = easProtectedArray;
                    break;
                }
                case 2: {
                    EasProtected[] easProtectedArray = PartitionConfigPanel.convertToEasProtectedArray(this.sites.getSelectedUserObjects());
                    bl = EasPartitionClient.storeObjectsForPartition(this.easApplication.getSession(), easPartition, easProtectedArray, 0);
                    objectArray = easProtectedArray;
                    break;
                }
                case 3: {
                    EasProtected[] easProtectedArray = PartitionConfigPanel.convertToEasProtectedArray(this.groups.getSelectedUserObjects());
                    bl = EasPartitionClient.storeObjectsForPartition(this.easApplication.getSession(), easPartition, easProtectedArray, 3);
                    objectArray = easProtectedArray;
                }
            }
            if (bl) {
                if (this.partitionToObjectsCache[n] == null) {
                    this.partitionToObjectsCache[n] = new Hashtable();
                }
                this.partitionToObjectsCache[n].put(easPartition, objectArray);
                this.objectToPartitionsCache[n] = null;
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean savePartitionsForObject() {
        int n = this.objectChoiceComboBox.getSelectedIndex();
        Object object = null;
        switch (n) {
            case 0: {
                object = this.users.getSelectedValue();
                break;
            }
            case 1: {
                object = this.rates.getSelectedValue();
                break;
            }
            case 2: {
                object = this.sites.getSelectedUserObject();
                break;
            }
            case 3: {
                object = this.groups.getSelectedUserObject();
            }
        }
        if (object == null) {
            return false;
        }
        EasPartition[] easPartitionArray = this.partitions.getSelectedPartitions();
        try {
            boolean bl = false;
            if (object instanceof String) {
                bl = EasPartitionClient.storePartitions(this.easApplication.getSession(), (String)object, easPartitionArray);
            } else if (object instanceof EasProtected) {
                bl = EasPartitionClient.storePartitions(this.easApplication.getSession(), (EasProtected)object, easPartitionArray);
            }
            if (bl) {
                if (this.objectToPartitionsCache[n] == null) {
                    this.objectToPartitionsCache[n] = new Hashtable();
                }
                this.objectToPartitionsCache[n].put(object, easPartitionArray);
                this.partitionToObjectsCache[n] = null;
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadObjectsForPartition() {
        this.loadingList = true;
        try {
            int n;
            Object[] objectArray;
            block29: {
                this.setCursor(Cursor.getPredefinedCursor(3));
                EasPartition easPartition = this.partitions.getSelectedPartition();
                objectArray = null;
                n = this.objectChoiceComboBox.getSelectedIndex();
                if (easPartition != null) {
                    try {
                        if (this.partitionToObjectsCache[n] != null) {
                            objectArray = (Object[])this.partitionToObjectsCache[n].get(easPartition);
                        } else {
                            this.partitionToObjectsCache[n] = new Hashtable();
                        }
                        if (objectArray != null) break block29;
                        switch (n) {
                            case 0: {
                                objectArray = EasPartitionClient.retrieveUsersForPartition(this.easApplication.getSession(), easPartition);
                                if (objectArray != null) break;
                                objectArray = new String[]{};
                                break;
                            }
                            case 1: {
                                objectArray = EasPartitionClient.retrieveObjectsForPartition(this.easApplication.getSession(), easPartition, 4);
                                if (objectArray != null) break;
                                objectArray = new EasProtected[]{};
                                break;
                            }
                            case 2: {
                                int n2;
                                EasProtected[] easProtectedArray = EasPartitionClient.retrieveObjectsForPartition(this.easApplication.getSession(), easPartition, 0);
                                EasProtected[] easProtectedArray2 = EasPartitionClient.retrieveObjectsForPartition(this.easApplication.getSession(), easPartition, 1);
                                EasProtected[] easProtectedArray3 = EasPartitionClient.retrieveObjectsForPartition(this.easApplication.getSession(), easPartition, 2);
                                int n3 = 0;
                                if (easProtectedArray != null) {
                                    n3 += easProtectedArray.length;
                                }
                                if (easProtectedArray2 != null) {
                                    n3 += easProtectedArray2.length;
                                }
                                if (easProtectedArray3 != null) {
                                    n3 += easProtectedArray3.length;
                                }
                                objectArray = new EasProtected[n3];
                                int n4 = 0;
                                if (easProtectedArray != null) {
                                    for (n2 = 0; n2 < easProtectedArray.length; ++n4, ++n2) {
                                        objectArray[n4] = easProtectedArray[n2];
                                    }
                                }
                                if (easProtectedArray2 != null) {
                                    for (n2 = 0; n2 < easProtectedArray2.length; ++n4, ++n2) {
                                        objectArray[n4] = easProtectedArray2[n2];
                                    }
                                }
                                if (easProtectedArray3 == null) break;
                                for (n2 = 0; n2 < easProtectedArray3.length; ++n4, ++n2) {
                                    objectArray[n4] = easProtectedArray3[n2];
                                }
                                break;
                            }
                            case 3: {
                                objectArray = EasPartitionClient.retrieveObjectsForPartition(this.easApplication.getSession(), easPartition, 3);
                                if (objectArray != null) break;
                                objectArray = new EasProtected[]{};
                                break;
                            }
                        }
                        if (objectArray != null) {
                            this.partitionToObjectsCache[n].put(easPartition, objectArray);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            switch (n) {
                case 0: {
                    this.users.setSelectedValues(objectArray);
                    this.users.revalidate();
                    return;
                }
                case 1: {
                    this.rates.setSelectedValues(objectArray);
                    this.rates.revalidate();
                    return;
                }
                case 2: {
                    this.sites.setSelectedUserObjects(objectArray);
                    this.sites.revalidate();
                    return;
                }
                case 3: {
                    this.groups.setSelectedUserObjects(objectArray);
                    this.groups.revalidate();
                    return;
                }
            }
            return;
        }
        finally {
            this.loadingList = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPartitionsForObject() {
        this.loadingList = true;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int n = this.objectChoiceComboBox.getSelectedIndex();
            Object object = null;
            switch (n) {
                case 0: {
                    object = this.users.getSelectedValue();
                    break;
                }
                case 1: {
                    object = this.rates.getSelectedValue();
                    break;
                }
                case 2: {
                    object = this.sites.getSelectedUserObject();
                    break;
                }
                case 3: {
                    object = this.groups.getSelectedUserObject();
                }
            }
            EasPartition[] easPartitionArray = null;
            if (object != null) {
                try {
                    if (this.objectToPartitionsCache[n] != null) {
                        easPartitionArray = (EasPartition[])this.objectToPartitionsCache[n].get(object);
                    } else {
                        this.objectToPartitionsCache[n] = new Hashtable();
                    }
                    if (easPartitionArray == null) {
                        if (object instanceof String) {
                            easPartitionArray = EasPartitionClient.retrievePartitions(this.easApplication.getSession(), (String)object);
                        } else if (object instanceof EasProtected) {
                            easPartitionArray = EasPartitionClient.retrievePartitions(this.easApplication.getSession(), (EasProtected)object);
                        }
                        if (easPartitionArray == null) {
                            easPartitionArray = new EasPartition[]{};
                        }
                        this.objectToPartitionsCache[n].put(object, easPartitionArray);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.partitions.setSelectedValues(easPartitionArray);
            this.partitions.revalidate();
        }
        finally {
            this.loadingList = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static EasProtected[] convertToEasProtectedArray(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        EasProtected[] easProtectedArray = new EasProtected[n];
        for (int i = 0; i < n; ++i) {
            easProtectedArray[i] = (EasProtected)objectArray[i];
        }
        return easProtectedArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            this.buttonPressed((JButton)object);
        }
    }

    private void buttonPressed(JButton jButton) {
        int[] nArray;
        if (jButton == this.refreshButton) {
            this.setPartitionSelectionEnabled(true);
            this.initApplication(true);
        } else if (jButton == this.newButton) {
            this.createPartition();
        } else if (jButton == this.deleteButton && (nArray = this.partitions.getSelectedIndices()) != null && nArray.length == 1) {
            this.deletePartition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object == this.users && !this.objectsForPartitionDirection) {
            if (this.users == null) {
                return;
            }
            try {
                this.loadPartitionsForObject();
            }
            finally {
                this.selectAllPartitionsButton.setEnabled(true);
                this.deselectAllPartitionsButton.setEnabled(true);
            }
        } else if (object == this.partitions && this.objectsForPartitionDirection) {
            if (this.partitions == null) {
                return;
            }
            try {
                this.loadObjectsForPartition();
            }
            finally {
                this.selectAllObjectsButton.setEnabled(true);
                this.deselectAllObjectsButton.setEnabled(true);
            }
        } else if (!(this.loadingList || object != this.users && object != this.partitions)) {
            this.setPartitionSelectionEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRateEditorValue(Rate rate) {
        if (!this.objectsForPartitionDirection) {
            if (this.rates == null) {
                return;
            }
            try {
                this.loadPartitionsForObject();
            }
            finally {
                this.selectAllPartitionsButton.setEnabled(true);
                this.deselectAllPartitionsButton.setEnabled(true);
            }
        } else if (!this.loadingList) {
            this.setPartitionSelectionEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getSource();
        if (!(object != this.sites && object != this.groups || this.objectsForPartitionDirection)) {
            try {
                this.loadPartitionsForObject();
            }
            finally {
                this.selectAllPartitionsButton.setEnabled(true);
                this.deselectAllPartitionsButton.setEnabled(true);
            }
        } else if (!(this.loadingList || object != this.sites && object != this.groups)) {
            this.setPartitionSelectionEnabled(false);
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        System.out.println("Got to treeNodesChanged: " + treeModelEvent);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        System.out.println("Got to treeNodesInserted: " + treeModelEvent);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        System.out.println("Got to treeNodesRemoved: " + treeModelEvent);
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        System.out.println("Got to treeStructureChanged: " + treeModelEvent);
    }

    public EasSession getSession() {
        return this.easApplication.getSession();
    }

    public EasApplication getEasApplication() {
        return this.easApplication;
    }

    public void stopApplication() {
        Lexicon lexicon;
        int n;
        if (this.unsavedChangesExist() && (n = JOptionPane.showConfirmDialog(null, (lexicon = BEasApplet.lex).getText("saveChangesTo") + " " + lexicon.getText("partitioning") + "?", lexicon.getText("saveChanges") + "?", 1)) == 0) {
            this.applyChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPartition() {
        this.loadingList = true;
        try {
            Lexicon lexicon = BEasApplet.lex;
            String string = NewPartitionDialog.getNewPartition(this.easApplication.getSession(), this, lexicon);
            if (string != null) {
                this.partitions.savePartition(string);
            }
        }
        finally {
            this.loadingList = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePartition() {
        this.loadingList = true;
        try {
            EasPartition easPartition = this.partitions.getSelectedPartition();
            if (easPartition != null) {
                Lexicon lexicon = BEasApplet.lex;
                String string = lexicon.getText("deleteWarning") + "\n\"" + easPartition.getName() + "\"?";
                int n = JOptionPane.showConfirmDialog(this, string, lexicon.getText("confirmDelete"), 0);
                if (n != 0) {
                    return;
                }
                this.partitions.deletePartition(easPartition);
            }
        }
        finally {
            this.loadingList = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renamePartition() {
        this.loadingList = true;
        try {
            EasPartition easPartition = this.partitions.getSelectedPartition();
            if (easPartition != null) {
                Lexicon lexicon = BEasApplet.lex;
                String string = NewPartitionDialog.getNewPartition(this.easApplication.getSession(), this, lexicon, lexicon.getText("renamePartition"), easPartition.getName());
                if (string != null) {
                    this.partitions.renamePartition(easPartition, string);
                }
            }
        }
        finally {
            this.loadingList = false;
        }
    }

    private void selectAllPartitions() {
        this.partitions.selectAll();
    }

    private void deselectAllPartitions() {
        this.partitions.clearSelection();
    }

    private void selectAllObjects() {
        switch (this.objectChoiceComboBox.getSelectedIndex()) {
            case 0: {
                this.users.selectAll();
                break;
            }
            case 1: {
                this.rates.selectAll();
                break;
            }
            case 2: {
                this.sites.addSelectionInterval(0, this.sites.getRowCount());
                break;
            }
            case 3: {
                this.groups.addSelectionInterval(0, this.groups.getRowCount());
            }
        }
    }

    private void deselectAllObjects() {
        switch (this.objectChoiceComboBox.getSelectedIndex()) {
            case 0: {
                this.users.clearSelection();
                break;
            }
            case 1: {
                this.rates.clearSelection();
                break;
            }
            case 2: {
                this.sites.clearSelection();
                break;
            }
            case 3: {
                this.groups.clearSelection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRates() {
        this.loadingList = true;
        try {
            if (this.rates != null) {
                this.rates.refreshData(true);
            }
            System.out.println("FIXX - Need to refresh sites/groups also!");
        }
        finally {
            this.loadingList = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ObjectTreeSelectionModel
    implements MouseListener,
    TreeSelectionModel {
        private boolean mouseDown = false;
        private TreeSelectionModel defaultModel;

        public ObjectTreeSelectionModel(TreeSelectionModel treeSelectionModel) {
            this.defaultModel = treeSelectionModel;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.defaultModel.addPropertyChangeListener(propertyChangeListener);
        }

        public void addSelectionPath(TreePath treePath) {
            if (!PartitionConfigPanel.this.objectsForPartitionDirection) {
                this.defaultModel.addSelectionPath(treePath);
                return;
            }
            int[] nArray = PartitionConfigPanel.this.partitions.getSelectedIndices();
            if (nArray != null && nArray.length > 0) {
                this.defaultModel.addSelectionPath(treePath);
            }
        }

        public void addSelectionPaths(TreePath[] treePathArray) {
            if (!PartitionConfigPanel.this.objectsForPartitionDirection) {
                this.defaultModel.addSelectionPaths(treePathArray);
                return;
            }
            int[] nArray = PartitionConfigPanel.this.partitions.getSelectedIndices();
            if (nArray != null && nArray.length > 0) {
                this.defaultModel.addSelectionPaths(treePathArray);
            }
        }

        public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
            this.defaultModel.addTreeSelectionListener(treeSelectionListener);
        }

        public void clearSelection() {
            this.defaultModel.clearSelection();
        }

        public TreePath getLeadSelectionPath() {
            return this.defaultModel.getLeadSelectionPath();
        }

        public int getLeadSelectionRow() {
            return this.defaultModel.getLeadSelectionRow();
        }

        public int getMaxSelectionRow() {
            return this.defaultModel.getMaxSelectionRow();
        }

        public int getMinSelectionRow() {
            return this.defaultModel.getMinSelectionRow();
        }

        public RowMapper getRowMapper() {
            return this.defaultModel.getRowMapper();
        }

        public int getSelectionCount() {
            return this.defaultModel.getSelectionCount();
        }

        public int getSelectionMode() {
            return this.defaultModel.getSelectionMode();
        }

        public TreePath getSelectionPath() {
            return this.defaultModel.getSelectionPath();
        }

        public TreePath[] getSelectionPaths() {
            return this.defaultModel.getSelectionPaths();
        }

        public int[] getSelectionRows() {
            return this.defaultModel.getSelectionRows();
        }

        public boolean isPathSelected(TreePath treePath) {
            return this.defaultModel.isPathSelected(treePath);
        }

        public boolean isRowSelected(int n) {
            return this.defaultModel.isRowSelected(n);
        }

        public boolean isSelectionEmpty() {
            return this.defaultModel.isSelectionEmpty();
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.defaultModel.removePropertyChangeListener(propertyChangeListener);
        }

        public void removeSelectionPath(TreePath treePath) {
            this.defaultModel.removeSelectionPath(treePath);
        }

        public void removeSelectionPaths(TreePath[] treePathArray) {
            this.defaultModel.removeSelectionPaths(treePathArray);
        }

        public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
            this.defaultModel.removeTreeSelectionListener(treeSelectionListener);
        }

        public void resetRowSelection() {
            this.defaultModel.resetRowSelection();
        }

        public void setRowMapper(RowMapper rowMapper) {
            this.defaultModel.setRowMapper(rowMapper);
        }

        public void setSelectionMode(int n) {
            this.defaultModel.setSelectionMode(n);
        }

        public void setSelectionPath(TreePath treePath) {
            if (!PartitionConfigPanel.this.objectsForPartitionDirection) {
                this.defaultModel.setSelectionPath(treePath);
                return;
            }
            if (this.mouseDown) {
                return;
            }
            if (this.isPathSelected(treePath)) {
                this.removeSelectionPath(treePath);
                return;
            }
            this.addSelectionPath(treePath);
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
            if (treePathArray != null && PartitionConfigPanel.this.objectsForPartitionDirection) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    this.setSelectionPath(treePathArray[i]);
                }
            } else {
                this.defaultModel.setSelectionPaths(treePathArray);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseDown = false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class PartitionListSelectionModel
    extends DefaultListSelectionModel
    implements MouseListener {
        private boolean mouseDown = false;

        public void addSelectionInterval(int n, int n2) {
            if (PartitionConfigPanel.this.objectsForPartitionDirection) {
                super.addSelectionInterval(n, n2);
                return;
            }
            int[] nArray = null;
            switch (PartitionConfigPanel.this.objectChoiceComboBox.getSelectedIndex()) {
                case 0: {
                    nArray = PartitionConfigPanel.this.users.getSelectedIndices();
                    break;
                }
                case 1: {
                    nArray = PartitionConfigPanel.this.rates.getSelectedIndices();
                    break;
                }
                case 2: {
                    nArray = PartitionConfigPanel.this.sites.getSelectionRows();
                    break;
                }
                case 3: {
                    nArray = PartitionConfigPanel.this.groups.getSelectionRows();
                }
            }
            if (nArray != null && nArray.length > 0) {
                super.addSelectionInterval(n, n2);
            }
        }

        public void setSelectionInterval(int n, int n2) {
            if (PartitionConfigPanel.this.objectsForPartitionDirection) {
                super.setSelectionInterval(n, n2);
                return;
            }
            if (this.mouseDown) {
                return;
            }
            if (n == n2 && this.isSelectedIndex(n)) {
                this.removeSelectionInterval(n, n);
                return;
            }
            this.addSelectionInterval(n, n2);
        }

        public void setAnchorSelectionIndex(int n) {
            if (PartitionConfigPanel.this.objectsForPartitionDirection) {
                super.setAnchorSelectionIndex(n);
            }
        }

        public void setLeadSelectionIndex(int n) {
            if (PartitionConfigPanel.this.objectsForPartitionDirection) {
                super.setLeadSelectionIndex(n);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseDown = false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class ObjectListSelectionModel
    extends DefaultListSelectionModel
    implements MouseListener {
        private boolean mouseDown = false;

        public void addSelectionInterval(int n, int n2) {
            if (!PartitionConfigPanel.this.objectsForPartitionDirection) {
                super.addSelectionInterval(n, n2);
                return;
            }
            int[] nArray = PartitionConfigPanel.this.partitions.getSelectedIndices();
            if (nArray != null && nArray.length > 0) {
                super.addSelectionInterval(n, n2);
            }
        }

        public void setSelectionInterval(int n, int n2) {
            if (!PartitionConfigPanel.this.objectsForPartitionDirection) {
                super.setSelectionInterval(n, n2);
                return;
            }
            if (this.mouseDown) {
                return;
            }
            if (n == n2 && this.isSelectedIndex(n)) {
                this.removeSelectionInterval(n, n);
                return;
            }
            this.addSelectionInterval(n, n2);
        }

        public void setAnchorSelectionIndex(int n) {
            if (!PartitionConfigPanel.this.objectsForPartitionDirection) {
                super.setAnchorSelectionIndex(n);
            }
        }

        public void setLeadSelectionIndex(int n) {
            if (!PartitionConfigPanel.this.objectsForPartitionDirection) {
                super.setLeadSelectionIndex(n);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseDown = false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class PartitionPopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem addItem = null;
        private boolean addItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem renameItem = null;
        private boolean renameItemShowing = false;
        private Lexicon lex;

        public PartitionPopup(Lexicon lexicon) {
            this.lex = lexicon;
            this.addItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("newPartition"), 0, null);
            this.renameItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("renamePartition"), 1, null);
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("deletePartition"), 2, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    PartitionConfigPanel.this.createPartition();
                    break;
                }
                case 1: {
                    PartitionConfigPanel.this.renamePartition();
                    break;
                }
                case 2: {
                    PartitionConfigPanel.this.deletePartition();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            boolean bl2;
            boolean bl3 = bl2 = bl;
            boolean bl4 = true;
            if (bl4 && !this.addItemShowing) {
                this.addItem.addActionListener(this);
                this.insert(this.addItem, 0);
                this.revalidate();
                this.addItemShowing = true;
            } else if (this.addItemShowing && !bl4) {
                this.remove(this.addItem);
                this.revalidate();
                this.addItemShowing = false;
            }
            if (bl3 && !this.renameItemShowing) {
                this.renameItem.addActionListener(this);
                if (this.addItemShowing) {
                    this.insert(this.renameItem, 1);
                } else {
                    this.insert(this.renameItem, 0);
                }
                this.revalidate();
                this.renameItemShowing = true;
            } else if (this.renameItemShowing && !bl3) {
                this.remove(this.renameItem);
                this.revalidate();
                this.renameItemShowing = false;
            }
            if (bl2 && !this.deleteItemShowing) {
                this.deleteItem.addActionListener(this);
                if (this.renameItemShowing && this.addItemShowing) {
                    this.insert(this.deleteItem, 2);
                } else if (this.renameItemShowing || this.addItemShowing) {
                    this.insert(this.deleteItem, 1);
                } else {
                    this.insert(this.deleteItem, 0);
                }
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl2) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            if (this.addItemShowing || this.deleteItemShowing || this.renameItemShowing) {
                super.show(component, n, n2);
            }
        }
    }
}

