/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.partitioning;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasPartition;
import com.tridium.eas.api.EasPartitionList;
import com.tridium.eas.api.EasProtected;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.StaticGroup;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.xml.XmlDecoder;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlMessage;
import java.io.DataInputStream;
import java.io.OutputStream;

public class EasPartitionClient {
    public static String[] retrieveUserNames(EasSession easSession) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/partition/userList"));
        int n = dataInputStream.readInt();
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        dataInputStream.close();
        return stringArray;
    }

    public static EasPartition storePartition(EasSession easSession, String string) throws Exception {
        if (string == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/partition/createPartition?partitionName=" + XmlEncoder.encodeUrl(string)));
        int n = dataInputStream.readInt();
        if (n <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        EasPartition easPartition = (EasPartition)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return easPartition;
    }

    public static EasPartition renamePartition(EasSession easSession, int n, String string) throws Exception {
        if (string == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/partition/renamePartition?oldId=" + String.valueOf(n) + "&newName=" + XmlEncoder.encodeUrl(string)));
        int n2 = dataInputStream.readInt();
        if (n2 <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        EasPartition easPartition = (EasPartition)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return easPartition;
    }

    public static boolean deletePartition(EasSession easSession, EasPartition easPartition) throws Exception {
        if (easPartition == null) {
            return false;
        }
        OutputStream outputStream = easSession.put("/eas/partition/deletePartition?partitionId=" + String.valueOf(easPartition.getId()));
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static EasPartition[] retrievePartitions(EasSession easSession) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/partition/partitionList"));
        int n = dataInputStream.readInt();
        if (n <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        EasPartitionList easPartitionList = (EasPartitionList)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return easPartitionList.getPartitions();
    }

    public static EasPartition[] retrievePartitions(EasSession easSession, String string) throws Exception {
        if (string == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/partition/userPartitions?userName=" + XmlEncoder.encodeUrl(string)));
        int n = dataInputStream.readInt();
        if (n <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        EasPartitionList easPartitionList = (EasPartitionList)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return easPartitionList.getPartitions();
    }

    public static EasPartition[] retrievePartitions(EasSession easSession, EasProtected easProtected) throws Exception {
        if (easProtected == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/partition/objectPartitions?easType=" + String.valueOf(easProtected.getProtectedType()) + "&easId=" + XmlEncoder.encodeUrl(easProtected.getProtectedIdentifier())));
        int n = dataInputStream.readInt();
        if (n <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        EasPartitionList easPartitionList = (EasPartitionList)xmlDecoder.decodeDocument();
        dataInputStream.close();
        return easPartitionList.getPartitions();
    }

    public static boolean storePartitions(EasSession easSession, String string, EasPartition[] easPartitionArray) throws Exception {
        if (string == null) {
            return false;
        }
        EasPartitionList easPartitionList = new EasPartitionList("partitionList", easPartitionArray);
        OutputStream outputStream = easSession.put("/eas/partition/saveUserPartitions?userName=" + XmlEncoder.encodeUrl(string));
        XmlEncoder xmlEncoder = new XmlEncoder(outputStream);
        xmlEncoder.encodeDocument(easPartitionList);
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static boolean storePartitions(EasSession easSession, EasProtected easProtected, EasPartition[] easPartitionArray) throws Exception {
        if (easProtected == null) {
            return false;
        }
        EasPartitionList easPartitionList = new EasPartitionList("partitionList", easPartitionArray);
        OutputStream outputStream = easSession.put("/eas/partition/saveObjectPartitions?easType=" + String.valueOf(easProtected.getProtectedType()) + "&easId=" + XmlEncoder.encodeUrl(easProtected.getProtectedIdentifier()));
        XmlEncoder xmlEncoder = new XmlEncoder(outputStream);
        xmlEncoder.encodeDocument(easPartitionList);
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static String[] retrieveUsersForPartition(EasSession easSession, EasPartition easPartition) throws Exception {
        if (easPartition == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/partition/usersForPartition?partitionId=" + String.valueOf(easPartition.getId())));
        int n = dataInputStream.readInt();
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        dataInputStream.close();
        return stringArray;
    }

    public static boolean storeUsersForPartition(EasSession easSession, EasPartition easPartition, String[] stringArray) throws Exception {
        if (easPartition == null) {
            return false;
        }
        XmlMessage xmlMessage = new XmlMessage("userNames");
        if (stringArray != null) {
            int n = stringArray.length;
            xmlMessage.add("count", n);
            for (int i = 0; i < n; ++i) {
                xmlMessage.add("user" + i, stringArray[i]);
            }
        }
        OutputStream outputStream = easSession.put("/eas/partition/saveUsersForPartition?partitionId=" + String.valueOf(easPartition.getId()));
        XmlEncoder xmlEncoder = new XmlEncoder(outputStream);
        xmlEncoder.encodeDocument(xmlMessage);
        outputStream.flush();
        outputStream.close();
        return true;
    }

    public static EasProtected[] retrieveObjectsForPartition(EasSession easSession, EasPartition easPartition, int n) throws Exception {
        if (easPartition == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(easSession.get("/eas/partition/objectsForPartition?partitionId=" + String.valueOf(easPartition.getId()) + "&objType=" + String.valueOf(n)));
        int n2 = dataInputStream.readInt();
        if (n2 <= 0) {
            return null;
        }
        XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
        XmlMessage xmlMessage = (XmlMessage)xmlDecoder.decodeDocument();
        dataInputStream.close();
        EasProtected[] easProtectedArray = null;
        if (n2 > 0) {
            easProtectedArray = new EasProtected[n2];
            block7: for (int i = 0; i < n2; ++i) {
                switch (xmlMessage.getInt("objType" + i)) {
                    case 4: {
                        easProtectedArray[i] = new Rate(xmlMessage.getString("objId" + i));
                        continue block7;
                    }
                    case 0: {
                        easProtectedArray[i] = Site.getSite(xmlMessage.getInt("objId" + i), easSession);
                        continue block7;
                    }
                    case 1: {
                        easProtectedArray[i] = Meter.get(xmlMessage.getInt("objId" + i), easSession);
                        continue block7;
                    }
                    case 2: {
                        easProtectedArray[i] = DataPoint.get(xmlMessage.getInt("objId" + i), easSession);
                        continue block7;
                    }
                    case 3: {
                        easProtectedArray[i] = StaticGroup.getStaticGroup(xmlMessage.getInt("objId" + i), easSession);
                    }
                }
            }
        }
        return easProtectedArray;
    }

    public static boolean storeObjectsForPartition(EasSession easSession, EasPartition easPartition, EasProtected[] easProtectedArray, int n) throws Exception {
        if (easPartition == null) {
            return false;
        }
        XmlMessage xmlMessage = new XmlMessage("protectedObjects");
        if (easProtectedArray != null) {
            int n2 = easProtectedArray.length;
            xmlMessage.add("count", n2);
            for (int i = 0; i < n2; ++i) {
                xmlMessage.add("objType" + i, easProtectedArray[i].getProtectedType());
                xmlMessage.add("objId" + i, easProtectedArray[i].getProtectedIdentifier());
            }
        }
        OutputStream outputStream = easSession.put("/eas/partition/saveObjectsForPartition?partitionId=" + String.valueOf(easPartition.getId()) + "&objType=" + String.valueOf(n));
        XmlEncoder xmlEncoder = new XmlEncoder(outputStream);
        xmlEncoder.encodeDocument(xmlMessage);
        outputStream.flush();
        outputStream.close();
        return true;
    }
}

