/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.inputlist;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.inputlist.InputListItem;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.InputItemSet;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import java.awt.Container;
import java.util.HashSet;
import javax.baja.util.Lexicon;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;

public class MultipleItemPopup
extends EasPopupMenu {
    private static final int REMOVE = 0;
    private static final int CONFIGURE = 1;
    private static final int PASTE_NORMALIZER = 2;
    private static final int REMOVE_NORMALIZER = 3;
    private EasApplication easApplication = null;
    private boolean allowUnitConfig = false;
    private boolean allowDpNormalizer = false;
    private InputList il;
    private InputListItem item;
    private TreePath[] paths = null;
    private EasPopupMenu.EasPopupMenuItem configureItem;
    private EasPopupMenu.EasPopupMenuItem pasteNormalizer;
    private EasPopupMenu.EasPopupMenuItem removeNormalizer;

    public MultipleItemPopup(InputList inputList) {
        this.il = inputList;
        Lexicon lexicon = BEasApplet.lex;
        this.add(new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Remove"), 0, null));
        this.configureItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Configure"), 1, null);
        this.add(this.configureItem);
        this.addSeparator();
        this.pasteNormalizer = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("pasteAsNormalizer"), 2, null);
        this.add(this.pasteNormalizer);
        this.removeNormalizer = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("removeNormalizer"), 3, null);
        this.add(this.removeNormalizer);
    }

    public void arm(TreePath[] treePathArray) {
        EasReport easReport = this.il.getReport();
        this.paths = treePathArray;
        Object object = easReport.getClipboard();
        boolean bl = object instanceof InputItemSet;
        boolean bl2 = false;
        this.configureItem.setEnabled(true);
        this.allowUnitConfig = true;
        this.allowDpNormalizer = true;
        for (int i = 1; i < treePathArray.length; ++i) {
            if (treePathArray[i].getLastPathComponent() instanceof ReportInput) continue;
            this.configureItem.setEnabled(false);
            bl = false;
            this.allowUnitConfig = false;
            this.allowDpNormalizer = false;
            break;
        }
        if (this.configureItem.isEnabled()) {
            ReportInput reportInput = (ReportInput)treePathArray[0].getPathComponent(0);
            boolean bl3 = bl2 = bl2 || reportInput.hasNormalizingPoint();
            if (bl) {
                boolean bl4 = bl = bl && this.supportsDataPointNormalization((InputItemSet)object, reportInput);
            }
            if (this.allowDpNormalizer) {
                this.allowDpNormalizer = this.allowDpNormalizer && this.supportsDataPointNormalization(reportInput);
            }
            for (int i = 1; i < treePathArray.length; ++i) {
                ReportInput reportInput2 = (ReportInput)treePathArray[i].getPathComponent(0);
                if (!reportInput.isCompatible(reportInput2)) {
                    this.allowUnitConfig = false;
                }
                boolean bl5 = bl2 = bl2 || reportInput2.hasNormalizingPoint();
                if (bl) {
                    boolean bl6 = bl = bl && this.supportsDataPointNormalization((InputItemSet)object, reportInput2);
                }
                if (!this.allowDpNormalizer) continue;
                this.allowDpNormalizer = this.allowDpNormalizer && this.supportsDataPointNormalization(reportInput2);
            }
            this.configureItem.setEnabled(this.allowUnitConfig || this.allowDpNormalizer);
        }
        this.pasteNormalizer.setEnabled(bl);
        this.removeNormalizer.setEnabled(bl2);
    }

    private EasApplication getParentApplication() {
        if (this.easApplication != null) {
            return this.easApplication;
        }
        Container container = this.il;
        while (true) {
            if (container instanceof EasApplication) {
                this.easApplication = (EasApplication)container;
                return this.easApplication;
            }
            container = container.getParent();
        }
    }

    private boolean supportsDataPointNormalization(InputItemSet inputItemSet, ReportInput reportInput) {
        if (inputItemSet == null || inputItemSet.getInputItemCount() != 1) {
            return false;
        }
        ReportInputItem reportInputItem = inputItemSet.getInputItems()[0];
        if (reportInputItem.getType() == 1) {
            DataPoint dataPoint = ((SiteDataPoint)reportInputItem).getDataPoint();
            if (dataPoint == null || this.getParentApplication().getSession().getDataPointExec().isMultistate(dataPoint.getName())) {
                return false;
            }
        } else {
            return false;
        }
        return this.supportsDataPointNormalization(reportInput);
    }

    private boolean supportsDataPointNormalization(ReportInput reportInput) {
        ReportInputItem[] reportInputItemArray = reportInput.getInputItems();
        if (reportInputItemArray != null) {
            for (int i = 0; i < reportInputItemArray.length; ++i) {
                if (reportInputItemArray[i].getType() == 1) {
                    DataPoint dataPoint = ((SiteDataPoint)reportInputItemArray[i]).getDataPoint();
                    if (dataPoint == null || this.getParentApplication().getSession().getDataPointExec().isMultistate(dataPoint.getName())) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public void processCommand(int n, Object object) {
        switch (n) {
            case 0: {
                this.remove();
                break;
            }
            case 1: {
                this.configure();
                break;
            }
            case 2: {
                this.pasteNormalizer();
                break;
            }
            case 3: {
                this.removeNormalizer();
            }
        }
    }

    public void itemSelected(JMenuItem jMenuItem) {
        if (jMenuItem instanceof EasPopupMenu.EasPopupMenuItem) {
            return;
        }
        this.il.getReport().popupItemSelected(jMenuItem, this.item);
    }

    private void remove() {
        for (int i = 0; i < this.paths.length; ++i) {
            ReportInput reportInput = (ReportInput)this.paths[i].getPathComponent(0);
            if (this.paths[i].getPathCount() == 1) {
                this.il.getModel().removeInput(reportInput);
                continue;
            }
            InputListItem inputListItem = this.il.getItemForInput(reportInput);
            inputListItem.removeInputItem((ReportInputItem)this.paths[i].getPathComponent(1));
            if (!inputListItem.isEmpty()) continue;
            this.il.getModel().removeInput(reportInput);
        }
        this.il.revalidate();
    }

    private void configure() {
        HashSet<InputListItem> hashSet = new HashSet<InputListItem>();
        for (int i = 0; i < this.paths.length; ++i) {
            InputListItem inputListItem = this.il.getItemForInput((ReportInput)this.paths[i].getPathComponent(0));
            hashSet.add(inputListItem);
        }
        InputListItem[] inputListItemArray = new InputListItem[hashSet.size()];
        this.il.configureItems(hashSet.toArray(inputListItemArray), this.allowUnitConfig, this.allowDpNormalizer);
    }

    private void pasteNormalizer() {
        InputItemSet inputItemSet = (InputItemSet)this.il.getReport().getClipboard();
        if (inputItemSet == null || inputItemSet.getInputItemCount() != 1) {
            return;
        }
        ReportInputItem reportInputItem = inputItemSet.getInputItems()[0];
        if (reportInputItem.getType() == 1) {
            DataPoint dataPoint = ((SiteDataPoint)reportInputItem).getDataPoint();
            for (int i = 0; i < this.paths.length; ++i) {
                ReportInput reportInput = (ReportInput)this.paths[i].getPathComponent(0);
                reportInput.setNormalizingPoint(dataPoint);
            }
            this.il.repaint();
        }
    }

    private void removeNormalizer() {
        for (int i = 0; i < this.paths.length; ++i) {
            ReportInput reportInput = (ReportInput)this.paths[i].getPathComponent(0);
            reportInput.setNormalizingPoint(null);
        }
        this.il.repaint();
    }
}

