/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.inputlist;

import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.InputItemSet;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import javax.baja.util.Lexicon;

public class InputListPopup
extends EasPopupMenu {
    private static final int PASTE = 0;
    private static final int CLEAR = 1;
    private InputList il;
    private EasReport report;
    private EasPopupMenu.EasPopupMenuItem pasteItem;
    private EasPopupMenu.EasPopupMenuItem clearItem;

    public InputListPopup(InputList inputList) {
        this.il = inputList;
        Lexicon lexicon = BEasApplet.lex;
        this.pasteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Paste"), 0, null);
        this.add(this.pasteItem);
        this.clearItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Clear"), 1, null);
        this.add(this.clearItem);
    }

    public void arm() {
        boolean bl;
        EasReport easReport = this.il.getReport();
        Object object = easReport.getClipboard();
        boolean bl2 = bl = object != null;
        if (bl) {
            int n = this.il.getItemCount();
            bl = easReport.allowMultipleInputs() || n == 0;
        }
        this.pasteItem.setEnabled(bl);
        this.clearItem.setEnabled(this.il.getModel().getInputCount() != 0);
    }

    public void processCommand(int n, Object object) {
        switch (n) {
            case 0: {
                this.doPaste();
                break;
            }
            case 1: {
                this.doClear();
            }
        }
    }

    private void doPaste() {
        Object object = this.il.getReport().getClipboard();
        if (object == null) {
            return;
        }
        if (object instanceof InputItemSet) {
            this.il.getReport().addInputItemSet((InputItemSet)object, true);
        }
    }

    private void doClear() {
        this.il.getModel().removeAllInputs();
        this.il.getSelectionModel().clearSelection();
    }
}

