/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.inputlist;

import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.reports.InputItemSet;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class InputListModel {
    private ReportInput[] inputs;
    private ArrayList listeners;
    private Lexicon lex;

    public InputListModel(Lexicon lexicon) {
        this.lex = lexicon;
        this.listeners = new ArrayList();
    }

    public Lexicon getLexicon() {
        return this.lex;
    }

    public void setInputList(InputList inputList) {
        this.addEasDataListener(inputList);
    }

    public void addEasDataListener(EasDataListener easDataListener) {
        this.listeners.add(easDataListener);
    }

    public void removeEasDataListener(EasDataListener easDataListener) {
        this.listeners.remove(easDataListener);
    }

    public void notifyInputHasChanged(ReportInput reportInput) {
        if (reportInput != null) {
            this.fireDataChanged(new ReportInput[]{reportInput});
        }
    }

    private void fireDataChanged(ReportInput[] reportInputArray) {
        if (reportInputArray == null || reportInputArray.length == 0) {
            return;
        }
        DataEditedEvent dataEditedEvent = new DataEditedEvent((Object)this, reportInputArray);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((EasDataListener)iterator.next()).dataChanged(dataEditedEvent);
        }
    }

    private void fireDataInserted(ReportInput reportInput) {
        if (reportInput != null) {
            this.fireDataInserted(new ReportInput[]{reportInput});
        }
    }

    private void fireDataInserted(ReportInput[] reportInputArray) {
        if (reportInputArray == null || reportInputArray.length == 0) {
            return;
        }
        DataEditedEvent dataEditedEvent = new DataEditedEvent((Object)this, reportInputArray);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((EasDataListener)iterator.next()).dataInserted(dataEditedEvent);
        }
    }

    private void fireDataToBeRemoved(ReportInput reportInput) {
        if (reportInput != null) {
            this.fireDataToBeRemoved(new ReportInput[]{reportInput});
        }
    }

    private void fireDataToBeRemoved(ReportInput[] reportInputArray) {
        if (reportInputArray == null || reportInputArray.length == 0) {
            return;
        }
        DataEditedEvent dataEditedEvent = new DataEditedEvent((Object)this, reportInputArray);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((EasDataListener)iterator.next()).dataToBeRemoved(dataEditedEvent);
        }
    }

    private void fireDataRemoved(ReportInput reportInput) {
        if (reportInput != null) {
            this.fireDataRemoved(new ReportInput[]{reportInput});
        }
    }

    private void fireDataRemoved(ReportInput[] reportInputArray) {
        if (reportInputArray == null || reportInputArray.length == 0) {
            return;
        }
        DataEditedEvent dataEditedEvent = new DataEditedEvent((Object)this, reportInputArray);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((EasDataListener)iterator.next()).dataRemoved(dataEditedEvent);
        }
    }

    public int getInputCount() {
        return this.inputs == null ? 0 : this.inputs.length;
    }

    public ReportInput getInput(int n) {
        return this.inputs[n];
    }

    public int indexOfInput(ReportInput reportInput) {
        for (int i = 0; i < this.inputs.length; ++i) {
            if (this.inputs[i] != reportInput) continue;
            return i;
        }
        return -1;
    }

    public ReportInput[] getInputs() {
        return this.inputs;
    }

    public ReportInput[] getEnabledInputs() {
        ArrayList<ReportInput> arrayList = new ArrayList<ReportInput>();
        if (this.inputs != null) {
            for (int i = 0; i < this.inputs.length; ++i) {
                if (!this.inputs[i].isEnabled()) continue;
                arrayList.add(this.inputs[i]);
            }
        }
        ReportInput[] reportInputArray = new ReportInput[arrayList.size()];
        arrayList.toArray(reportInputArray);
        return reportInputArray;
    }

    public void setInputs(ReportInput[] reportInputArray) {
        this.removeAllInputs();
        this.inputs = reportInputArray;
        this.fireDataInserted(reportInputArray);
    }

    public void addItemsToInput(ReportInput reportInput, ReportInputItem[] reportInputItemArray) {
        reportInput.addInputItems(reportInputItemArray);
        this.notifyInputHasChanged(reportInput);
    }

    public ReportInputItem removeItemFromInput(ReportInput reportInput, int n) {
        ReportInputItem reportInputItem = reportInput.removeInputItem(n);
        this.notifyInputHasChanged(reportInput);
        return reportInputItem;
    }

    public boolean addItemsToInput(ReportInput reportInput, InputItemSet inputItemSet) {
        BUnit bUnit = reportInput.getUnit();
        boolean bl = false;
        if (bUnit != null) {
            Vector vector = inputItemSet.getUnitSets();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ReportInputItem[] reportInputItemArray = (ReportInputItem[])vector.elementAt(i);
                BUnit bUnit2 = reportInputItemArray[0].getUnit();
                if (bUnit2 == null || !bUnit.isConvertible(bUnit2)) continue;
                reportInput.addInputItems(reportInputItemArray);
                bl = true;
            }
        } else {
            ReportInputItem[] reportInputItemArray = inputItemSet.getInputItems();
            for (int i = 0; i < reportInputItemArray.length; ++i) {
                if (!reportInputItemArray[i].isCompatible(reportInput.getInputItem(0))) continue;
                reportInput.addInputItem(reportInputItemArray[i]);
                bl = true;
            }
        }
        if (bl) {
            this.notifyInputHasChanged(reportInput);
        }
        return bl;
    }

    public void addInput(ReportInput reportInput) {
        if (this.inputs == null) {
            this.inputs = new ReportInput[]{reportInput};
        } else {
            ReportInput[] reportInputArray = new ReportInput[this.inputs.length + 1];
            System.arraycopy(this.inputs, 0, reportInputArray, 0, this.inputs.length);
            reportInputArray[this.inputs.length] = reportInput;
            this.inputs = reportInputArray;
        }
        this.fireDataInserted(reportInput);
    }

    public void addInputItemSet(InputItemSet inputItemSet) {
        Vector vector = inputItemSet.getUnitSets();
        for (int i = 0; i < vector.size(); ++i) {
            ReportInputItem[] reportInputItemArray = (ReportInputItem[])vector.elementAt(i);
            BUnit bUnit = null;
            try {
                bUnit = reportInputItemArray[0].getUnit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.addInput(new ReportInput(inputItemSet.getName(), bUnit, reportInputItemArray, this.lex));
        }
    }

    public void removeAllInputs() {
        if (this.inputs != null && this.inputs.length != 0) {
            ReportInput[] reportInputArray = this.inputs;
            this.fireDataToBeRemoved(reportInputArray);
            this.inputs = null;
            this.fireDataRemoved(reportInputArray);
        }
    }

    public boolean removeInput(ReportInput reportInput) {
        int n;
        if (this.inputs == null) {
            return false;
        }
        int n2 = this.inputs.length;
        for (n = 0; n < n2; ++n) {
            if (this.inputs[n].getAggregateParent() != reportInput) continue;
            this.inputs[n].setAggregateParent(null);
        }
        for (n = 0; n < n2; ++n) {
            if (this.inputs[n] != reportInput) continue;
            ReportInput reportInput2 = this.inputs[n];
            ReportInput reportInput3 = reportInput2.getAggregateParent();
            this.fireDataToBeRemoved(reportInput2);
            this.removeInput(n);
            this.fireDataRemoved(reportInput2);
            if (reportInput3 != null) {
                this.notifyInputHasChanged(reportInput3);
            }
            return true;
        }
        return false;
    }

    public void removeInput(int n) {
        ReportInput[] reportInputArray = new ReportInput[this.inputs.length - 1];
        if (n > 0) {
            System.arraycopy(this.inputs, 0, reportInputArray, 0, n);
        }
        if (n < this.inputs.length - 1) {
            System.arraycopy(this.inputs, n + 1, reportInputArray, n, this.inputs.length - n - 1);
        }
        this.inputs = reportInputArray;
    }

    public void enableAllInputs() {
        int n = this.getInputCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.inputs[i].setEnabled(true);
        }
        this.fireDataChanged(this.inputs);
    }

    public void disableInput(int n) {
        this.inputs[n].setEnabled(false);
        this.notifyInputHasChanged(this.inputs[n]);
    }

    public void disableInput(ReportInput reportInput) {
        int n = this.indexOfInput(reportInput);
        if (n >= 0) {
            this.disableInput(n);
        }
    }
}

