/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import java.util.HashSet;
import java.util.Set;

public class Tracker {
    private HashSet removedData = new HashSet();
    private HashSet updatedData = new HashSet();
    private HashSet addedData = new HashSet();

    public void trackRemove(Object object) {
        this.removedData.add(object);
        this.addedData.remove(object);
        this.updatedData.remove(object);
    }

    public void trackUpdate(Object object) {
        if (this.removedData.contains(object)) {
            throw new IllegalStateException("attempted to update data to a tracker that's already considered to be removed");
        }
        if (!this.addedData.contains(object)) {
            this.updatedData.add(object);
        }
    }

    public void trackAdd(Object object) {
        if (this.removedData.contains(object)) {
            this.removedData.remove(object);
            this.updatedData.add(object);
        } else {
            if (this.updatedData.contains(object)) {
                throw new IllegalStateException("attempted to add data to a tracker that's already considered to be an update");
            }
            this.addedData.add(object);
        }
    }

    public void clear() {
        this.removedData.clear();
        this.updatedData.clear();
        this.addedData.clear();
    }

    public Set getRemovedData() {
        return this.removedData;
    }

    public Set getUpdatedData() {
        return this.updatedData;
    }

    public Set getAddedData() {
        return this.addedData;
    }
}

