/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.Property;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.GroupPropertiesTableModel;
import com.tridium.eas.ui.widgets.EasDialog;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.UnitTreeComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewPropertyDialog
extends EasDialog
implements ActionListener,
DocumentListener {
    private GroupPropertiesTableModel propsModel = null;
    private JPanel unitComboBoxPanel = null;
    private UnitDatabase.Quantity propType = null;
    private BUnit propUnit = null;
    private String propName = null;
    private JTextField nameTextField = null;
    private UnitTreeComboBox unitComboBox = null;
    private JButton okButton = null;
    private JButton continueButton = null;
    private JButton cancelButton = null;
    private boolean done = false;
    private ResourceManager rm = null;
    private Lexicon lex;

    private NewPropertyDialog(GroupPropertiesTableModel groupPropertiesTableModel, ResourceManager resourceManager, Frame frame, Component component, Lexicon lexicon) {
        super(frame, component);
        this.lex = lexicon;
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.rm = resourceManager;
        this.propsModel = groupPropertiesTableModel;
        if (groupPropertiesTableModel.getGroup() instanceof Site) {
            this.setTitle(lexicon.getText("newSiteProperty"));
        } else {
            this.setTitle(lexicon.getText("newGroupProperty"));
        }
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)new JLabel(lexicon.getText("name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.nameTextField = new EasTextField(20, 32);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.unitComboBoxPanel = new JPanel(new BorderLayout(), true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)new JLabel(lexicon.getText("unit")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.unitComboBoxPanel, gridBagConstraints);
        jComponent.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1), false);
        this.okButton = new JButton(lexicon.getText("saveDone"));
        this.okButton.setActionCommand("ok");
        this.okButton.setEnabled(false);
        jPanel2.add(this.okButton);
        this.continueButton = new JButton(lexicon.getText("saveContinue"));
        this.continueButton.setActionCommand("continue");
        this.continueButton.setEnabled(false);
        jPanel2.add(this.continueButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.setActionCommand("cancel");
        jPanel2.add(this.cancelButton);
        this.registerKeyboardActions(jComponent);
        this.registerKeyboardActions(this.nameTextField);
        this.okButton.addActionListener(this);
        this.continueButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.nameTextField.getDocument().addDocumentListener(this);
        jComponent.add((Component)jPanel2, "South");
    }

    private void registerKeyboardActions(JComponent jComponent) {
        jComponent.registerKeyboardAction(this, "ok", KeyStroke.getKeyStroke(10, 0), 1);
        jComponent.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.dataIsValid());
        this.continueButton.setEnabled(this.dataIsValid());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.dataIsValid());
        this.continueButton.setEnabled(this.dataIsValid());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(this.dataIsValid());
        this.continueButton.setEnabled(this.dataIsValid());
    }

    private void captureFieldData() {
        this.propName = this.nameTextField.getText();
        this.propType = this.unitComboBox.getSelectedMeasure();
        this.propUnit = this.unitComboBox.getSelectedUnit();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton || actionEvent.getActionCommand().equals("ok") && this.okButton.isEnabled()) {
            this.done = true;
            this.captureFieldData();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.continueButton) {
            this.done = false;
            this.captureFieldData();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton || actionEvent.getActionCommand().equals("cancel")) {
            this.done = true;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.unitComboBox) {
            this.okButton.setEnabled(this.dataIsValid());
            this.continueButton.setEnabled(this.dataIsValid());
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.unitComboBox = new UnitTreeComboBox(this.rm, true, this.lex);
            if (this.propUnit == null) {
                if (this.propType != null) {
                    this.unitComboBox.setSelectedItem(this.propType);
                } else {
                    this.unitComboBox.setSelectedItem(BUnit.NULL);
                }
            } else {
                this.unitComboBox.setSelectedItem(this.propUnit);
            }
            this.unitComboBox.addActionListener(this);
            this.unitComboBox.setActionCommand("unitSelected");
            this.unitComboBoxPanel.add((Component)this.unitComboBox, "Center");
        } else {
            this.unitComboBoxPanel.removeAll();
            this.unitComboBox = null;
        }
        this.setModal(true);
        super.setVisible(bl);
    }

    private Property getProperty() {
        if (this.propName == null) {
            return null;
        }
        Property property = new Property(this.propsModel.getGroup(), this.propName, "", this.propType == null ? null : this.propType.getName(), this.propUnit == null ? null : this.propUnit.getUnitName());
        this.propName = null;
        this.nameTextField.setText("");
        this.nameTextField.requestFocus();
        return property;
    }

    private boolean dataIsValid() {
        String string = this.nameTextField.getText();
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        if (this.unitComboBox.getSelectedItem() == null) {
            return false;
        }
        return !this.propsModel.hasProperty(string);
    }

    public static Iterator getNewProperties(GroupPropertiesTableModel groupPropertiesTableModel, ResourceManager resourceManager, Component component, Lexicon lexicon) {
        if (groupPropertiesTableModel == null) {
            return null;
        }
        return new PropertiesIterator(new NewPropertyDialog(groupPropertiesTableModel, resourceManager, NewPropertyDialog.getParentFrame(component), component, lexicon));
    }

    private static class PropertiesIterator
    implements Iterator {
        private NewPropertyDialog dlg = null;
        private Property prop = null;

        public PropertiesIterator(NewPropertyDialog newPropertyDialog) {
            this.dlg = newPropertyDialog;
        }

        public boolean hasNext() {
            if (this.dlg != null && this.dlg.done) {
                return false;
            }
            this.dlg.setVisible(true);
            this.prop = this.dlg.getProperty();
            return this.prop != null;
        }

        public Object next() {
            return this.prop;
        }

        public void remove() {
        }
    }
}

