/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Property;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.EasDialog;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.RcSubtypeWidget;
import com.tridium.eas.ui.widgets.TreeComboBox;
import com.tridium.eas.ui.widgets.UnitComboBox;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.history.BHistoryId;
import javax.baja.naming.SlotPath;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class NewDataPointDialog
extends EasDialog
implements ActionListener {
    private String dpName;
    private String dpStationName;
    private String dpDescr;
    private int dpFlags;
    private BUnit dpFAUnit;
    private double dpFAValue;
    private Meter dpMeter;
    private RcType dpType;
    private RcSubtype dpSubtype;
    private DecimalFormat formatter;
    private EasSession session;
    private XpComboBox meterComboBox;
    private TreeComboBox sourceTreeComboBox;
    private RcSubtypeWidget typeWidget;
    private Site site;
    private UnitComboBox floorAreaUnitComboBox;
    private JTextField descrTextField;
    private NumberTextField floorAreaValueTextField;
    private JButton okButton;
    private JButton continueButton;
    private JButton cancelButton;
    private boolean done;
    private ResourceManager rm;
    private ArrayList dataPoints;
    private HashMap availableLogNames;
    private boolean meterNameEditing;
    private JCheckBox mainCheckBox;
    private boolean dpMain;
    private boolean usesRcSubtypeDescription;
    private Lexicon lex;

    private NewDataPointDialog(Site site, HashMap hashMap, Meter meter, EasSession easSession, ResourceManager resourceManager, Component component, Lexicon lexicon) {
        JPanel jPanel;
        JPanel jPanel2;
        JComponent jComponent;
        block12: {
            super(NewDataPointDialog.getParentFrame(component), component);
            this.dpName = null;
            this.dpStationName = null;
            this.dpDescr = null;
            this.dpFlags = 1;
            this.dpFAUnit = null;
            this.dpFAValue = 0.0;
            this.dpMeter = null;
            this.dpType = null;
            this.dpSubtype = null;
            this.formatter = null;
            this.session = null;
            this.meterComboBox = null;
            this.sourceTreeComboBox = null;
            this.typeWidget = null;
            this.site = null;
            this.floorAreaUnitComboBox = null;
            this.descrTextField = null;
            this.floorAreaValueTextField = null;
            this.okButton = null;
            this.continueButton = null;
            this.cancelButton = null;
            this.done = false;
            this.rm = null;
            this.dataPoints = null;
            this.availableLogNames = null;
            this.meterNameEditing = false;
            this.mainCheckBox = null;
            this.dpMain = false;
            this.usesRcSubtypeDescription = false;
            this.lex = lexicon;
            this.setTitle(this.lex.getText("newDataPoint"));
            this.rm = resourceManager;
            this.site = site;
            this.session = easSession;
            this.done = false;
            this.formatter = new DecimalFormat();
            this.dataPoints = new ArrayList();
            this.availableLogNames = hashMap;
            this.usesRcSubtypeDescription = false;
            jComponent = (JComponent)this.getContentPane();
            jComponent.setLayout(new BorderLayout());
            jPanel2 = new JPanel(new FlowLayout(1), false);
            jPanel = new JPanel(false);
            if (hashMap.isEmpty()) {
                this.cancelButton = new JButton(this.lex.getText("ok"));
                this.cancelButton.setActionCommand("cancel");
                jPanel2.add(this.cancelButton);
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                try {
                    if (site.getOwnedDataPoints().length == 0) {
                        jPanel.add(new JLabel(this.lex.getText("stationNoLogs")));
                        jPanel.add(new JLabel(this.lex.getText("toCreatePoints")));
                        break block12;
                    }
                    jPanel.add(new JLabel(this.lex.getText("logsAlreadyAssigned1")));
                    jPanel.add(new JLabel(this.lex.getText("logsAlreadyAssigned2")));
                    jPanel.add(Box.createRigidArea(new Dimension(0, 3)));
                    jPanel.add(new JLabel(this.lex.getText("addStationsSite1")));
                    jPanel.add(new JLabel(this.lex.getText("addStationsSite2")));
                }
                catch (EasException easException) {
                    jPanel.add(new JLabel(this.lex.getText("errorOccurred")));
                    easException.printStackTrace();
                }
            } else {
                this.okButton = new JButton(this.lex.getText("saveDone"));
                this.okButton.setActionCommand("ok");
                jPanel2.add(this.okButton);
                this.continueButton = new JButton(this.lex.getText("saveContinue"));
                this.okButton.setActionCommand("continue");
                jPanel2.add(this.continueButton);
                this.cancelButton = new JButton(this.lex.getText("cancel"));
                this.cancelButton.setActionCommand("cancel");
                jPanel2.add(this.cancelButton);
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 0, 0);
                int n = 0;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                jPanel.add((Component)new JLabel(this.lex.getText("source")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                this.sourceTreeComboBox = new TreeComboBox(resourceManager, new LogNameRootNode(lexicon)){

                    protected String getLabelText() {
                        return SlotPath.unescape((String)super.getLabelText());
                    }
                };
                this.sourceTreeComboBox.setSelectedItem(hashMap.keySet().iterator().next());
                this.sourceTreeComboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        NewDataPointDialog.this.okButton.setEnabled(NewDataPointDialog.this.dataIsValid());
                        NewDataPointDialog.this.continueButton.setEnabled(NewDataPointDialog.this.dataIsValid() && NewDataPointDialog.this.areMultipleLogChoicesAvailable());
                    }
                });
                jPanel.add((Component)this.sourceTreeComboBox, gridBagConstraints);
                this.registerKeyboardActions(this.sourceTreeComboBox, "cancel", 27);
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                jPanel.add((Component)new JLabel(this.lex.getText("meter")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                this.meterComboBox = new XpComboBox();
                this.meterComboBox.addItem(this.lex.getText("noMeter"));
                this.meterComboBox.addItem(this.lex.getText("typeNewMeter"));
                try {
                    Meter[] meterArray = site.getMeters();
                    for (int i = 0; i < meterArray.length; ++i) {
                        this.meterComboBox.addItem(meterArray[i]);
                    }
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
                this.meterComboBox.addActionListener(new MeterComboBoxActionListener());
                ((JTextComponent)this.meterComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        NewDataPointDialog.this.okButton.setEnabled(NewDataPointDialog.this.dataIsValid());
                        NewDataPointDialog.this.continueButton.setEnabled(NewDataPointDialog.this.dataIsValid() && NewDataPointDialog.this.areMultipleLogChoicesAvailable());
                    }
                });
                ((JComponent)this.meterComboBox.getEditor().getEditorComponent()).setInputVerifier(new InputVerifier(){

                    public boolean verify(JComponent jComponent) {
                        if (NewDataPointDialog.this.meterComboBox.getEditor().getItem().toString().length() > 32) {
                            JOptionPane.showMessageDialog(NewDataPointDialog.this, NewDataPointDialog.this.lex.getText("meterNameLimit"));
                            return false;
                        }
                        return true;
                    }
                });
                this.sourceTreeComboBox.setNextFocusableComponent(this.meterComboBox);
                jPanel.add((Component)this.meterComboBox, gridBagConstraints);
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                jPanel.add((Component)new JLabel(this.lex.getText("type")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                this.typeWidget = new RcSubtypeWidget(resourceManager, this.lex);
                this.typeWidget.addActionListener(new SubtypeWidgetActionListener());
                jPanel.add((Component)this.typeWidget.getPanel(), gridBagConstraints);
                this.meterComboBox.setNextFocusableComponent(this.typeWidget);
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                jPanel.add((Component)new JLabel(this.lex.getText("description")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                this.descrTextField = new EasTextField(15, 100);
                this.descrTextField.getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        NewDataPointDialog.this.usesRcSubtypeDescription = false;
                        NewDataPointDialog.this.okButton.setEnabled(NewDataPointDialog.this.dataIsValid());
                        NewDataPointDialog.this.continueButton.setEnabled(NewDataPointDialog.this.dataIsValid() && NewDataPointDialog.this.areMultipleLogChoicesAvailable());
                    }
                });
                jPanel.add((Component)this.descrTextField, gridBagConstraints);
                this.typeWidget.setNextFocusableComponent(this.descrTextField);
                this.registerKeyboardActions(this.descrTextField, "cancel", 27);
                this.registerKeyboardActions(this.descrTextField, "continue", 10);
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                jPanel.add((Component)new JLabel(this.lex.getText("floorArea")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                this.floorAreaValueTextField = new NumberTextField(6);
                this.floorAreaValueTextField.setAllowNegative(false);
                this.floorAreaValueTextField.setText(this.getSiteFloorAreaValue());
                this.floorAreaValueTextField.setUseLabelAppearanceWhenDisabled(true);
                jPanel.add((Component)this.floorAreaValueTextField, gridBagConstraints);
                this.descrTextField.setNextFocusableComponent(this.floorAreaValueTextField);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                this.floorAreaUnitComboBox = new UnitComboBox(new BUnit[]{BUnit.getUnit((String)"square foot"), BUnit.getUnit((String)"square meter")}, this.lex);
                this.floorAreaUnitComboBox.setSelectedUnit(this.getSiteFloorAreaUnit());
                jPanel.add((Component)this.floorAreaUnitComboBox.getPanel(), gridBagConstraints);
                this.floorAreaValueTextField.setNextFocusableComponent(this.floorAreaUnitComboBox);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                this.mainCheckBox = new JCheckBox(this.lex.getText("mainDataPoint"));
                jPanel.add((Component)this.mainCheckBox, gridBagConstraints);
                this.floorAreaUnitComboBox.setNextFocusableComponent(this.mainCheckBox);
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                this.mainCheckBox.setNextFocusableComponent(this.sourceTreeComboBox);
                this.mainCheckBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (NewDataPointDialog.this.mainCheckBox.isSelected()) {
                            NewDataPointDialog.this.floorAreaValueTextField.setText(NewDataPointDialog.this.getSiteFloorAreaValue());
                            NewDataPointDialog.this.floorAreaUnitComboBox.setSelectedUnit(NewDataPointDialog.this.getSiteFloorAreaUnit());
                        }
                        NewDataPointDialog.this.floorAreaValueTextField.setEnabled(!NewDataPointDialog.this.mainCheckBox.isSelected());
                        NewDataPointDialog.this.floorAreaUnitComboBox.setEnabled(!NewDataPointDialog.this.mainCheckBox.isSelected());
                    }
                });
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                jPanel.add(Box.createRigidArea(new Dimension(0, 10)), gridBagConstraints);
                if (meter == null) {
                    this.meterComboBox.setSelectedItem(this.lex.getText("noMeter"));
                    this.typeWidget.setSelection(RcType.OTHER, RcSubtype.OTHER);
                } else {
                    this.meterComboBox.setSelectedItem(meter);
                    try {
                        this.typeWidget.setSelection(meter.getRcTypeObj(), RcSubtype.OTHER);
                    }
                    catch (EasException easException) {
                        easException.printStackTrace();
                    }
                }
                this.okButton.setEnabled(false);
                this.okButton.addActionListener(this);
                this.continueButton.setEnabled(false);
                this.continueButton.addActionListener(this);
            }
        }
        jComponent.add((Component)jPanel2, "South");
        jComponent.add((Component)jPanel, "Center");
        this.cancelButton.addActionListener(this);
        this.registerKeyboardActions(jComponent, "cancel", 27);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                if (NewDataPointDialog.this.descrTextField != null) {
                    NewDataPointDialog.this.descrTextField.requestFocus();
                }
            }
        });
    }

    private void registerKeyboardActions(JComponent jComponent, String string, int n) {
        jComponent.registerKeyboardAction(this, string, KeyStroke.getKeyStroke(n, 0), 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.continueButton || actionEvent.getActionCommand().equals("continue") && this.okButton.isEnabled() || actionEvent.getSource() == this.okButton || actionEvent.getActionCommand().equals("ok") && this.okButton.isEnabled()) {
            this.done = actionEvent.getSource() == this.okButton || actionEvent.getActionCommand().equals("ok") && this.okButton.isEnabled() || !this.continueButton.isEnabled();
            this.dpName = this.sourceTreeComboBox.getSelectedItem().toString();
            this.dpStationName = (String)this.availableLogNames.get(this.dpName);
            this.dpDescr = this.descrTextField.getText();
            this.dpFlags = 1;
            this.dpFAUnit = this.floorAreaUnitComboBox.getSelectedUnit();
            this.dpType = this.typeWidget.getSelectedRcType();
            this.dpSubtype = this.typeWidget.getSelectedRcSubtype();
            this.dpMain = this.mainCheckBox.isSelected();
            this.dpMeter = this.meterComboBox.getSelectedItem() instanceof Meter ? (Meter)this.meterComboBox.getSelectedItem() : null;
            this.removeLogChoice(this.dpName);
            if (this.floorAreaValueTextField.getText().trim().length() == 0) {
                this.dpFAValue = 0.0;
            } else {
                try {
                    this.dpFAValue = this.formatter.parse(this.floorAreaValueTextField.getText()).doubleValue();
                }
                catch (ParseException parseException) {
                    this.dpFAValue = 0.0;
                }
            }
            DataPoint dataPoint = this.getDataPoint();
            if (dataPoint != null) {
                this.dataPoints.add(dataPoint);
            }
            if (this.done) {
                this.setVisible(false);
            }
        } else if (actionEvent.getSource() == this.cancelButton || actionEvent.getActionCommand().equals("cancel")) {
            this.done = true;
            this.setVisible(false);
        }
    }

    private boolean dataIsValid() {
        if (this.sourceTreeComboBox.getSelectedItem() == null) {
            return false;
        }
        if (!this.meterNameEditing && this.meterComboBox.getSelectedItem() == this.lex.getText("typeNewMeter")) {
            return false;
        }
        if (this.meterComboBox.getSelectedItem() instanceof String && (this.meterNameEditing || this.meterComboBox.getSelectedItem().toString() != this.lex.getText("noMeter"))) {
            String string = this.meterComboBox.getSelectedItem().toString();
            if (this.meterNameEditing) {
                string = this.meterComboBox.getEditor().getItem().toString();
            }
            if (string.length() == 0) {
                return false;
            }
            if (string.equals(this.lex.getText("typeNewMeter"))) {
                return false;
            }
            for (int i = 0; i < this.meterComboBox.getItemCount(); ++i) {
                try {
                    if (this.meterComboBox.getItemAt(i) instanceof Meter && string.equals(((Meter)this.meterComboBox.getItemAt(i)).getName())) {
                        return false;
                    }
                    continue;
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
            }
        }
        return this.descrTextField.getText() != null && this.descrTextField.getText().trim().length() != 0;
    }

    private DataPoint getDataPoint() {
        try {
            if (this.dpName == null) {
                return null;
            }
            if (this.dpMeter == null && this.meterComboBox.getSelectedItem() != this.lex.getText("noMeter")) {
                this.dpMeter = Meter.create(this.meterComboBox.getSelectedItem().toString(), "", this.dpType.getCode(), this.dpMain, this.site, this.dpFAUnit.getUnitName(), this.dpFAValue);
                this.meterComboBox.removeItem(this.meterComboBox.getSelectedItem());
                this.meterComboBox.addItem(this.dpMeter);
                this.meterComboBox.setSelectedItem(this.dpMeter);
            }
            if (this.dpMain) {
                this.mainCheckBox.setSelected(false);
                this.mainCheckBox.setEnabled(false);
            }
            DataPoint dataPoint = this.site.createOwnedDataPoint(this.dpName, this.dpStationName, this.dpDescr, this.dpFlags, this.dpType.getCode(), this.dpSubtype.getCode(), this.dpMain, null, null, this.dpFAUnit.getUnitName(), this.dpFAValue);
            if (this.dpMeter != null) {
                dataPoint.setMeter(this.dpMeter);
            }
            this.site.addOwnedDataPoint(dataPoint);
            this.descrTextField.setText(this.getDefaultDescription());
            this.usesRcSubtypeDescription = true;
            this.descrTextField.requestFocus();
            this.dpName = null;
            this.dpStationName = null;
            this.dpDescr = null;
            this.dpFlags = 1;
            this.dpMain = false;
            this.floorAreaValueTextField.setText("");
            this.dpFAUnit = null;
            this.dpFAValue = 0.0;
            this.dpMeter = null;
            return dataPoint;
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return null;
        }
    }

    public double getSiteFloorAreaValue() {
        Property property = this.site.getProperty("floorarea");
        if (property == null) {
            return 0.0;
        }
        return property.getDouble();
    }

    public BUnit getSiteFloorAreaUnit() {
        Property property = this.site.getProperty("floorarea");
        if (property == null) {
            return BUnit.getUnit((String)"square foot");
        }
        return property.getUnitObject();
    }

    public static synchronized Iterator getNewDataPoints(Site site, HashMap hashMap, Meter meter, EasSession easSession, ResourceManager resourceManager, Component component, Lexicon lexicon) {
        NewDataPointDialog newDataPointDialog = new NewDataPointDialog(site, hashMap, meter, easSession, resourceManager, component, lexicon);
        newDataPointDialog.setVisible(true);
        return newDataPointDialog.dataPoints.iterator();
    }

    protected String getDefaultDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.typeWidget.getSelectedRcSubtype() == RcSubtype.OTHER || this.meterComboBox.getSelectedItem() == this.lex.getText("noMeter")) {
            stringBuffer.append(this.typeWidget.getSelectedRcType().toString());
        }
        if (this.typeWidget.getSelectedRcSubtype() != RcSubtype.OTHER) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.typeWidget.getSelectedRcSubtype().toString());
        }
        return stringBuffer.toString();
    }

    private boolean areMultipleLogChoicesAvailable() {
        if (((TreeNode)this.sourceTreeComboBox.getTree().getModel().getRoot()).getChildCount() == 0) {
            return false;
        }
        if (((TreeNode)this.sourceTreeComboBox.getTree().getModel().getRoot()).getChildCount() > 1) {
            return true;
        }
        return ((TreeNode)this.sourceTreeComboBox.getTree().getModel().getRoot()).getChildAt(0).getChildCount() > 1;
    }

    private void removeLogChoice(String string) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.sourceTreeComboBox.getTree().getModel();
        String string2 = (String)this.availableLogNames.get(string);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sourceTreeComboBox.getTree().getModel().getRoot();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!defaultMutableTreeNode2.getUserObject().equals(string2)) continue;
            for (int j = 0; j < defaultMutableTreeNode2.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(j);
                if (!defaultMutableTreeNode3.getUserObject().equals(string)) continue;
                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode3);
                if (defaultMutableTreeNode2.getChildCount() == 0) {
                    defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
                }
                this.availableLogNames.remove(string);
                if (this.availableLogNames.size() > 0) {
                    if (defaultMutableTreeNode2.getChildCount() == 0) {
                        if (i < defaultMutableTreeNode.getChildCount()) {
                            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                            this.sourceTreeComboBox.setSelectedItem(((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0)).getUserObject());
                        } else {
                            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                            this.sourceTreeComboBox.setSelectedItem(((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0)).getUserObject());
                        }
                    } else if (j < defaultMutableTreeNode2.getChildCount()) {
                        this.sourceTreeComboBox.setSelectedItem(((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(j)).getUserObject());
                    } else if (i < defaultMutableTreeNode.getChildCount() - 1) {
                        defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i + 1);
                        this.sourceTreeComboBox.setSelectedItem(((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0)).getUserObject());
                    } else {
                        defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                        this.sourceTreeComboBox.setSelectedItem(((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0)).getUserObject());
                    }
                }
                return;
            }
        }
        this.availableLogNames.remove(string);
        if (this.availableLogNames.size() > 0) {
            this.sourceTreeComboBox.setSelectedItem(this.availableLogNames.keySet().iterator().next());
        }
    }

    private class HistoryNameDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        private String historyName;

        public HistoryNameDefaultMutableTreeNode(String string) {
            super(string);
            this.historyName = BHistoryId.make((String)string).getHistoryDisplayName();
        }

        public String toString() {
            return this.historyName;
        }
    }

    private class LogNameRootNode
    extends DefaultMutableTreeNode {
        public LogNameRootNode(Lexicon lexicon) {
            super(lexicon.getText("availableLogRoot"));
            Cloneable cloneable;
            Object object;
            String string;
            TreeMap<Object, Cloneable> treeMap = new TreeMap<Object, Cloneable>();
            Iterator iterator = NewDataPointDialog.this.availableLogNames.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                object = (String)NewDataPointDialog.this.availableLogNames.get(string);
                cloneable = (TreeSet<String>)treeMap.get(object);
                if (cloneable == null) {
                    cloneable = new TreeSet<String>();
                    treeMap.put(object, cloneable);
                }
                ((TreeSet)cloneable).add(string);
            }
            iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                object = (TreeSet)treeMap.get(string);
                cloneable = new DefaultMutableTreeNode(string);
                Iterator iterator2 = ((TreeSet)object).iterator();
                while (iterator2.hasNext()) {
                    ((DefaultMutableTreeNode)cloneable).add(new HistoryNameDefaultMutableTreeNode((String)iterator2.next()));
                }
                this.add((MutableTreeNode)((Object)cloneable));
            }
        }
    }

    private class MeterComboBoxActionListener
    implements ActionListener {
        private MeterComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (NewDataPointDialog.this.meterComboBox.getSelectedItem() instanceof Meter) {
                    NewDataPointDialog.this.meterNameEditing = false;
                    NewDataPointDialog.this.dpMeter = (Meter)NewDataPointDialog.this.meterComboBox.getSelectedItem();
                    NewDataPointDialog.this.meterComboBox.setEditable(false);
                    RcType rcType = NewDataPointDialog.this.dpMeter.getRcTypeObj();
                    RcSubtype rcSubtype = null;
                    RcSubtype[] rcSubtypeArray = rcType.getValidSubtypes();
                    for (int i = 0; i < rcSubtypeArray.length; ++i) {
                        if (NewDataPointDialog.this.typeWidget.getSelectedRcSubtype() != rcSubtypeArray[i]) continue;
                        rcSubtype = rcSubtypeArray[i];
                        break;
                    }
                    NewDataPointDialog.this.typeWidget.constrainRcType(rcType);
                    if (rcSubtype != null) {
                        NewDataPointDialog.this.typeWidget.setSelectedRcSubtype(rcSubtype);
                    }
                    if (NewDataPointDialog.this.dpMeter.isMain()) {
                        NewDataPointDialog.this.floorAreaValueTextField.setText(NewDataPointDialog.this.getSiteFloorAreaValue());
                        NewDataPointDialog.this.floorAreaUnitComboBox.setSelectedUnit(NewDataPointDialog.this.getSiteFloorAreaUnit());
                        NewDataPointDialog.this.floorAreaValueTextField.setEnabled(false);
                        NewDataPointDialog.this.floorAreaUnitComboBox.setEnabled(false);
                    } else {
                        NewDataPointDialog.this.floorAreaValueTextField.setEnabled(true);
                        NewDataPointDialog.this.floorAreaUnitComboBox.setEnabled(true);
                    }
                } else if (NewDataPointDialog.this.meterComboBox.getSelectedItem() == NewDataPointDialog.this.lex.getText("noMeter")) {
                    NewDataPointDialog.this.meterNameEditing = false;
                    NewDataPointDialog.this.meterComboBox.setEditable(false);
                    NewDataPointDialog.this.dpMeter = null;
                    NewDataPointDialog.this.typeWidget.removeConstraints();
                    NewDataPointDialog.this.floorAreaValueTextField.setEnabled(true);
                    NewDataPointDialog.this.floorAreaUnitComboBox.setEnabled(true);
                } else {
                    NewDataPointDialog.this.meterComboBox.setEditable(true);
                    NewDataPointDialog.this.dpMeter = null;
                    NewDataPointDialog.this.typeWidget.removeConstraints();
                    NewDataPointDialog.this.floorAreaValueTextField.setEnabled(true);
                    NewDataPointDialog.this.floorAreaUnitComboBox.setEnabled(true);
                    if (!NewDataPointDialog.this.meterNameEditing) {
                        NewDataPointDialog.this.meterComboBox.getEditor().getEditorComponent().requestFocus();
                        ((JTextComponent)NewDataPointDialog.this.meterComboBox.getEditor().getEditorComponent()).selectAll();
                    }
                    NewDataPointDialog.this.meterNameEditing = true;
                }
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
            NewDataPointDialog.this.okButton.setEnabled(NewDataPointDialog.this.dataIsValid());
            NewDataPointDialog.this.continueButton.setEnabled(NewDataPointDialog.this.dataIsValid() && NewDataPointDialog.this.areMultipleLogChoicesAvailable());
        }
    }

    private class SubtypeWidgetActionListener
    implements ActionListener {
        private SubtypeWidgetActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (NewDataPointDialog.this.typeWidget.getSelectedRcType() == RcType.OTHER || NewDataPointDialog.this.typeWidget.getSelectedRcSubtype() == RcSubtype.OTHER && NewDataPointDialog.this.typeWidget.getSelectedRcType().getValidSubtypes().length > 1) {
                    NewDataPointDialog.this.mainCheckBox.setSelected(false);
                    NewDataPointDialog.this.mainCheckBox.setEnabled(false);
                } else {
                    if (NewDataPointDialog.this.descrTextField.getText() == null || NewDataPointDialog.this.descrTextField.getText().trim().length() == 0 || NewDataPointDialog.this.usesRcSubtypeDescription) {
                        NewDataPointDialog.this.descrTextField.setText(NewDataPointDialog.this.getDefaultDescription());
                        NewDataPointDialog.this.usesRcSubtypeDescription = true;
                    }
                    DataPoint[] dataPointArray = NewDataPointDialog.this.site.getOwnedDataPoints();
                    NewDataPointDialog.this.mainCheckBox.setEnabled(true);
                    for (int i = 0; i < dataPointArray.length; ++i) {
                        if (!dataPointArray[i].isMain() || dataPointArray[i].getRcTypeObj() != NewDataPointDialog.this.typeWidget.getSelectedRcType() || dataPointArray[i].getRcSubTypeObj() != NewDataPointDialog.this.typeWidget.getSelectedRcSubtype()) continue;
                        NewDataPointDialog.this.mainCheckBox.setSelected(false);
                        NewDataPointDialog.this.mainCheckBox.setEnabled(false);
                    }
                    Meter[] meterArray = NewDataPointDialog.this.site.getMeters();
                    for (int i = 0; i < meterArray.length; ++i) {
                        if (!meterArray[i].isMain() || meterArray[i] == NewDataPointDialog.this.meterComboBox.getSelectedItem() || meterArray[i].getRcTypeObj() != NewDataPointDialog.this.typeWidget.getSelectedRcType()) continue;
                        NewDataPointDialog.this.mainCheckBox.setSelected(false);
                        NewDataPointDialog.this.mainCheckBox.setEnabled(false);
                    }
                }
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
    }
}

