/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.RcType;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.baja.util.Lexicon;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MeterTypeRadioGroup
extends JComponent
implements ActionListener {
    private int type;
    private JRadioButton[] buttons;
    private ButtonGroup group;
    private ArrayList listeners;
    private boolean holdEvents = false;
    private JPanel panel;
    private CardLayout layout;
    private JLabel label;
    private Lexicon lex;

    public MeterTypeRadioGroup(Lexicon lexicon) {
        this(1, lexicon);
    }

    public MeterTypeRadioGroup(int n, Lexicon lexicon) {
        this.lex = lexicon;
        this.listeners = new ArrayList();
        this.setLayout(new GridLayout(0, n));
        RcType[] rcTypeArray = RcType.getAll();
        this.group = new ButtonGroup();
        this.buttons = new JRadioButton[rcTypeArray.length];
        for (int i = 0; i < rcTypeArray.length; ++i) {
            this.buttons[i] = new JRadioButton(rcTypeArray[i].getDescription(lexicon), rcTypeArray[i] == RcType.OTHER);
            this.buttons[i].getModel().setActionCommand(new String(new char[]{(char)rcTypeArray[i].getCode()}));
            this.buttons[i].getModel().addActionListener(this);
            this.add(this.buttons[i]);
            this.group.add(this.buttons[i]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ButtonModel buttonModel = (ButtonModel)actionEvent.getSource();
        for (int i = 0; i < this.buttons.length; ++i) {
            if (buttonModel != this.buttons[i].getModel()) continue;
            this.type = buttonModel.getActionCommand().charAt(0);
            if (this.label == null) break;
            this.label.setText(this.buttons[i].getText());
            break;
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, buttonModel.getActionCommand()));
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (!this.holdEvents) {
            this.holdEvents = true;
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((ActionListener)iterator.next()).actionPerformed(actionEvent);
            }
            this.holdEvents = false;
        }
    }

    public RcType getRcType() {
        return RcType.getByCode(this.type);
    }

    public int getType() {
        return this.type;
    }

    public void setEnabled(int n, boolean bl) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i].getModel().getActionCommand().charAt(0) != n) continue;
            this.buttons[i].setEnabled(bl);
        }
    }

    public void setRcType(RcType rcType) {
        this.setType(rcType.getCode());
    }

    public void setType(int n) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i].getModel().getActionCommand().charAt(0) != n) continue;
            this.buttons[i].setSelected(true);
            this.type = n;
            if (this.label == null) continue;
            this.label.setText(this.buttons[i].getText());
        }
    }

    public JPanel getPanel() {
        this.layout = new CardLayout();
        this.panel = new JPanel(this.layout, false);
        this.panel.add(this.lex.getText("enabled"), this);
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.label = new JLabel();
        this.label.setForeground(Color.darkGray);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 3;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this.panel.add(this.lex.getText("disabled"), jPanel);
        this.setEnabled(this.isEnabled());
        return this.panel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setEnabled(bl);
        }
        if (this.panel != null) {
            if (this.group.getSelection() == null) {
                this.label.setText("");
            } else {
                this.label.setText(this.group.getSelection().getActionCommand());
            }
            this.layout.show(this.panel, bl ? this.lex.getText("enabled") : this.lex.getText("disabled"));
        }
    }
}

