/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.Meter;
import com.tridium.eas.ui.widgets.EasDialog;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.baja.util.Lexicon;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MeterChoiceDialog
extends EasDialog {
    private XpComboBox meterComboBox;
    private DataPoint dp;
    private boolean change;
    private Lexicon lex;

    private MeterChoiceDialog(DataPoint dataPoint, Component component, Lexicon lexicon) {
        super(MeterChoiceDialog.getParentFrame(component), component);
        Object object;
        this.lex = lexicon;
        this.setTitle(lexicon.getText("meter"));
        this.dp = dataPoint;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        try {
            object = this.dp.getSite().getMeters();
            this.meterComboBox = new XpComboBox();
            this.meterComboBox.addItem(lexicon.getText("notInMeter"));
            for (int i = 0; i < ((Meter[])object).length; ++i) {
                if (object[i].getRcTypeObj() != this.dp.getRcTypeObj()) continue;
                this.meterComboBox.addItem(object[i]);
            }
            if (this.dp.getMeter() == null) {
                this.meterComboBox.setSelectedItem(lexicon.getText("notInMeter"));
            } else {
                this.meterComboBox.setSelectedItem(this.dp.getMeter());
            }
            jComponent.add(this.meterComboBox);
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        jComponent.add(Box.createRigidArea(new Dimension(0, 30)));
        object = new JPanel(new FlowLayout(1), false);
        JButton jButton = new JButton(lexicon.getText("ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (MeterChoiceDialog.this.meterComboBox.getSelectedItem() instanceof Meter) {
                        MeterChoiceDialog.this.dp.setMeter((Meter)MeterChoiceDialog.this.meterComboBox.getSelectedItem());
                    } else {
                        MeterChoiceDialog.this.dp.setMeter(null);
                    }
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
                MeterChoiceDialog.this.change = true;
                MeterChoiceDialog.this.setVisible(false);
            }
        });
        ((Container)object).add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton(lexicon.getText("cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeterChoiceDialog.this.change = false;
                MeterChoiceDialog.this.setVisible(false);
            }
        });
        ((Container)object).add(jButton2);
        jComponent.add((Component)object);
    }

    protected boolean isChanged() {
        return this.change;
    }

    public static boolean setMeter(DataPoint dataPoint, Component component, Lexicon lexicon) {
        MeterChoiceDialog meterChoiceDialog = new MeterChoiceDialog(dataPoint, component, lexicon);
        meterChoiceDialog.setVisible(true);
        return meterChoiceDialog.isChanged();
    }
}

