/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.StaticGroup;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasEditorListener;
import com.tridium.eas.ui.dbconfig.GroupEditor;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import java.awt.Cursor;
import java.util.EventObject;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class GroupTree
extends FilterTree
implements EasEditorListener,
TreeSelectionListener {
    GroupEditor staticGroupEditor = null;
    GroupEditor siteEditor = null;
    EasSession session = null;

    public GroupTree(ResourceManager resourceManager) {
        super(resourceManager);
        this.addTreeSelectionListener(this);
    }

    public void setStaticGroupEditor(GroupEditor groupEditor) {
        this.staticGroupEditor = groupEditor;
        this.staticGroupEditor.addEasEditorListener(this);
    }

    public void setSiteEditor(GroupEditor groupEditor) {
        this.siteEditor = groupEditor;
        this.siteEditor.addEasEditorListener(this);
    }

    public void removeSelectedNode() {
        TreePath[] treePathArray = this.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            FilterTreeNode filterTreeNode = (FilterTreeNode)treePathArray[i].getParentPath().getLastPathComponent();
            filterTreeNode.reload();
            this.getFilterTreeModel().reload(filterTreeNode);
        }
    }

    public void setSelectedGroup(StaticGroup staticGroup) {
        this.setSelectedUserObject(staticGroup);
    }

    public void setSelectedGroup(long l) {
        try {
            this.setSelectedUserObject(Group.get(l, this.session));
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void setSelectedSite(long l) {
        try {
            this.setSelectedUserObject(Site.get(l, this.session));
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void init(EasSession easSession) {
        this.session = easSession;
        if (this.getModel() instanceof FilterTreeModel) {
            ((FilterTreeNode)this.getModel().getRoot()).reload();
            ((FilterTreeModel)this.getModel()).reload();
        }
    }

    public void editingCancelled(EventObject eventObject) {
        Object object = this.getSelectedUserObject();
        if (object instanceof StaticGroup && this.staticGroupEditor != null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.staticGroupEditor.setGroupEditorValue((StaticGroup)object);
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (object instanceof Site && this.siteEditor != null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.siteEditor.setGroupEditorValue((Site)object);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.setEnabled(true);
    }

    public void editingDeleted(EventObject eventObject) {
        this.removeSelectedNode();
    }

    public void editingStopped(EventObject eventObject) {
        this.setSelectedUserObject(((GroupEditor)eventObject.getSource()).getGroupEditorValue());
        this.setEnabled(true);
    }

    public void editingStarted(EventObject eventObject) {
        Object object = this.getSelectedUserObject();
        if (object != ((GroupEditor)eventObject.getSource()).getGroupEditorValue()) {
            this.setSelectedUserObject(((GroupEditor)eventObject.getSource()).getGroupEditorValue());
        }
        this.setEnabled(false);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = this.getSelectedUserObject();
        if (object instanceof StaticGroup) {
            if (this.staticGroupEditor != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.staticGroupEditor.setGroupEditorValue((StaticGroup)object);
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (this.siteEditor != null) {
                this.siteEditor.setGroupEditorValue(null);
            }
        } else if (object instanceof Site) {
            if (this.staticGroupEditor != null) {
                this.staticGroupEditor.setGroupEditorValue(null);
            }
            if (this.siteEditor != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.siteEditor.setGroupEditorValue((Site)object);
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            if (this.staticGroupEditor != null) {
                this.staticGroupEditor.setGroupEditorValue(null);
            }
            if (this.siteEditor != null) {
                this.siteEditor.setGroupEditorValue(null);
            }
        }
    }
}

