/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.StaticGroup;
import com.tridium.eas.cost.ui.CreateARateApplication;
import com.tridium.eas.cost.ui.linking.AttachARateApplication;
import com.tridium.eas.cost.ui.reports.budget.EnterBudgetPanel;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.DbConfigNavigator;
import com.tridium.eas.ui.dbconfig.EasEditorListener;
import com.tridium.eas.ui.dbconfig.GroupEditor;
import com.tridium.eas.ui.dbconfig.GroupTree;
import com.tridium.eas.ui.dbconfig.SiteDetailPanel;
import com.tridium.eas.ui.dbconfig.StaticGroupDetailPanel;
import com.tridium.eas.ui.partitioning.PartitionConfigPanel;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import com.tridium.eas.ui.widgets.FilterTreePopupHandler;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.baja.util.Lexicon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DbConfigApplication
extends EasApplication
implements EasEditorListener,
DbConfigNavigator,
ResourceManager {
    private boolean dbConfigStarted = false;
    private ArrayList activeEditors = new ArrayList();
    private JTabbedPane tabs = null;
    private GroupTree sites = null;
    private JSplitPane siteSplit;
    private JSplitPane groupSplit;
    private SiteDetailPanel siteDetails = null;
    private GroupTree groupTree = null;
    private CardLayout toolbarCardLayout = null;
    private JPanel toolbarCardPanel = null;
    private SitePopup sitePopup = null;
    private GroupPopup groupPopup = null;
    private StaticGroupDetailPanel groupDetailsPanel = null;
    private CreateARateApplication createAratePanel = null;
    private AttachARateApplication attachAratePanel = null;
    private EnterBudgetPanel enterBudgetPanel = null;
    private PartitionConfigPanel partitioningPanel = null;
    static /* synthetic */ Class class$com$tridium$eas$api$Site;
    static /* synthetic */ Class class$com$tridium$eas$api$StaticGroup;

    public String getName() {
        Lexicon lexicon = BEasApplet.lex;
        return lexicon.getText("dbConfig");
    }

    public String getId() {
        return "dbconfig";
    }

    protected JComponent getApplicationContent() {
        Lexicon lexicon = BEasApplet.lex;
        this.tabs = new JTabbedPane();
        this.tabs.add(lexicon.getText("sites"), this.buildSiteTabContents());
        this.tabs.add(lexicon.getText("groups"), this.buildGroupTabContents());
        boolean bl = this.getSession().hasAdminWrite();
        boolean bl2 = Meter.isEasCostLicensed(this.getSession());
        boolean bl3 = !bl2 && !Meter.isEasE2Licensed(this.getSession());
        boolean bl4 = false;
        if (bl && (bl2 || bl3)) {
            this.tabs.add(lexicon.getText("createArate"), this.buildCreateARateTabContents());
            this.tabs.add(lexicon.getText("attachArate"), this.buildAttachARateTabContents());
            this.tabs.add(lexicon.getText("enterBudget"), this.buildEnterBudgetTabContents());
        }
        if (bl && bl4) {
            this.tabs.add(lexicon.getText("partitioning"), this.buildPartitioningTabContents());
        }
        EasButton easButton = new EasButton((ResourceManager)this, 17, lexicon.getText("reload"));
        easButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DbConfigApplication.this.initApplication(true);
            }
        });
        EasButton easButton2 = new EasButton((ResourceManager)this, 17, lexicon.getText("reload"));
        easButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DbConfigApplication.this.initApplication(true);
            }
        });
        this.toolbarCardLayout = new CardLayout();
        this.toolbarCardPanel = new JPanel(this.toolbarCardLayout, false);
        JToolBar jToolBar = this.siteDetails.getToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add((Component)easButton, 0);
        this.toolbarCardPanel.add(lexicon.getText("sites"), jToolBar);
        jToolBar = this.groupDetailsPanel.getToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add((Component)easButton2, 0);
        this.toolbarCardPanel.add(lexicon.getText("groups"), jToolBar);
        if (bl && (bl2 || bl3)) {
            jToolBar = this.createAratePanel.getToolBar();
            jToolBar.setFloatable(false);
            this.toolbarCardPanel.add(lexicon.getText("createArate"), jToolBar);
            jToolBar = this.attachAratePanel.getToolBar();
            jToolBar.setFloatable(false);
            this.toolbarCardPanel.add(lexicon.getText("attachArate"), jToolBar);
            jToolBar = this.enterBudgetPanel.getToolBar();
            jToolBar.setFloatable(false);
            this.toolbarCardPanel.add(lexicon.getText("enterBudget"), jToolBar);
        }
        if (bl && bl4) {
            jToolBar = this.partitioningPanel.getToolBar();
            jToolBar.setFloatable(false);
            this.toolbarCardPanel.add(lexicon.getText("partitioning"), jToolBar);
        }
        this.siteDetails.addEasDataListener(this.sites);
        this.siteDetails.addEasDataListener(this.groupDetailsPanel);
        this.groupDetailsPanel.addEasDataListener(this.siteDetails);
        this.groupDetailsPanel.addEasDataListener(this.groupTree);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Lexicon lexicon = BEasApplet.lex;
                if (DbConfigApplication.this.tabs.getSelectedIndex() == DbConfigApplication.this.tabs.indexOfTab(lexicon.getText("sites"))) {
                    DbConfigApplication.this.toolbarCardLayout.show(DbConfigApplication.this.toolbarCardPanel, lexicon.getText("sites"));
                    DbConfigApplication.this.siteDetails.getToolBar().setVisible(true);
                    DbConfigApplication.this.groupDetailsPanel.getToolBar().setVisible(false);
                    if (DbConfigApplication.this.createAratePanel != null) {
                        DbConfigApplication.this.createAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.attachAratePanel != null) {
                        DbConfigApplication.this.attachAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.enterBudgetPanel != null) {
                        DbConfigApplication.this.enterBudgetPanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.partitioningPanel != null) {
                        DbConfigApplication.this.partitioningPanel.getToolBar().setVisible(false);
                    }
                } else if (DbConfigApplication.this.tabs.getSelectedIndex() == DbConfigApplication.this.tabs.indexOfTab(lexicon.getText("groups"))) {
                    DbConfigApplication.this.toolbarCardLayout.show(DbConfigApplication.this.toolbarCardPanel, lexicon.getText("groups"));
                    DbConfigApplication.this.siteDetails.getToolBar().setVisible(false);
                    DbConfigApplication.this.groupDetailsPanel.getToolBar().setVisible(true);
                    if (DbConfigApplication.this.createAratePanel != null) {
                        DbConfigApplication.this.createAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.attachAratePanel != null) {
                        DbConfigApplication.this.attachAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.enterBudgetPanel != null) {
                        DbConfigApplication.this.enterBudgetPanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.partitioningPanel != null) {
                        DbConfigApplication.this.partitioningPanel.getToolBar().setVisible(false);
                    }
                } else if (DbConfigApplication.this.tabs.getSelectedIndex() == DbConfigApplication.this.tabs.indexOfTab(lexicon.getText("createArate"))) {
                    DbConfigApplication.this.toolbarCardLayout.show(DbConfigApplication.this.toolbarCardPanel, lexicon.getText("createArate"));
                    DbConfigApplication.this.siteDetails.getToolBar().setVisible(false);
                    DbConfigApplication.this.groupDetailsPanel.getToolBar().setVisible(false);
                    if (DbConfigApplication.this.createAratePanel != null) {
                        DbConfigApplication.this.createAratePanel.getToolBar().setVisible(true);
                    }
                    if (DbConfigApplication.this.attachAratePanel != null) {
                        DbConfigApplication.this.attachAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.enterBudgetPanel != null) {
                        DbConfigApplication.this.enterBudgetPanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.partitioningPanel != null) {
                        DbConfigApplication.this.partitioningPanel.getToolBar().setVisible(false);
                    }
                } else if (DbConfigApplication.this.tabs.getSelectedIndex() == DbConfigApplication.this.tabs.indexOfTab(lexicon.getText("attachArate"))) {
                    DbConfigApplication.this.toolbarCardLayout.show(DbConfigApplication.this.toolbarCardPanel, lexicon.getText("attachArate"));
                    DbConfigApplication.this.siteDetails.getToolBar().setVisible(false);
                    DbConfigApplication.this.groupDetailsPanel.getToolBar().setVisible(false);
                    if (DbConfigApplication.this.createAratePanel != null) {
                        DbConfigApplication.this.createAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.attachAratePanel != null) {
                        DbConfigApplication.this.attachAratePanel.refreshRates();
                        DbConfigApplication.this.attachAratePanel.getToolBar().setVisible(true);
                    }
                    if (DbConfigApplication.this.enterBudgetPanel != null) {
                        DbConfigApplication.this.enterBudgetPanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.partitioningPanel != null) {
                        DbConfigApplication.this.partitioningPanel.getToolBar().setVisible(false);
                    }
                } else if (DbConfigApplication.this.tabs.getSelectedIndex() == DbConfigApplication.this.tabs.indexOfTab(lexicon.getText("enterBudget"))) {
                    DbConfigApplication.this.toolbarCardLayout.show(DbConfigApplication.this.toolbarCardPanel, lexicon.getText("enterBudget"));
                    DbConfigApplication.this.siteDetails.getToolBar().setVisible(false);
                    DbConfigApplication.this.groupDetailsPanel.getToolBar().setVisible(false);
                    if (DbConfigApplication.this.createAratePanel != null) {
                        DbConfigApplication.this.createAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.attachAratePanel != null) {
                        DbConfigApplication.this.attachAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.enterBudgetPanel != null) {
                        DbConfigApplication.this.enterBudgetPanel.getToolBar().setVisible(true);
                    }
                    if (DbConfigApplication.this.partitioningPanel != null) {
                        DbConfigApplication.this.partitioningPanel.getToolBar().setVisible(false);
                    }
                } else if (DbConfigApplication.this.tabs.getSelectedIndex() == DbConfigApplication.this.tabs.indexOfTab(lexicon.getText("partitioning"))) {
                    DbConfigApplication.this.toolbarCardLayout.show(DbConfigApplication.this.toolbarCardPanel, lexicon.getText("partitioning"));
                    DbConfigApplication.this.siteDetails.getToolBar().setVisible(false);
                    DbConfigApplication.this.groupDetailsPanel.getToolBar().setVisible(false);
                    if (DbConfigApplication.this.createAratePanel != null) {
                        DbConfigApplication.this.createAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.attachAratePanel != null) {
                        DbConfigApplication.this.attachAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.enterBudgetPanel != null) {
                        DbConfigApplication.this.enterBudgetPanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.partitioningPanel != null) {
                        DbConfigApplication.this.partitioningPanel.refreshRates();
                        DbConfigApplication.this.partitioningPanel.getToolBar().setVisible(true);
                    }
                } else {
                    DbConfigApplication.this.siteDetails.getToolBar().setVisible(false);
                    DbConfigApplication.this.groupDetailsPanel.getToolBar().setVisible(false);
                    if (DbConfigApplication.this.createAratePanel != null) {
                        DbConfigApplication.this.createAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.attachAratePanel != null) {
                        DbConfigApplication.this.attachAratePanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.enterBudgetPanel != null) {
                        DbConfigApplication.this.enterBudgetPanel.getToolBar().setVisible(false);
                    }
                    if (DbConfigApplication.this.partitioningPanel != null) {
                        DbConfigApplication.this.partitioningPanel.getToolBar().setVisible(false);
                    }
                }
            }
        });
        return this.tabs;
    }

    private JComponent buildSiteTabContents() {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.sites = new GroupTree(this.getResourceManager());
        this.sites.setShowsRootHandles(false);
        this.sites.getSelectionModel().setSelectionMode(1);
        this.sites.setPopupHandler(new FilterTreePopupHandler(){

            public void openPopup(FilterTree filterTree, FilterTreeNode filterTreeNode, int n, int n2) {
                if (filterTree.isEnabled()) {
                    if (DbConfigApplication.this.sitePopup == null) {
                        Lexicon lexicon = BEasApplet.lex;
                        DbConfigApplication dbConfigApplication = DbConfigApplication.this;
                        dbConfigApplication.getClass();
                        DbConfigApplication.this.sitePopup = dbConfigApplication.new SitePopup(lexicon);
                    }
                    DbConfigApplication.this.sitePopup.show(filterTree, filterTreeNode != null, n, n2);
                }
            }
        });
        this.sites.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 155) {
                    DbConfigApplication.this.siteDetails.createNewSite();
                } else if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    DbConfigApplication.this.siteDetails.deleteSite();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.sites);
        jPanel.add((Component)jScrollPane, "Center");
        Lexicon lexicon = BEasApplet.lex;
        this.siteDetails = new SiteDetailPanel(this, this, lexicon);
        this.sites.setSiteEditor(this.siteDetails);
        this.siteDetails.addEasEditorListener(this);
        this.siteSplit = new JSplitPane(1, jPanel, this.siteDetails);
        return this.siteSplit;
    }

    private JComponent buildGroupTabContents() {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.groupTree = new GroupTree(this.getResourceManager());
        this.groupTree.getSelectionModel().setSelectionMode(1);
        this.groupTree.setPopupHandler(new FilterTreePopupHandler(){

            public void openPopup(FilterTree filterTree, FilterTreeNode filterTreeNode, int n, int n2) {
                if (filterTree.isEnabled()) {
                    if (DbConfigApplication.this.groupPopup == null) {
                        Lexicon lexicon = BEasApplet.lex;
                        DbConfigApplication dbConfigApplication = DbConfigApplication.this;
                        dbConfigApplication.getClass();
                        DbConfigApplication.this.groupPopup = dbConfigApplication.new GroupPopup(lexicon);
                    }
                    DbConfigApplication.this.groupPopup.show(filterTree, filterTreeNode != null, n, n2);
                }
            }
        });
        this.groupTree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 155) {
                    DbConfigApplication.this.groupDetailsPanel.addGroup();
                } else if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    DbConfigApplication.this.groupDetailsPanel.deleteGroup();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.groupTree);
        Lexicon lexicon = BEasApplet.lex;
        this.groupDetailsPanel = new StaticGroupDetailPanel(this, this, lexicon);
        this.groupTree.setStaticGroupEditor(this.groupDetailsPanel);
        this.groupDetailsPanel.addEasEditorListener(this);
        this.groupSplit = new JSplitPane(1, jScrollPane, this.groupDetailsPanel);
        jPanel.add((Component)this.groupSplit, "Center");
        return jPanel;
    }

    private JComponent buildCreateARateTabContents() {
        this.createAratePanel = new CreateARateApplication(this);
        return this.createAratePanel;
    }

    private JComponent buildAttachARateTabContents() {
        this.attachAratePanel = new AttachARateApplication(this);
        return this.attachAratePanel;
    }

    private JComponent buildEnterBudgetTabContents() {
        this.enterBudgetPanel = new EnterBudgetPanel(this);
        return this.enterBudgetPanel;
    }

    private JComponent buildPartitioningTabContents() {
        this.partitioningPanel = new PartitionConfigPanel(this);
        return this.partitioningPanel;
    }

    public void initApplication(boolean bl) {
        if (this.createAratePanel != null) {
            this.createAratePanel.initApplication(bl);
        }
        if (this.attachAratePanel != null) {
            this.attachAratePanel.initApplication(bl);
        }
        if (this.enterBudgetPanel != null) {
            this.enterBudgetPanel.initApplication(bl);
        }
        if (this.partitioningPanel != null) {
            this.partitioningPanel.initApplication(bl);
        }
        if (bl) {
            this.sites.init(this.getSession());
            Lexicon lexicon = BEasApplet.lex;
            this.sites.setModel(new FilterTreeModel(new FilterRootNode((Filter)new AllSitesFilter(this.getSession(), lexicon), new Class[]{class$com$tridium$eas$api$Site == null ? (class$com$tridium$eas$api$Site = DbConfigApplication.class$("com.tridium.eas.api.Site")) : class$com$tridium$eas$api$Site})));
            this.sites.setEnabled(true);
            this.siteDetails.init(this.getSession());
            this.groupDetailsPanel.init(this.getSession(), this);
            this.groupTree.init(this.getSession());
            this.groupTree.setModel(new FilterTreeModel(new FilterRootNode((Filter)new StaticGroupFilter(this.getSession(), lexicon), new Class[]{class$com$tridium$eas$api$StaticGroup == null ? (class$com$tridium$eas$api$StaticGroup = DbConfigApplication.class$("com.tridium.eas.api.StaticGroup")) : class$com$tridium$eas$api$StaticGroup})));
            this.groupTree.setEnabled(true);
            this.tabs.setEnabled(true);
            this.activeEditors.clear();
        }
    }

    protected void startApplication() {
        this.dbConfigStarted = true;
        this.siteSplit.setDividerLocation(Math.max(this.sites.getPreferredSize().width + 10, 100));
        this.groupSplit.setDividerLocation(Math.max(this.groupTree.getPreferredSize().width + 10, 100));
        if (this.createAratePanel != null) {
            this.createAratePanel.startApplication();
        }
    }

    public void editingCancelled(EventObject eventObject) {
        this.activeEditors.remove(eventObject.getSource());
        this.tabs.setEnabled(this.activeEditors.isEmpty());
    }

    public void editingStopped(EventObject eventObject) {
        this.activeEditors.remove(eventObject.getSource());
        this.tabs.setEnabled(this.activeEditors.isEmpty());
    }

    public void editingStarted(EventObject eventObject) {
        this.activeEditors.add(eventObject.getSource());
        this.tabs.setEnabled(false);
    }

    public void editingDeleted(EventObject eventObject) {
        this.activeEditors.remove(eventObject.getSource());
        this.tabs.setEnabled(this.activeEditors.isEmpty());
    }

    public void navigateTo(Object object) {
        if (object instanceof Site) {
            this.navigateSite(((Site)object).getId());
        } else if (object instanceof StaticGroup) {
            this.navigateGroup(((StaticGroup)object).getId());
        }
    }

    public void navigateGroup(long l) {
        Lexicon lexicon = BEasApplet.lex;
        this.tabs.setSelectedIndex(this.tabs.indexOfTab(lexicon.getText("groups")));
        this.groupTree.setSelectedGroup(l);
    }

    public void navigateSite(long l) {
        Lexicon lexicon = BEasApplet.lex;
        this.tabs.setSelectedIndex(this.tabs.indexOfTab(lexicon.getText("sites")));
        this.sites.setSelectedSite(l);
    }

    protected JComponent getApplicationToolBar() {
        return this.toolbarCardPanel;
    }

    protected void stopApplication() {
        if (this.dbConfigStarted) {
            Iterator iterator = this.activeEditors.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof GroupEditor)) continue;
                ((GroupEditor)e).stopGroupEditing(true);
            }
            if (this.siteDetails != null) {
                this.siteDetails.clearLogCache();
            }
            if (this.createAratePanel != null) {
                this.createAratePanel.stopApplication();
            }
            if (this.attachAratePanel != null) {
                this.attachAratePanel.stopApplication();
            }
            if (this.enterBudgetPanel != null) {
                this.enterBudgetPanel.stopApplication();
            }
            if (this.partitioningPanel != null) {
                this.partitioningPanel.stopApplication();
            }
            this.dbConfigStarted = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class GroupPopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem addItem = null;
        private boolean addItemShowing = false;
        private Lexicon lex;

        public GroupPopup(Lexicon lexicon) {
            this.lex = lexicon;
            this.addItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("newGroup"), 0, null);
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("deleteGroup"), 1, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    DbConfigApplication.this.groupDetailsPanel.addGroup();
                    break;
                }
                case 1: {
                    DbConfigApplication.this.groupDetailsPanel.deleteGroup();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            boolean bl2 = bl && DbConfigApplication.this.groupDetailsPanel.canUpdate();
            boolean bl3 = DbConfigApplication.this.groupDetailsPanel.canAdd();
            if (bl2 && !this.deleteItemShowing) {
                this.add(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl2) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            if (bl3 && !this.addItemShowing) {
                this.add(this.addItem);
                this.revalidate();
                this.addItemShowing = true;
            } else if (this.addItemShowing && !bl3) {
                this.remove(this.addItem);
                this.revalidate();
                this.addItemShowing = false;
            }
            if (this.addItemShowing || this.deleteItemShowing) {
                super.show(component, n, n2);
            }
        }
    }

    private class SitePopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem addItem = null;
        private boolean addItemShowing = false;
        private Lexicon lex;

        public SitePopup(Lexicon lexicon) {
            this.lex = lexicon;
            this.addItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("addSite"), 0, null);
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("deleteSite"), 1, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    DbConfigApplication.this.siteDetails.createNewSite();
                    break;
                }
                case 1: {
                    DbConfigApplication.this.siteDetails.deleteSite();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            boolean bl2 = bl && DbConfigApplication.this.siteDetails.canUpdate();
            boolean bl3 = DbConfigApplication.this.siteDetails.canAdd();
            if (bl2 && !this.deleteItemShowing) {
                this.add(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl2) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            if (bl3 && !this.addItemShowing) {
                this.add(this.addItem);
                this.revalidate();
                this.addItemShowing = true;
            } else if (this.addItemShowing && !bl3) {
                this.remove(this.addItem);
                this.revalidate();
                this.addItemShowing = false;
            }
            if (this.addItemShowing || this.deleteItemShowing) {
                super.show(component, n, n2);
            }
        }
    }
}

