/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.RcType;
import com.tridium.eas.ui.EasUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataPointSummaryPanel
extends JPanel {
    private JLabel nameLabel = null;
    private JLabel descrLabel = null;
    private JLabel meterLabel = null;
    private JLabel unitLabel = null;
    private JLabel typeLabel = null;
    private JLabel siteLabel = null;
    private JLabel timeZoneLabel = null;
    private Lexicon lex;

    public DataPointSummaryPanel(Lexicon lexicon) {
        this.lex = lexicon;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("description")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.descrLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.descrLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("site")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.siteLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.siteLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("type")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.typeLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.typeLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("source")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.nameLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("meter")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.meterLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.meterLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("unit")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.unitLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.unitLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("timeZone")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.timeZoneLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.timeZoneLabel, gridBagConstraints);
        this.add((Component)jPanel, "North");
    }

    public void setDataPoint(DataPoint dataPoint) {
        try {
            this.nameLabel.setText(this.getShortDPSource(dataPoint.getName()));
            this.nameLabel.setToolTipText(dataPoint.getName());
            this.siteLabel.setText(dataPoint.getSite().getName());
            if (dataPoint.getRcTypeObj() == RcType.OTHER || dataPoint.getRcTypeObj() == RcType.OTHER_CONSUMPTION || dataPoint.getRcTypeObj() == RcType.PRODUCTION_UNITS) {
                this.typeLabel.setText(this.lex.getText(dataPoint.getRcTypeObj().toString()));
            } else {
                this.typeLabel.setText(this.lex.getText(dataPoint.getRcTypeObj().toString()) + " " + this.lex.getText(dataPoint.getRcSubTypeObj().toString()));
            }
            this.meterLabel.setText(dataPoint.getMeter() == null ? "" : dataPoint.getMeter().getName());
            this.descrLabel.setText(dataPoint.getDescr());
            this.unitLabel.setText(BUnit.getUnit((String)dataPoint.getVUnit()).toString());
            BTimeZone bTimeZone = dataPoint.getTimeZoneString() == null || dataPoint.getTimeZoneString().trim().length() == 0 ? BTimeZone.getLocal() : BTimeZone.getTimeZone((String)dataPoint.getTimeZoneString());
            this.timeZoneLabel.setText(bTimeZone.getId());
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    protected String getShortDPSource(String string) {
        if (string.length() > 40) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 18));
            stringBuffer.append("...");
            stringBuffer.append(string.substring(string.length() - 40 + 21));
            return stringBuffer.toString();
        }
        return string;
    }
}

