/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.UserObjectComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractListModel;

public class DataPointListModel
extends AbstractListModel
implements EasDataListener {
    ArrayList dps = null;
    Comparator comparator = new UserObjectComparator();

    public void init(EasSession easSession) {
        this.init(easSession, new ArrayList());
    }

    public void init(EasSession easSession, Collection collection) {
        this.dps = new ArrayList();
        String string = easSession.getServerDebugTag();
        try {
            Group[] groupArray = Site.getGroups(easSession);
            for (int i = 0; i < groupArray.length; ++i) {
                DataPoint[] dataPointArray = ((Site)groupArray[i]).getOwnedDataPoints();
                for (int j = 0; j < dataPointArray.length; ++j) {
                    if (collection.contains(dataPointArray[j])) continue;
                    this.dps.add(dataPointArray[j]);
                }
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        easSession.setServerDebugTag(string);
        if (this.dps.size() > 0) {
            this.fireIntervalAdded(this, 0, this.dps.size() - 1);
        }
    }

    public Object getElementAt(int n) {
        return this.getDataPoint(n);
    }

    public void hideDataPoint(DataPoint dataPoint) {
        int n = this.dps.lastIndexOf(dataPoint);
        if (n >= 0) {
            this.hideDataPointAt(this.dps.lastIndexOf(dataPoint));
        }
    }

    public void removeDataPointAt(int n) {
        this.dps.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public void hideDataPointAt(int n) {
        this.removeDataPointAt(n);
    }

    public void showDataPoint(DataPoint dataPoint) {
        this.addDataPoint(dataPoint);
    }

    public int addDataPoint(DataPoint dataPoint) {
        if (!this.dps.contains(dataPoint)) {
            DataPoint dataPoint2;
            int n = 0;
            Iterator iterator = this.dps.iterator();
            while (iterator.hasNext() && this.comparator.compare(dataPoint, dataPoint2 = (DataPoint)iterator.next()) >= 0) {
                ++n;
            }
            this.dps.add(n, dataPoint);
            this.fireIntervalAdded(this, n, n);
            return n;
        }
        return -1;
    }

    public DataPoint[] getDataPoints(int[] nArray) {
        DataPoint[] dataPointArray = new DataPoint[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dataPointArray[i] = this.getDataPoint(i);
        }
        return dataPointArray;
    }

    public DataPoint getDataPoint(int n) {
        return (DataPoint)this.dps.get(n);
    }

    public int getSize() {
        if (this.dps == null) {
            return 0;
        }
        return this.dps.size();
    }

    private void removeDataPoint(DataPoint dataPoint) {
        int n = this.dps.lastIndexOf(dataPoint);
        if (n >= 0) {
            this.removeDataPointAt(n);
        }
    }

    private HashSet createSet(DataPoint[] dataPointArray) {
        HashSet<DataPoint> hashSet = new HashSet<DataPoint>();
        for (int i = 0; i < dataPointArray.length; ++i) {
            hashSet.add(dataPointArray[i]);
        }
        return hashSet;
    }

    private void postGroupUpdate(Site site) {
        try {
            HashSet hashSet = this.createSet(site.getOwnedDataPoints());
            HashSet hashSet2 = (HashSet)hashSet.clone();
            hashSet2.removeAll(this.dps);
            ArrayList arrayList = (ArrayList)this.dps.clone();
            arrayList.removeAll(hashSet);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.removeDataPoint((DataPoint)iterator.next());
            }
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                this.addDataPoint((DataPoint)iterator.next());
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            if (objectArray[i] instanceof Site) {
                this.postGroupUpdate((Site)objectArray[i]);
                continue;
            }
            if (!(objectArray[i] instanceof DataPoint) || (n = this.dps.lastIndexOf(objectArray[i])) < 0) continue;
            this.fireContentsChanged(objectArray[i], n, n);
        }
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof DataPoint) {
                this.addDataPoint((DataPoint)objectArray[i]);
                continue;
            }
            if (!(objectArray[i] instanceof Site)) continue;
            this.postGroupUpdate((Site)objectArray[i]);
        }
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                if (objectArray[i] instanceof DataPoint) {
                    this.removeDataPoint((DataPoint)objectArray[i]);
                    continue;
                }
                if (!(objectArray[i] instanceof Site)) continue;
                DataPoint[] dataPointArray = ((Site)objectArray[i]).getOwnedDataPoints();
                for (int j = 0; j < dataPointArray.length; ++j) {
                    this.removeDataPoint(dataPointArray[j]);
                }
                continue;
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
    }
}

