/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Series;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class TimeOfDayAxis
extends Axis {
    private long MILLIS_IN_MINUTE = 60000L;
    private long MILLIS_IN_HOUR = this.MILLIS_IN_MINUTE * 60L;
    private long MILLIS_IN_DAY = this.MILLIS_IN_HOUR * 24L;
    private long DEFAULT_INCREMENT = this.MILLIS_IN_MINUTE;
    private long MIN_5 = this.MILLIS_IN_MINUTE * 5L;
    private long MIN_15 = this.MILLIS_IN_MINUTE * 15L;
    private long displayMin = 0L;
    private long displayMax = 86400000L;
    private long tickIncrement = this.DEFAULT_INCREMENT;
    private int tickSpacing = -1;
    private String[] labels;
    private int[] labelLens;
    private int maxLabelLen;
    private StringBuffer sbuf;

    public TimeOfDayAxis(int n, AxisInfo axisInfo) {
        super(n, axisInfo);
    }

    public int indexToPixel(Series series, int n) {
        throw new UnsupportedOperationException("this axis type does not use series row index");
    }

    public int valueToPixel(Object object) {
        if (object instanceof Number) {
            return this.valueToPixel(((Number)object).longValue());
        }
        return -1;
    }

    public int valueToPixel(long l) {
        int n = 0;
        int n2 = this.getTickSpacing();
        int n3 = (int)((l - this.displayMin) / this.tickIncrement);
        int n4 = n3 * n2;
        long l2 = this.displayMin + (long)n3 * this.tickIncrement;
        int n5 = (int)((double)n2 * (((double)l - (double)l2) / (double)this.tickIncrement));
        n = n4 + n5;
        if (!this.isHorizontal()) {
            n = this.getFullLength() - n;
        }
        return n;
    }

    public long pixelToValue(int n) {
        if (!this.isHorizontal()) {
            n = this.getHeight() - n;
        }
        int n2 = this.getTickSpacing();
        int n3 = n / n2;
        long l = this.displayMin + (long)n3 * this.tickIncrement;
        int n4 = n - n3 * n2;
        return l + (long)((double)this.tickIncrement * ((double)n4 / (double)n2));
    }

    public String pixelToLabel(int n) {
        long l = this.pixelToValue(n);
        return this.getValueLabel(new Long(l));
    }

    public synchronized String getDefaultTickLabel(Object object) {
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            int n = (int)(l / this.MILLIS_IN_HOUR);
            int n2 = (int)((l - (long)n * this.MILLIS_IN_HOUR) / this.MILLIS_IN_MINUTE);
            if (this.sbuf == null) {
                this.sbuf = new StringBuffer(5);
            }
            this.sbuf.setLength(0);
            this.sbuf.append(Integer.toString(n));
            this.sbuf.append(':');
            if (n2 < 9) {
                this.sbuf.append('0');
            }
            this.sbuf.append(Integer.toString(n2));
            return this.sbuf.toString();
        }
        return null;
    }

    private String[] getLabels() {
        if (this.labels == null) {
            this.buildLabels();
        }
        return this.labels;
    }

    public String[] buildLabels() {
        this.checkFont();
        int n = this.getTickSpacing();
        int n2 = (int)((this.displayMax - this.displayMin) / this.tickIncrement) + 1;
        this.labels = new String[n2];
        this.labelLens = new int[n2];
        long l = this.displayMin + this.tickIncrement;
        this.maxLabelLen = 0;
        StringBuffer stringBuffer = new StringBuffer(5);
        for (int i = 0; i < n2; ++i) {
            int n3;
            this.labels[i] = this.getTickLabel(new Long(l));
            this.labelLens[i] = n3 = this.labelFm.stringWidth(this.labels[i]);
            this.maxLabelLen = Math.max(this.maxLabelLen, n3);
            l += this.tickIncrement;
        }
        return this.labels;
    }

    private double getPixelsPerUnit() {
        double d = (double)this.getAxisLength() / (double)(this.displayMax - this.displayMin);
        if (d == 0.0) {
            return 1.0E-4f;
        }
        return d;
    }

    public int getTickSpacing() {
        if (this.tickSpacing != -1) {
            return this.tickSpacing;
        }
        double d = this.getPixelsPerUnit();
        while ((this.tickSpacing = (int)((double)this.tickIncrement * d)) < 10) {
            if (this.tickIncrement == this.DEFAULT_INCREMENT) {
                this.tickIncrement = this.MIN_5;
                continue;
            }
            if (this.tickIncrement == this.MIN_5) {
                this.tickIncrement = this.MIN_15;
                continue;
            }
            this.tickIncrement *= 2L;
        }
        return this.tickSpacing;
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        this.checkFont();
        if (this.isHorizontal()) {
            n = 50;
            n2 = this.labelFm.getHeight() + 4 + 8;
        } else {
            String string = this.getTickLabel(new Long(this.MILLIS_IN_DAY - 1L));
            n = this.labelFm.stringWidth(string) + 4 + 8;
            n2 = 50;
        }
        return new Dimension(n, n2);
    }

    public void doLayout() {
        super.doLayout();
        if (this.getDrawTickLabels()) {
            this.buildLabels();
        }
    }

    protected void resetLayout() {
        this.tickSpacing = -1;
        this.tickIncrement = this.DEFAULT_INCREMENT;
    }

    protected void paintAxis(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = this.getDrawTicks();
        boolean bl2 = this.getDrawTickLabels();
        boolean bl3 = this.isLeftBottom();
        this.checkFont();
        String[] stringArray = null;
        boolean bl4 = false;
        int n3 = 0;
        if (bl2) {
            stringArray = this.getLabels();
        }
        this.setFont(this.labelFont);
        if (!this.isHorizontal()) {
            n3 = n2;
            int n4 = n2 - this.getTickSpacing();
            long l = this.displayMin + this.tickIncrement;
            int n5 = this.labelFm.getAscent() / 2;
            graphics.setColor(Color.black);
            int n6 = 0;
            while (l <= this.displayMax) {
                if (bl2 && n6 < stringArray.length) {
                    int n7 = n4 + n5 - 1;
                    boolean bl5 = bl4 = n7 + 2 < n3 - 2 && n4 - n5 > 0;
                    if (bl4) {
                        int n8 = bl3 ? n - 4 - 4 - this.labelLens[n6] : 8;
                        n3 = n7;
                        graphics.drawString(stringArray[n6], n8, n3);
                    }
                }
                if (bl) {
                    if (bl4) {
                        if (bl3) {
                            graphics.drawLine(n - 4, n4, n, n4);
                        } else {
                            graphics.drawLine(0, n4, 6, n4);
                        }
                    } else if (bl3) {
                        graphics.drawLine(n - 4 + 2, n4, n, n4);
                    } else {
                        graphics.drawLine(0, n4, 4, n4);
                    }
                }
                n4 -= this.tickSpacing;
                l += this.tickIncrement;
                ++n6;
            }
        } else {
            n3 = 0;
            int n9 = this.getTickSpacing();
            int n10 = 0;
            int n11 = this.maxLabelLen / 2;
            int n12 = bl3 ? 8 + this.labelFm.getAscent() : n2 - 4 - 4;
            graphics.setColor(Color.black);
            int n13 = 0;
            while (n9 < n) {
                if (bl2) {
                    int n14 = this.labelLens[n13] / 2;
                    n10 = n9 - n14;
                    boolean bl6 = bl4 = n9 - n11 - 2 > n3 + 2 && n10 + this.labelLens[n13] < n;
                    if (bl4) {
                        graphics.drawString(stringArray[n13], n10, n12);
                        n3 = n9 + n11;
                    }
                }
                if (bl) {
                    if (bl4) {
                        if (bl3) {
                            graphics.drawLine(n9, 0, n9, 4);
                        } else {
                            graphics.drawLine(n9, n2 - 4, n9, n2);
                        }
                    } else if (bl3) {
                        graphics.drawLine(n9, 0, n9, 2);
                    } else {
                        graphics.drawLine(n9, n2 - 4 + 2, n9, n2);
                    }
                }
                n9 += this.tickSpacing;
                ++n13;
            }
        }
    }

    protected Axis.ZoomRec doZoomIn(int n, int n2) {
        long l;
        long l2;
        if (this.isHorizontal()) {
            l2 = this.pixelToValue(n);
            l = this.pixelToValue(n2);
        } else {
            l = this.pixelToValue(n);
            l2 = this.pixelToValue(n2);
        }
        if (l2 >= l) {
            return null;
        }
        l2 = Math.max(0L, l2 / this.tickIncrement * this.tickIncrement);
        l = Math.min(this.MILLIS_IN_DAY, l / this.tickIncrement * this.tickIncrement + this.tickIncrement);
        TimeOfDayZoomRec timeOfDayZoomRec = new TimeOfDayZoomRec(this.displayMin, this.displayMax);
        this.displayMin = l2;
        this.displayMax = l;
        return timeOfDayZoomRec;
    }

    protected void zoomOut(Axis.ZoomRec zoomRec) {
        TimeOfDayZoomRec timeOfDayZoomRec = (TimeOfDayZoomRec)zoomRec;
        this.displayMin = timeOfDayZoomRec.min;
        this.displayMax = timeOfDayZoomRec.max;
        this.resetLayout();
        this.revalidate();
        this.repaint();
    }

    private String todToString(long l) {
        long l2 = l / this.MILLIS_IN_HOUR;
        long l3 = (l - l2 * this.MILLIS_IN_HOUR) / this.MILLIS_IN_MINUTE;
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(l2);
        stringBuffer.append(':');
        if (l3 < 10L) {
            stringBuffer.append('0');
        }
        stringBuffer.append(l3);
        return stringBuffer.toString();
    }

    private class TimeOfDayZoomRec
    implements Axis.ZoomRec {
        public long min;
        public long max;

        public TimeOfDayZoomRec(long l, long l2) {
            this.min = l;
            this.max = l2;
        }
    }
}

