/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartCanvas;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.SpectrumConfig;
import com.tridium.eas.ui.chart.TimeAxis;
import com.tridium.eas.ui.chart.TimeOfDayAxis;
import com.tridium.eas.ui.chart.TimeSeries;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;

public class SpectrumCanvas
extends ChartCanvas {
    private TimeSeries modelSeries;
    private DayRec[] model;

    public SpectrumCanvas(Chart chart, Id id) {
        super(chart, id);
        if (!(this.getSeries() instanceof TimeSeries)) {
            throw new IllegalArgumentException("Spectrum requires a time series.");
        }
    }

    private void rebuildModel() {
        int n;
        long l;
        this.modelSeries = (TimeSeries)this.getSeries();
        long l2 = this.modelSeries.getMinTimestamp();
        int n2 = this.getDays(l2, l = this.modelSeries.getMaxTimestamp());
        if (n2 == 0) {
            return;
        }
        this.model = new DayRec[n2];
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        calendar.setTime(new Date(l2));
        long l3 = this.getDayStart(calendar);
        long l4 = this.getDayEnd(calendar);
        int n3 = this.modelSeries.getRowCount();
        int n4 = 0;
        ArrayList<DayValue> arrayList = new ArrayList<DayValue>(96);
        for (n = 0; n < n3; ++n) {
            double d = this.modelSeries.getValue(n, 0);
            long l5 = this.modelSeries.getTimestamp(n);
            if (l5 < l3) continue;
            if (l5 >= l4) {
                int n5 = arrayList.size();
                DayValue[] dayValueArray = new DayValue[n5];
                this.model[n4++] = new DayRec(l4, arrayList.toArray(dayValueArray));
                arrayList.clear();
                calendar.setTime(new Date(l4 + 1L));
                l3 = this.getDayStart(calendar);
                l4 = this.getDayEnd(calendar);
            }
            arrayList.add(new DayValue(l5 - l3, n));
        }
        n = arrayList.size();
        DayValue[] dayValueArray = new DayValue[n];
        this.model[n4++] = new DayRec(l4, arrayList.toArray(dayValueArray));
    }

    private long getDayStart(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    private long getDayEnd(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        return calendar.getTime().getTime();
    }

    private int getDays(long l, long l2) {
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        calendar.setTime(new Date(l));
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        calendar.setTime(new Date(l2));
        int n4 = calendar.get(1);
        int n5 = calendar.get(2);
        int n6 = calendar.get(5);
        int n7 = 0;
        while (n != n4 || n2 != n5 || n3 != n6) {
            int n8;
            if (n != n4) {
                if (n2 == 0 && n3 == 1) {
                    n7 += ReportPeriod.getDaysInYear(n);
                } else {
                    for (n8 = n2; n8 <= 11; ++n8) {
                        if (n8 == n2) {
                            n7 += ReportPeriod.getDaysInMonth(n8, n) - n3 + 1;
                            continue;
                        }
                        n7 += ReportPeriod.getDaysInMonth(n8, n);
                    }
                }
                ++n;
                n2 = 0;
                n3 = 1;
                continue;
            }
            if (n2 != n5) {
                for (n8 = n2; n8 <= n5; ++n8) {
                    int n9 = 1;
                    int n10 = ReportPeriod.getDaysInMonth(n8, n);
                    if (n8 == n2) {
                        n9 = n3;
                    }
                    if (n8 == n5) {
                        n10 = n6;
                    }
                    n7 += n10 - n9 + 1;
                }
                n2 = n5;
                n3 = n6;
                continue;
            }
            n7 += n6 - n3 + 1;
            n3 = n6;
        }
        if (n7 == 0) {
            return 1;
        }
        return n7;
    }

    public void doLayout() {
        TimeSeries timeSeries = (TimeSeries)this.getSeries();
        if (timeSeries != this.modelSeries) {
            this.rebuildModel();
        }
    }

    public void paint(Graphics graphics) {
        if (this.model == null) {
            this.rebuildModel();
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        TimeOfDayAxis timeOfDayAxis = (TimeOfDayAxis)this.getYAxis();
        TimeAxis timeAxis = (TimeAxis)this.getXAxis();
        int n3 = this.model.length;
        int n4 = 0;
        int n5 = this.getHeight();
        SpectrumConfig spectrumConfig = (SpectrumConfig)this.getConfig();
        Color color = spectrumConfig.getHighColor();
        Color color2 = spectrumConfig.getMiddleColor();
        Color color3 = spectrumConfig.getLowColor();
        float f = spectrumConfig.getHighValue();
        float f2 = spectrumConfig.getLowValue();
        for (int i = 0; i < n3; ++i) {
            DayRec dayRec = this.model[i];
            int n6 = dayRec.rows.length;
            int n7 = timeAxis.valueToPixel(dayRec.timestamp);
            for (int j = 0; j < n6; ++j) {
                long l = dayRec.rows[j].timeOfDay;
                float f3 = (float)this.modelSeries.getValue(dayRec.rows[j].seriesIndex, 0);
                int n8 = timeOfDayAxis.valueToPixel(l);
                if (this.modelSeries.isValid(dayRec.rows[j].seriesIndex, 0)) {
                    Color color4 = SpectrumCanvas.floatToColor(f3, color3, color2, color, f2, f);
                    graphics.setColor(color4);
                    graphics.fillRect(n4, n8, n7 - n4, n5 - n8);
                }
                n5 = n8;
            }
            n4 = n7;
        }
    }

    public static Color floatToColor(float f, Color color, Color color2, Color color3, float f2, float f3) {
        int n;
        int n2;
        int n3;
        float f4 = Math.abs(f3 - f2) / 2.0f;
        float f5 = f2 + f4;
        if (f < f5) {
            if (f < f2) {
                return color;
            }
            float f6 = (float)(color2.getRed() - color.getRed()) / f4;
            float f7 = (float)color2.getRed() - f6 * f5;
            n3 = (int)(f6 * f + f7);
            float f8 = (float)(color2.getGreen() - color.getGreen()) / f4;
            float f9 = (float)color2.getGreen() - f8 * f5;
            n2 = (int)(f8 * f + f9);
            float f10 = (float)(color2.getBlue() - color.getBlue()) / f4;
            float f11 = (float)color2.getBlue() - f10 * f5;
            n = (int)(f10 * f + f11);
        } else {
            if (f > f3) {
                return color3;
            }
            float f12 = (float)(color3.getRed() - color2.getRed()) / f4;
            float f13 = (float)color2.getRed() - f12 * f5;
            n3 = (int)(f12 * f + f13);
            float f14 = (float)(color3.getGreen() - color2.getGreen()) / f4;
            float f15 = (float)color2.getGreen() - f14 * f5;
            n2 = (int)(f14 * f + f15);
            float f16 = (float)(color3.getBlue() - color2.getBlue()) / f4;
            float f17 = (float)color2.getBlue() - f16 * f5;
            n = (int)(f16 * f + f17);
        }
        return new Color(n3, n2, n);
    }

    private class DayValue {
        long timeOfDay;
        int seriesIndex;

        public DayValue(long l, int n) {
            this.timeOfDay = l;
            this.seriesIndex = n;
        }
    }

    private class DayRec {
        public long timestamp;
        public DayValue[] rows;

        public DayRec(long l, DayValue[] dayValueArray) {
            this.timestamp = l;
            this.rows = dayValueArray;
        }
    }
}

