/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Series;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class SeriesAxis
extends Axis {
    private Series series;
    private int tickIncrement = 1;
    private int tickSpacing = -1;
    private int firstTickSpacing = -1;
    private String[] labels;
    private int[] labelLens;
    private int maxLabelLen;

    public SeriesAxis(int n, Series series, AxisInfo axisInfo) {
        super(n, axisInfo);
        this.series = series;
        this.setDrawTicks(false);
    }

    public Series getSeries() {
        return this.series;
    }

    public String getDefaultTickLabel(Object object) {
        if (object instanceof Number) {
            return this.series.getRowName(((Number)object).intValue());
        }
        return null;
    }

    public String pixelToLabel(int n) {
        int n2 = this.pixelToValue(n);
        return this.getValueLabel(new Integer(n2));
    }

    public String getAxisTitle() {
        AxisInfo axisInfo = this.getAxisInfo();
        if (axisInfo == null) {
            return this.series.getSeriesName();
        }
        return axisInfo.getTitle();
    }

    private String[] getLabels() {
        if (this.labels == null) {
            this.checkFont();
            int n = this.series.getRowCount();
            if (n == 0) {
                return null;
            }
            int n2 = n;
            this.labels = new String[n2];
            this.labelLens = new int[n2];
            this.maxLabelLen = 0;
            for (int i = 0; i < n2; ++i) {
                this.labels[i] = this.getTickLabel(new Integer(i));
                this.labelLens[i] = this.labelFm.stringWidth(this.labels[i]);
                this.maxLabelLen = Math.max(this.labelLens[i], this.maxLabelLen);
            }
        }
        return this.labels;
    }

    public void doLayout() {
        super.doLayout();
        this.checkFont();
        int n = this.series.getRowCount();
        if (n == 0) {
            return;
        }
        int n2 = n;
        this.tickSpacing = this.getWidth() / n2;
        this.firstTickSpacing = this.tickSpacing / 2;
        this.labels = this.getLabels();
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        this.getLabels();
        if (this.isHorizontal()) {
            n = 50;
            n2 = this.labelFm.getHeight() + 4 + 8;
            String string = this.getAxisTitle();
            if (string != null) {
                n2 += this.titleFm.getHeight();
            }
        } else {
            n = this.maxLabelLen + 4 + 8;
            String string = this.getAxisTitle();
            if (string != null) {
                n += this.titleFm.getHeight();
            }
            n2 = 50;
        }
        return new Dimension(n, n2);
    }

    public void paintAxis(Graphics graphics) {
        String string;
        int n;
        int n2;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        boolean bl = this.getDrawTicks();
        boolean bl2 = this.getDrawTickLabels();
        this.checkFont();
        int n5 = this.series.getRowCount();
        if (n5 == 0) {
            return;
        }
        int n6 = n5;
        boolean bl3 = false;
        int n7 = 0;
        this.setFont(this.labelFont);
        if (!this.isHorizontal()) {
            n2 = n4 - this.firstTickSpacing;
            n = this.labelFm.getAscent() / 2;
            graphics.setColor(Color.black);
            int n8 = 0;
            n7 = n4;
            for (int i = 0; i < n6; ++i) {
                if (bl2) {
                    int n9 = n2 + n - 1;
                    boolean bl4 = bl3 = n9 + 2 < n7 - 2 && n2 - n > 0;
                    if (n8 < this.labels.length && bl3) {
                        graphics.drawString(this.labels[i], n3 - 4 - 4 - this.labelLens[i], n9);
                        n7 = n9 + this.labelFm.getAscent();
                    }
                }
                if (bl) {
                    if (bl3) {
                        graphics.drawLine(n3 - 4, n2, n3, n2);
                    } else {
                        graphics.drawLine(n3 - 4 - 2, n2, n3, n2);
                    }
                }
                n2 -= this.tickSpacing;
            }
        } else {
            int n10;
            int n11;
            int n12;
            n2 = this.firstTickSpacing;
            n = 8 + this.labelFm.getAscent();
            int n13 = 0;
            int n14 = this.maxLabelLen / 2;
            n7 = 0;
            bl3 = true;
            graphics.setColor(Color.black);
            boolean bl5 = true;
            if (bl2) {
                for (n12 = 0; n12 < n6; ++n12) {
                    n11 = this.labelLens[n12] / 2;
                    n13 = n2 - n11;
                    int n15 = n10 = n2 - n11 - 2 > n7 + 2 && n13 + this.labelLens[n12] < n3 ? 1 : 0;
                    if (n10 == 0) {
                        bl5 = false;
                        break;
                    }
                    n7 = n2 + n14;
                    n2 += this.tickSpacing;
                }
                n2 = this.firstTickSpacing;
                n13 = 0;
                n7 = 0;
            }
            n12 = 0;
            for (n10 = 0; n10 < n6; ++n10) {
                bl3 = false;
                if (bl2 && bl5) {
                    n11 = this.labelLens[n10] / 2;
                    n13 = n2 - n11;
                    boolean bl6 = bl3 = n2 - n11 - 2 > n7 + 2 && n13 + this.labelLens[n10] < n3;
                    if (bl3) {
                        graphics.drawString(this.labels[n10], n13, n);
                        n7 = n2 + n14;
                    }
                }
                if (bl) {
                    if (bl3) {
                        graphics.drawLine(n2, 0, n2, 4);
                    } else {
                        graphics.drawLine(n2, 0, n2, 2);
                    }
                }
                n2 += this.tickSpacing;
            }
        }
        if ((string = this.getAxisTitle()) != null) {
            n = 12 + this.labelFm.getAscent() + this.titleFm.getHeight();
            graphics.setFont(this.titleFont);
            graphics.drawString(string, (n3 - this.titleFm.stringWidth(string)) / 2, n);
        }
    }

    public int getTickSpacing() {
        return this.tickSpacing;
    }

    public int getFirstTickSpacing() {
        return this.firstTickSpacing;
    }

    public int indexToPixel(Series series, int n) {
        return this.valueToPixel(n);
    }

    public int valueToPixel(Object object) {
        if (object instanceof Number) {
            return this.valueToPixel(((Number)object).intValue());
        }
        return -1;
    }

    public int valueToPixel(int n) {
        return this.firstTickSpacing + this.tickSpacing * n;
    }

    public int pixelToValue(int n) {
        return (n - this.firstTickSpacing) / this.tickSpacing;
    }

    protected Axis.ZoomRec doZoomIn(int n, int n2) {
        return null;
    }

    protected void zoomOut(Axis.ZoomRec zoomRec) {
    }
}

