/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartCanvas;
import com.tridium.eas.ui.chart.FloatAxis;
import com.tridium.eas.ui.chart.FloatSeries;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.IntAxis;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeAxis;
import com.tridium.eas.ui.chart.TimeSeries;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class ScatterPlotCanvas
extends ChartCanvas {
    private static final int OFFSET = 1;
    private static final int DIAMETER = 3;
    private Stroke stroke;

    public ScatterPlotCanvas(Chart chart, Id id) {
        super(chart, id);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        if (this.stroke == null) {
            this.stroke = new BasicStroke(1.0f, 1, 1);
        }
        graphics2D.setStroke(this.stroke);
        Series series = this.getSeries();
        if (series instanceof TimeSeries) {
            this.paintSeries(graphics, (TimeAxis)this.getXAxis(), (FloatAxis)this.getYAxis(), (TimeSeries)series);
        } else if (series instanceof FloatSeries) {
            this.paintSeries(graphics, (FloatAxis)this.getXAxis(), (FloatAxis)this.getYAxis(), (FloatSeries)series);
        } else {
            this.paintSeries(graphics, (IntAxis)this.getXAxis(), (FloatAxis)this.getYAxis(), series);
        }
        graphics2D.setStroke(stroke);
    }

    private void paintSeries(Graphics graphics, Axis axis, FloatAxis floatAxis, Series series) {
        int n = series.getRowCount();
        int n2 = series.getValueCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            graphics.setColor(this.getConfig().getValueColor(i));
            for (int j = 0; j < n; ++j) {
                if (!series.isValid(j, i)) continue;
                int n3 = axis.indexToPixel(series, j);
                int n4 = floatAxis.valueToPixel(series.getValue(j, i));
                graphics.fillOval(n3 - 1, n4 - 1, 3, 3);
            }
        }
    }
}

