/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Overlay;
import com.tridium.eas.ui.chart.ValueToPixel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class RangeOverlay
extends Overlay {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation;
    private Number location1;
    private Number location2;
    private Stroke stroke;
    private Color color = Color.black;

    public RangeOverlay(int n, double d, double d2) {
        this(n, new Double(d), new Double(d2));
    }

    public RangeOverlay(int n, float f, float f2) {
        this(n, new Float(f), new Float(f2));
    }

    public RangeOverlay(int n, int n2, int n3) {
        this(n, new Integer(n2), new Integer(n3));
    }

    public RangeOverlay(int n, long l, long l2) {
        this(n, new Long(l), new Long(l2));
    }

    public RangeOverlay(int n, Number number, Number number2) {
        this.orientation = n;
        this.location1 = number;
        this.location2 = number2;
    }

    public Number getLocation1() {
        return this.location1;
    }

    public Number getLocation2() {
        return this.location2;
    }

    public void setLocation1(Number number) {
        this.location1 = number;
        this.fireModified();
    }

    public void setLocation2(Number number) {
        this.location2 = number;
        this.fireModified();
    }

    public void setLocation1(double d) {
        this.setLocation1(new Double(d));
    }

    public void setLocation2(double d) {
        this.setLocation2(new Double(d));
    }

    public void setLocation1(float f) {
        this.setLocation1(new Float(f));
    }

    public void setLocation2(float f) {
        this.setLocation2(new Float(f));
    }

    public void setLocation1(int n) {
        this.setLocation1(new Integer(n));
    }

    public void setLocation2(int n) {
        this.setLocation2(new Integer(n));
    }

    public void setLocation1(long l) {
        this.setLocation1(new Long(l));
    }

    public void setLocation2(long l) {
        this.setLocation2(new Long(l));
    }

    public Color getXORColor() {
        return this.color;
    }

    public void setXORColor(Color color) {
        this.color = color;
        this.fireModified();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.fireModified();
    }

    public void paint(Graphics graphics, int n, int n2, ValueToPixel valueToPixel) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.white);
        graphics2D.setXORMode(this.color);
        Stroke stroke = graphics2D.getStroke();
        if (this.stroke != null) {
            graphics2D.setStroke(this.stroke);
        }
        if (this.orientation == 0) {
            int n3;
            if (!valueToPixel.hasY()) {
                throw new IllegalStateException("Horizontal range requires a y axis.");
            }
            int n4 = valueToPixel.getYPixel(this.location1);
            if (n4 < (n3 = valueToPixel.getYPixel(this.location2))) {
                graphics2D.fillRect(0, n4, n, n3 - n4);
            } else {
                graphics2D.fillRect(0, n3, n, n4 - n3);
            }
        } else {
            int n5;
            if (!valueToPixel.hasX()) {
                throw new IllegalStateException("Vertical range requires a x axis.");
            }
            int n6 = valueToPixel.getXPixel(this.location1);
            if (n6 < (n5 = valueToPixel.getXPixel(this.location2))) {
                graphics2D.fillRect(n6, 0, n5 - n6, n2);
            } else {
                graphics2D.fillRect(n5, 0, n6 - n5, n2);
            }
        }
        graphics2D.setPaintMode();
        graphics2D.setStroke(stroke);
    }
}

