/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartCanvas;
import com.tridium.eas.ui.chart.ChartConst;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.Overlay;
import com.tridium.eas.ui.chart.ValueToPixel;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;

public class OverlayPane {
    private Chart chart;
    private ArrayList overlays;
    private int x;
    private int y;
    private int width;
    private int height;
    private ValueTranslator trans = new ValueTranslator();

    public OverlayPane(Chart chart) {
        this.chart = chart;
    }

    public Graphics createGraphics(Graphics graphics) {
        return graphics.create(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public synchronized void addOverlay(Id id) {
        if (this.overlays == null) {
            this.overlays = new ArrayList(3);
        }
        OverlayDisplayInfo overlayDisplayInfo = null;
        ChartModel chartModel = this.chart.getModel();
        Id id2 = chartModel.getOverlaySeriesId(id);
        if (id2 != null) {
            ChartCanvas chartCanvas = this.chart.getChartArea().getCanvas(id2);
            if (chartCanvas == null) {
                throw new IllegalStateException("Series for overlay no longer exists.");
            }
            overlayDisplayInfo = new OverlayDisplayInfo(id, chartCanvas.getXAxis(), chartCanvas.getYAxis());
        } else {
            Axis axis = this.getAxis(0, chartModel.getOverlayXAxisType(id), chartModel.getOverlayXAxisInfo(id));
            Axis axis2 = this.getAxis(1, chartModel.getOverlayYAxisType(id), chartModel.getOverlayYAxisInfo(id));
            overlayDisplayInfo = new OverlayDisplayInfo(id, axis, axis2);
        }
        this.overlays.add(overlayDisplayInfo);
    }

    public synchronized void removeOverlay(Id id) {
        if (this.overlays == null) {
            return;
        }
        Iterator iterator = this.overlays.iterator();
        while (iterator.hasNext()) {
            OverlayDisplayInfo overlayDisplayInfo = (OverlayDisplayInfo)iterator.next();
            if (overlayDisplayInfo.overlayId != id) continue;
            iterator.remove();
            overlayDisplayInfo.destroy();
            break;
        }
    }

    public synchronized void removeAllOverlays() {
        if (this.overlays == null) {
            return;
        }
        Iterator iterator = this.overlays.iterator();
        while (iterator.hasNext()) {
            OverlayDisplayInfo overlayDisplayInfo = (OverlayDisplayInfo)iterator.next();
            iterator.remove();
            overlayDisplayInfo.destroy();
        }
        this.overlays = null;
    }

    private Axis getAxis(int n, int n2, AxisInfo axisInfo) {
        if (n2 == 0 || axisInfo == null) {
            return null;
        }
        Number number = axisInfo.getMin();
        if (number == null) {
            throw new IllegalArgumentException("Standalone overlay must provide range in AxisInfo.");
        }
        Number number2 = axisInfo.getMax();
        if (number2 == null && n2 != 3) {
            throw new IllegalArgumentException("Standalone overlay must provide range in AxisInfo.");
        }
        switch (n2) {
            case 1: {
                return this.chart.getFloatAxis(n, number.doubleValue(), number2.doubleValue(), axisInfo.getUnit(), axisInfo);
            }
            case 2: {
                return this.chart.getIntAxis(n, number.intValue(), number2.intValue(), axisInfo);
            }
            case 3: {
                return this.chart.getMultistateAxis(n, number2.intValue(), axisInfo);
            }
            case 5: {
                return this.chart.getTimeAxis(n, number.longValue(), number2.longValue(), axisInfo);
            }
            case 6: {
                return this.chart.getTimeOfDayAxis(n, axisInfo);
            }
        }
        throw new IllegalArgumentException("Unsupported axis type for overlay: " + ChartConst.axisTypeToString(n2));
    }

    public void doLayout() {
    }

    public void paint(Graphics graphics) {
        if (this.overlays == null) {
            return;
        }
        ChartModel chartModel = this.chart.getModel();
        Iterator iterator = this.overlays.iterator();
        while (iterator.hasNext()) {
            OverlayDisplayInfo overlayDisplayInfo = (OverlayDisplayInfo)iterator.next();
            Overlay overlay = chartModel.getOverlay(overlayDisplayInfo.overlayId);
            this.trans.set(overlayDisplayInfo.xAxis, overlayDisplayInfo.yAxis);
            overlay.paint(graphics, this.width, this.height, this.trans);
        }
    }

    private class ValueTranslator
    implements ValueToPixel {
        public Axis xAxis;
        public Axis yAxis;

        private ValueTranslator() {
        }

        public void set(Axis axis, Axis axis2) {
            this.xAxis = axis;
            this.yAxis = axis2;
        }

        public boolean hasX() {
            return this.xAxis != null;
        }

        public int getXPixel(Object object) {
            return this.xAxis.valueToPixel(object) - OverlayPane.this.x;
        }

        public boolean hasY() {
            return this.yAxis != null;
        }

        public int getYPixel(Object object) {
            return this.yAxis.valueToPixel(object) - OverlayPane.this.y;
        }
    }

    private class OverlayDisplayInfo {
        public Id overlayId;
        public Axis xAxis;
        public Axis yAxis;

        public OverlayDisplayInfo(Id id, Axis axis, Axis axis2) {
            this.overlayId = id;
            this.xAxis = axis;
            this.yAxis = axis2;
            if (axis != null) {
                axis.addUser(id);
            }
            if (axis2 != null) {
                axis2.addUser(id);
            }
        }

        public void destroy() {
            if (this.xAxis != null) {
                this.xAxis.removeUser(this.overlayId);
                if (!this.xAxis.isUsed()) {
                    OverlayPane.this.chart.removeXAxis(this.xAxis);
                }
            }
            if (this.yAxis != null) {
                this.yAxis.removeUser(this.overlayId);
                if (!this.yAxis.isUsed()) {
                    OverlayPane.this.chart.removeYAxis(this.yAxis);
                }
            }
        }
    }
}

