/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.FloatAxis;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.baja.util.Lexicon;

public class MultistateAxis
extends FloatAxis {
    private int min = 0;
    private int max = 1;

    public MultistateAxis(int n, AxisInfo axisInfo, Lexicon lexicon) {
        super(n, axisInfo, lexicon);
    }

    public void updateMax(int n) {
        this.min = 0;
        this.max = Math.max(this.max, n);
    }

    public void doLayout() {
        super.doLayout();
        this.tickSpacing = this.getTickSpacing();
    }

    public int getTickSpacing() {
        int n = this.getAxisLength();
        return n / this.max;
    }

    public int valueToPixel(Object object) {
        if (object instanceof Number) {
            return this.valueToPixel(((Number)object).intValue());
        }
        return -1;
    }

    public int valueToPixel(int n) {
        int n2 = n * this.tickSpacing;
        if (!this.isHorizontal()) {
            n2 = this.getFullLength() - n2;
        }
        return n2;
    }

    public int valueToPixel(double d) {
        return this.valueToPixel((int)d);
    }

    public double pixelToValue(int n) {
        int n2 = this.getAxisLength();
        if (!this.isHorizontal()) {
            n = n2 - n;
        }
        return n / this.tickSpacing;
    }

    protected void buildLabels() {
        this.checkFont();
        this.labels = new String[this.max];
        this.labelLens = new int[this.max];
        this.maxLabelLen = 0;
        for (int i = 0; i < this.max; ++i) {
            this.labels[i] = this.getTickLabel(new Integer(i + 1));
            this.labelLens[i] = this.labelFm.stringWidth(this.labels[i]);
            this.maxLabelLen = Math.max(this.labelLens[i], this.maxLabelLen);
        }
    }

    public String getDefaultTickLabel(Object object) {
        if (object instanceof Number) {
            if (this.lex != null) {
                return this.lex.getText("state") + " " + ((Number)object).intValue();
            }
            return "state " + ((Number)object).intValue();
        }
        return null;
    }

    public String pixelToLabel(int n) {
        return null;
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        this.checkFont();
        if (this.isHorizontal()) {
            n = 50;
            n2 = this.labelFm.getHeight() + 4 + 8;
            String string = this.getAxisTitle();
            if (string != null) {
                n2 += this.titleFm.getHeight();
            }
        } else {
            this.getLabels();
            n = this.maxLabelLen + 4 + 8;
            String string = this.getAxisTitle();
            if (string != null) {
                n2 += this.titleFm.getHeight();
            }
            n2 = 50;
        }
        return new Dimension(n, n2);
    }

    protected void resetLayout() {
    }

    protected void paintAxis(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = this.getDrawTicks();
        boolean bl2 = this.getDrawTickLabels();
        boolean bl3 = this.isLeftBottom();
        this.checkFont();
        String[] stringArray = null;
        boolean bl4 = false;
        int n3 = 0;
        if (bl2) {
            stringArray = this.getLabels();
        }
        this.setFont(this.labelFont);
        if (!this.isHorizontal()) {
            int n4;
            n3 = n2;
            int n5 = n2 - this.tickSpacing;
            int n6 = this.labelFm.getAscent() / 2;
            graphics.setColor(Color.black);
            int n7 = 0;
            for (int i = 0; i < this.max; ++i) {
                if (bl2 && n7 < stringArray.length) {
                    n4 = n5 + n6 - 1;
                    boolean bl5 = bl4 = n4 + 2 < n3 - 2 && n5 - n6 > 0;
                    if (bl4) {
                        int n8 = bl3 ? n - 4 - 4 - this.labelLens[n7] : 8;
                        n3 = n4;
                        graphics.drawString(stringArray[n7], n8, n3);
                    }
                }
                if (bl) {
                    if (bl4) {
                        if (bl3) {
                            graphics.drawLine(n - 4, n5, n, n5);
                        } else {
                            graphics.drawLine(0, n5, 6, n5);
                        }
                    } else if (bl3) {
                        graphics.drawLine(n - 4 + 2, n5, n, n5);
                    } else {
                        graphics.drawLine(0, n5, 4, n5);
                    }
                }
                n5 -= this.tickSpacing;
                ++n7;
            }
            String string = this.getAxisTitle();
            if (string != null) {
                n4 = n - this.maxLabelLen - 2 - 4 - 8;
                int n9 = this.titleFm.stringWidth(string);
                int n10 = (n2 - n9) / 2 + n9;
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                double d = -1.5707963267948966;
                graphics2D.setTransform(AffineTransform.getRotateInstance(d, n4, n10));
                graphics2D.drawString(string, n4, n10);
                graphics2D.setTransform(affineTransform);
            }
        } else {
            n3 = 0;
            int n11 = this.tickSpacing;
            int n12 = 0;
            int n13 = this.maxLabelLen / 2;
            int n14 = bl3 ? 8 + this.labelFm.getAscent() : n2 - 4 - 4;
            graphics.setColor(Color.black);
            int n15 = 0;
            for (int i = 0; i < this.max; ++i) {
                if (bl2) {
                    int n16 = this.labelLens[n15] / 2;
                    n12 = n11 - n16;
                    boolean bl6 = bl4 = n11 - n13 - 2 > n3 + 2 && n12 + this.labelLens[n15] < n;
                    if (bl4) {
                        graphics.drawString(stringArray[n15], n12, n14);
                        n3 = n11 + n13;
                    }
                }
                if (bl) {
                    if (bl4) {
                        if (bl3) {
                            graphics.drawLine(n11, 0, n11, 4);
                        } else {
                            graphics.drawLine(n11, n2 - 4, n11, n2);
                        }
                    } else if (bl3) {
                        graphics.drawLine(n11, 0, n11, 2);
                    } else {
                        graphics.drawLine(n11, n2 - 4 + 2, n11, n2);
                    }
                }
                n11 += this.tickSpacing;
                ++n15;
            }
            String string = this.getAxisTitle();
            if (string != null) {
                int n17 = bl3 ? n14 + this.labelFm.getHeight() : n14 - this.labelFm.getHeight();
                int n18 = (this.getWidth() - this.labelFm.stringWidth(string)) / 2;
                graphics.drawString(string, n18, n17);
            }
        }
    }

    protected Axis.ZoomRec doZoomIn(int n, int n2) {
        return null;
    }

    protected void zoomOut(Axis.ZoomRec zoomRec) {
    }
}

