/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ChartTitle
extends JComponent {
    private static final int MARGIN = 4;
    public String[] title;
    public String[] subtitle;
    private FontMetrics fm;
    private Font subFont;
    private FontMetrics subFm;
    private Rectangle textBounds;
    private boolean showBorder = false;

    public ChartTitle() {
        this.init();
    }

    public ChartTitle(String string, String string2) {
        this.init();
        this.setTitle(string);
        this.setSubtitle(string2);
    }

    private void init() {
        this.setBackground(UIManager.getColor("Table.background"));
        Font font = UIManager.getFont("Table.font");
        font = new Font(Theme.widget().getTextFont().getName(), 1, 16);
        this.setFont(font);
        font = new Font(font.getFamily(), 0, 12);
    }

    public void setTitle(String string) {
        this.title = this.parse(string);
    }

    public void setSubtitle(String string) {
        this.subtitle = this.parse(string);
    }

    public void setTitle(String string, String string2) {
        this.setTitle(string);
        this.setSubtitle(string2);
    }

    private String[] parse(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void setFont(Font font) {
        this.fm = null;
        super.setFont(font);
    }

    public Font getSubtitleFont() {
        if (this.subFont == null) {
            Font font = this.getFont();
            this.subFont = new Font(font.getFamily(), 0, font.getSize() - 4);
        }
        return this.subFont;
    }

    public void setSubtitleFont(Font font) {
        this.fm = null;
        this.subFont = font;
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
    }

    private void checkFont() {
        if (this.fm == null) {
            Font font = this.getFont();
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            font = this.getSubtitleFont();
            if (this.subFont == null) {
                this.subFont = new Font(font.getFamily(), 0, font.getSize() - 6);
            }
            this.subFm = Toolkit.getDefaultToolkit().getFontMetrics(this.subFont);
        }
    }

    public Dimension getPreferredSize() {
        int n;
        this.checkFont();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.title == null ? 0 : this.title.length;
        for (n = 0; n < n4; ++n) {
            n2 = Math.max(n2, this.fm.stringWidth(this.title[n]));
            n3 += this.fm.getHeight();
        }
        n4 = this.subtitle == null ? 0 : this.subtitle.length;
        for (n = 0; n < n4; ++n) {
            n2 = Math.max(n2, this.subFm.stringWidth(this.subtitle[n]));
            n3 += this.subFm.getHeight();
        }
        if (n3 == 0) {
            return new Dimension(0, 0);
        }
        return new Dimension(n2 + 12, n3 + 8);
    }

    public void doLayout() {
        int n;
        this.checkFont();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = 0;
        int n5 = 0;
        int n6 = this.title == null ? 0 : this.title.length;
        for (n = 0; n < n6; ++n) {
            n4 = Math.max(n4, this.fm.stringWidth(this.title[n]));
            n5 += this.fm.getHeight();
        }
        n6 = this.subtitle == null ? 0 : this.subtitle.length;
        for (n = 0; n < n6; ++n) {
            n4 = Math.max(n4, this.subFm.stringWidth(this.subtitle[n]));
            n5 += this.subFm.getHeight();
        }
        if (this.textBounds == null) {
            this.textBounds = new Rectangle();
        }
        this.textBounds.x = (n2 - (n4 += 8)) / 2;
        this.textBounds.y = (n3 - (n5 += 8)) / 2;
        this.textBounds.width = n4 - 1;
        this.textBounds.height = n5 - 1;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.title == null && this.subtitle == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        graphics2D.setColor(Color.white);
        graphics2D.fill(this.textBounds);
        if (this.showBorder) {
            graphics2D.setColor(Color.lightGray);
            graphics2D.draw(this.textBounds);
        }
        int n6 = this.textBounds.y;
        if (this.title != null) {
            n6 += this.fm.getHeight();
            graphics2D.setFont(this.getFont());
            graphics2D.setColor(Color.black);
            n3 = this.title.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = (n4 - this.fm.stringWidth(this.title[n2])) / 2;
                graphics2D.drawString(this.title[n2], n, n6);
                if (n2 == n3 - 1) continue;
                n6 += this.fm.getHeight();
            }
        }
        if (this.subtitle != null) {
            n6 += this.subFm.getHeight();
            graphics2D.setFont(this.subFont);
            graphics2D.setColor(Color.black);
            n3 = this.subtitle.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = (n4 - this.subFm.stringWidth(this.subtitle[n2])) / 2;
                graphics2D.drawString(this.subtitle[n2], n, n6);
                n6 += this.subFm.getHeight();
            }
        }
    }
}

