/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.ChartConfig;
import com.tridium.eas.ui.chart.ChartEvent;
import com.tridium.eas.ui.chart.ChartModelListener;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.Overlay;
import com.tridium.eas.ui.chart.OverlayListener;
import com.tridium.eas.ui.chart.Series;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ChartModel {
    private SeriesSpec[] seriesSpecs;
    private OverlaySpec[] overlaySpecs;
    private Vector listeners;
    private boolean holdUpdates = false;
    private boolean pendingUpdate = false;
    private ChartEvent pendingRebuildEvent;
    private ChartEvent pendingSeriesEvent;
    private ChartEvent pendingOverlayEvent;
    private String title;
    private String subtitle;
    private ArrayList overlayListeners;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.fireEvent(new ChartEvent(this, 7));
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String string) {
        this.subtitle = string;
        this.fireEvent(new ChartEvent(this, 7));
    }

    public void setTitle(String string, String string2) {
        this.title = string;
        this.subtitle = string2;
        this.fireEvent(new ChartEvent(this, 7));
    }

    public synchronized Iterator getSeriesIds() {
        return new ElementIdIterator(this.seriesSpecs);
    }

    public synchronized Id addSeries(Series series, ChartConfig chartConfig, AxisInfo axisInfo, AxisInfo axisInfo2) {
        Id id = new Id(this.seriesSpecs == null ? 0 : this.seriesSpecs.length);
        SeriesSpec seriesSpec = new SeriesSpec(id, series, chartConfig, axisInfo, axisInfo2);
        if (this.seriesSpecs == null) {
            this.seriesSpecs = new SeriesSpec[]{seriesSpec};
        } else {
            SeriesSpec[] seriesSpecArray = new SeriesSpec[this.seriesSpecs.length + 1];
            System.arraycopy(this.seriesSpecs, 0, seriesSpecArray, 0, this.seriesSpecs.length);
            seriesSpecArray[this.seriesSpecs.length] = seriesSpec;
            this.seriesSpecs = seriesSpecArray;
        }
        this.fireSeriesAdded(id, series);
        return id;
    }

    public synchronized Id setSeries(Series series, ChartConfig chartConfig, AxisInfo axisInfo, AxisInfo axisInfo2) {
        this.setHoldUpdates(true);
        this.removeAllSeries();
        Id id = this.addSeries(series, chartConfig, axisInfo, axisInfo2);
        this.setHoldUpdates(false);
        return id;
    }

    public synchronized boolean removeSeries(Series series) {
        Id id = this.getSeriesId(series);
        if (id == null) {
            return false;
        }
        return this.removeSeries(id);
    }

    public synchronized boolean removeSeries(Id id) {
        if (!id.isValid()) {
            return false;
        }
        Series series = this.getSeries(id);
        SeriesSpec[] seriesSpecArray = new SeriesSpec[this.seriesSpecs.length - 1];
        if (id.index > 0) {
            System.arraycopy(this.seriesSpecs, 0, seriesSpecArray, 0, id.index);
        }
        if (id.index < this.seriesSpecs.length - 1) {
            System.arraycopy(this.seriesSpecs, id.index + 1, seriesSpecArray, id.index, this.seriesSpecs.length - id.index - 1);
        }
        id.invalidate();
        this.seriesSpecs = seriesSpecArray;
        this.updateSeriesIds();
        this.fireSeriesRemoved(id, series);
        return true;
    }

    public synchronized void removeAllSeries() {
        if (this.seriesSpecs == null) {
            return;
        }
        int n = this.seriesSpecs.length;
        for (int i = 0; i < n; ++i) {
            this.seriesSpecs[i].id.invalidate();
        }
        this.seriesSpecs = new SeriesSpec[0];
        this.fireRebuild();
    }

    public synchronized int getSeriesCount() {
        if (this.seriesSpecs == null) {
            return 0;
        }
        return this.seriesSpecs.length;
    }

    public synchronized Id getSeriesId(Series series) {
        if (this.seriesSpecs == null) {
            return null;
        }
        int n = this.seriesSpecs.length;
        for (int i = 0; i < n; ++i) {
            if (this.seriesSpecs[i].series != series) continue;
            return this.seriesSpecs[i].id;
        }
        return null;
    }

    public synchronized Series getSeries(Id id) {
        return this.seriesSpecs[id.index].series;
    }

    private synchronized void updateSeriesIds() {
        if (this.seriesSpecs == null) {
            return;
        }
        int n = this.seriesSpecs.length;
        for (int i = 0; i < n; ++i) {
            this.seriesSpecs[i].id.index = i;
        }
    }

    public synchronized ChartConfig getChartConfig(Id id) {
        return this.seriesSpecs[id.index].config;
    }

    public synchronized void setChartConfig(Id id, ChartConfig chartConfig) {
        this.seriesSpecs[id.index].config = chartConfig;
        this.fireSeriesModified(id, this.getSeries(id));
    }

    public synchronized AxisInfo getSeriesXAxisInfo(Id id) {
        return this.seriesSpecs[id.index].xInfo;
    }

    public synchronized void setSeriesXAxisInfo(Id id, AxisInfo axisInfo) {
        this.seriesSpecs[id.index].xInfo = axisInfo;
        this.fireSeriesModified(id, this.getSeries(id));
    }

    public synchronized AxisInfo getSeriesYAxisInfo(Id id) {
        return this.seriesSpecs[id.index].yInfo;
    }

    public synchronized void setSeriesYAxisInfo(Id id, AxisInfo axisInfo) {
        this.seriesSpecs[id.index].yInfo = axisInfo;
        this.fireSeriesModified(id, this.getSeries(id));
    }

    public synchronized int getChartType(Id id) {
        return this.seriesSpecs[id.index].config.getChartType();
    }

    public synchronized Iterator getOverlayIds() {
        return new ElementIdIterator(this.overlaySpecs);
    }

    public synchronized Id addOverlay(Overlay overlay, Id id) {
        Id id2 = new Id(this.getOverlayCount());
        OverlaySpec overlaySpec = new OverlaySpec(id2, overlay, id);
        this.addOverlay(overlaySpec);
        this.addOverlayListener(id2, overlay);
        this.fireOverlayAdded(id2, overlay);
        return id2;
    }

    public synchronized Id addOverlay(Overlay overlay, int n, AxisInfo axisInfo, int n2, AxisInfo axisInfo2) {
        Id id = new Id(this.getOverlayCount());
        OverlaySpec overlaySpec = new OverlaySpec(id, overlay, n, axisInfo, n2, axisInfo2);
        this.addOverlay(overlaySpec);
        this.addOverlayListener(id, overlay);
        this.fireOverlayAdded(id, overlay);
        return id;
    }

    private synchronized void addOverlay(OverlaySpec overlaySpec) {
        if (this.overlaySpecs == null) {
            this.overlaySpecs = new OverlaySpec[]{overlaySpec};
        } else {
            OverlaySpec[] overlaySpecArray = new OverlaySpec[this.overlaySpecs.length + 1];
            System.arraycopy(this.overlaySpecs, 0, overlaySpecArray, 0, this.overlaySpecs.length);
            overlaySpecArray[this.overlaySpecs.length] = overlaySpec;
            this.overlaySpecs = overlaySpecArray;
        }
    }

    public synchronized boolean removeOverlay(Overlay overlay) {
        Id id = this.getOverlayId(overlay);
        this.removeOverlayListener(id, overlay);
        if (id == null || !id.isValid()) {
            return false;
        }
        return this.removeOverlay(id);
    }

    public synchronized boolean removeOverlay(Id id) {
        if (!id.isValid() || this.overlaySpecs == null) {
            return false;
        }
        Overlay overlay = this.getOverlay(id);
        if (overlay == null) {
            return false;
        }
        this.removeOverlayListener(id, overlay);
        OverlaySpec[] overlaySpecArray = new OverlaySpec[this.overlaySpecs.length - 1];
        if (id.index > 0) {
            System.arraycopy(this.overlaySpecs, 0, overlaySpecArray, 0, id.index);
        }
        if (id.index < this.overlaySpecs.length - 1) {
            System.arraycopy(this.overlaySpecs, id.index + 1, overlaySpecArray, id.index, this.overlaySpecs.length - id.index - 1);
        }
        id.invalidate();
        this.overlaySpecs = overlaySpecArray;
        this.updateOverlayIds();
        this.fireOverlayRemoved(id, overlay);
        return true;
    }

    public synchronized void removeAllOverlays() {
        if (this.overlaySpecs == null) {
            return;
        }
        OverlaySpec[] overlaySpecArray = this.overlaySpecs;
        this.overlaySpecs = null;
        int n = overlaySpecArray.length;
        for (int i = 0; i < n; ++i) {
            overlaySpecArray[i].id.invalidate();
            this.removeOverlayListener(overlaySpecArray[i].id, overlaySpecArray[i].overlay);
            this.fireOverlayRemoved(overlaySpecArray[i].id, overlaySpecArray[i].overlay);
        }
    }

    public synchronized int getOverlayCount() {
        return this.overlaySpecs == null ? 0 : this.overlaySpecs.length;
    }

    public synchronized Id getOverlayId(Overlay overlay) {
        if (this.overlaySpecs == null) {
            return null;
        }
        int n = this.overlaySpecs.length;
        for (int i = 0; i < n; ++i) {
            if (this.overlaySpecs[i].overlay != overlay) continue;
            return this.overlaySpecs[i].id;
        }
        return null;
    }

    public synchronized Overlay getOverlay(Id id) {
        return this.overlaySpecs[id.index].overlay;
    }

    private synchronized void updateOverlayIds() {
        if (this.overlaySpecs == null) {
            return;
        }
        int n = this.overlaySpecs.length;
        for (int i = 0; i < n; ++i) {
            this.overlaySpecs[i].id.index = i;
        }
    }

    public synchronized Id getOverlaySeriesId(Id id) {
        return this.overlaySpecs[id.index].seriesId;
    }

    public synchronized int getOverlayXAxisType(Id id) {
        return this.overlaySpecs[id.index].xType;
    }

    public synchronized AxisInfo getOverlayXAxisInfo(Id id) {
        return this.overlaySpecs[id.index].xInfo;
    }

    public synchronized void setOverlayXAxisInfo(Id id, AxisInfo axisInfo) {
        this.overlaySpecs[id.index].xInfo = axisInfo;
        this.fireOverlayModified(id, this.getOverlay(id));
    }

    public synchronized int getOverlayYAxisType(Id id) {
        return this.overlaySpecs[id.index].yType;
    }

    public synchronized AxisInfo getOverlayYAxisInfo(Id id) {
        return this.overlaySpecs[id.index].yInfo;
    }

    public synchronized void setOverlayYAxisInfo(Id id, AxisInfo axisInfo) {
        this.overlaySpecs[id.index].yInfo = axisInfo;
        this.fireOverlayModified(id, this.getOverlay(id));
    }

    public void addListener(ChartModelListener chartModelListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.add(chartModelListener);
    }

    public void removeListener(ChartModelListener chartModelListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(chartModelListener);
    }

    public void setHoldUpdates(boolean bl) {
        this.holdUpdates = bl;
        if (!this.holdUpdates) {
            if (this.pendingRebuildEvent != null) {
                this.fireEvent(this.pendingRebuildEvent);
            } else {
                if (this.pendingSeriesEvent != null) {
                    this.fireEvent(this.pendingSeriesEvent);
                }
                if (this.pendingOverlayEvent != null) {
                    this.fireEvent(this.pendingOverlayEvent);
                }
            }
            this.pendingRebuildEvent = null;
            this.pendingSeriesEvent = null;
            this.pendingOverlayEvent = null;
        }
    }

    protected void fireRebuild() {
        this.fireEvent(new ChartEvent(this));
    }

    protected void fireSeriesAdded(Id id, Series series) {
        this.fireEvent(new ChartEvent(this, 1, id, series));
    }

    protected void fireSeriesRemoved(Id id, Series series) {
        this.fireEvent(new ChartEvent(this, 2, id, series));
    }

    protected void fireSeriesModified(Id id, Series series) {
        this.fireEvent(new ChartEvent(this, 3, id, series));
    }

    protected void fireOverlayAdded(Id id, Overlay overlay) {
        this.fireEvent(new ChartEvent(this, 4, id, overlay));
    }

    protected void fireOverlayRemoved(Id id, Overlay overlay) {
        this.fireEvent(new ChartEvent(this, 5, id, overlay));
    }

    protected void fireOverlayModified(Id id, Overlay overlay) {
        this.fireEvent(new ChartEvent(this, 6, id, overlay));
    }

    protected void fireEvent(ChartEvent chartEvent) {
        if (this.holdUpdates) {
            if (this.pendingRebuildEvent != null) {
                return;
            }
            int n = chartEvent.getEventType();
            if (n == 0) {
                this.pendingRebuildEvent = chartEvent;
            } else if (ChartEvent.isSeriesEvent(n)) {
                if (this.pendingSeriesEvent == null) {
                    this.pendingSeriesEvent = chartEvent;
                } else if (this.pendingSeriesEvent.getId() == chartEvent.getId()) {
                    this.pendingSeriesEvent = this.coalesceSeriesEvents(this.pendingSeriesEvent, chartEvent);
                } else {
                    this.pendingRebuildEvent = new ChartEvent(this);
                }
            } else if (ChartEvent.isOverlayEvent(n)) {
                if (this.pendingOverlayEvent == null) {
                    this.pendingOverlayEvent = chartEvent;
                } else if (this.pendingOverlayEvent.getId() == chartEvent.getId()) {
                    this.pendingOverlayEvent = this.coalesceOverlayEvents(this.pendingOverlayEvent, chartEvent);
                } else {
                    this.pendingRebuildEvent = new ChartEvent(this);
                }
            }
            return;
        }
        if (this.listeners == null) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ChartModelListener)iterator.next()).chartModified(chartEvent);
        }
    }

    private ChartEvent coalesceSeriesEvents(ChartEvent chartEvent, ChartEvent chartEvent2) {
        if (chartEvent == null) {
            return chartEvent2;
        }
        if (chartEvent2 == null) {
            return chartEvent;
        }
        int n = chartEvent.getEventType();
        int n2 = chartEvent2.getEventType();
        if (n == 1 && n2 == 3) {
            return chartEvent;
        }
        if (n == 1 && n2 == 2) {
            return null;
        }
        return chartEvent2;
    }

    private ChartEvent coalesceOverlayEvents(ChartEvent chartEvent, ChartEvent chartEvent2) {
        if (chartEvent == null) {
            return chartEvent2;
        }
        if (chartEvent2 == null) {
            return chartEvent;
        }
        int n = chartEvent.getEventType();
        int n2 = chartEvent2.getEventType();
        if (n == 4 && n2 == 6) {
            return chartEvent;
        }
        if (n == 4 && n2 == 5) {
            return null;
        }
        return chartEvent2;
    }

    private void addOverlayListener(Id id, Overlay overlay) {
        if (this.overlayListeners == null) {
            this.overlayListeners = new ArrayList(5);
        }
        ModelOverlayListener modelOverlayListener = new ModelOverlayListener(id);
        this.overlayListeners.add(modelOverlayListener);
        overlay.addListener(modelOverlayListener);
    }

    private void removeOverlayListener(Id id, Overlay overlay) {
        if (this.overlayListeners == null) {
            return;
        }
        Iterator iterator = this.overlayListeners.iterator();
        while (iterator.hasNext()) {
            ModelOverlayListener modelOverlayListener = (ModelOverlayListener)iterator.next();
            if (modelOverlayListener.overlayId != id) continue;
            iterator.remove();
            overlay.removeListener(modelOverlayListener);
            break;
        }
    }

    private class ElementIdIterator
    implements Iterator {
        private Id[] ids;
        private int index = -1;
        private Id last;
        private boolean forSeries;

        public ElementIdIterator(ElementSpec[] elementSpecArray) {
            int n = elementSpecArray == null ? 0 : elementSpecArray.length;
            this.ids = new Id[n];
            for (int i = 0; i < n; ++i) {
                this.ids[i] = elementSpecArray[i].id;
            }
            if (n != 0) {
                this.forSeries = elementSpecArray[0] instanceof SeriesSpec;
            }
        }

        public boolean hasNext() {
            this.advanceToNextValid();
            return this.index != this.ids.length;
        }

        public Object next() {
            if (this.index == this.ids.length) {
                throw new NoSuchElementException();
            }
            this.last = this.ids[this.index];
            this.advance();
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (this.forSeries) {
                ChartModel.this.removeSeries(this.last);
            } else {
                ChartModel.this.removeOverlay(this.last);
            }
        }

        private void advance() {
            if (this.index != this.ids.length) {
                ++this.index;
                this.advanceToNextValid();
            }
        }

        private void advanceToNextValid() {
            if (this.index == -1) {
                this.advance();
            } else {
                while (this.index != this.ids.length && !this.ids[this.index].isValid()) {
                    ++this.index;
                }
            }
        }
    }

    private class OverlaySpec
    extends ElementSpec {
        public Overlay overlay;
        public Id seriesId;
        public int xType;
        public int yType;

        public OverlaySpec(Id id, Overlay overlay, Id id2) {
            this(id, overlay, id2, 0, null, 0, null);
        }

        public OverlaySpec(Id id, Overlay overlay, int n, AxisInfo axisInfo, int n2, AxisInfo axisInfo2) {
            this(id, overlay, null, n, axisInfo, n2, axisInfo2);
        }

        private OverlaySpec(Id id, Overlay overlay, Id id2, int n, AxisInfo axisInfo, int n2, AxisInfo axisInfo2) {
            super(id, axisInfo, axisInfo2);
            this.overlay = overlay;
            this.seriesId = id2;
            this.xType = n;
            this.yType = n2;
        }
    }

    private class SeriesSpec
    extends ElementSpec {
        public Series series;
        public ChartConfig config;

        public SeriesSpec(Id id, Series series, ChartConfig chartConfig, AxisInfo axisInfo, AxisInfo axisInfo2) {
            super(id, axisInfo, axisInfo2);
            this.series = series;
            this.config = chartConfig;
        }
    }

    private class ElementSpec {
        public Id id;
        public AxisInfo xInfo;
        public AxisInfo yInfo;

        public ElementSpec(Id id, AxisInfo axisInfo, AxisInfo axisInfo2) {
            this.id = id;
            this.xInfo = axisInfo;
            this.yInfo = axisInfo2;
        }
    }

    private class ModelOverlayListener
    implements OverlayListener {
        public Id overlayId;

        public ModelOverlayListener(Id id) {
            this.overlayId = id;
        }

        public void overlayModified(Overlay overlay) {
            ChartModel.this.fireOverlayModified(this.overlayId, overlay);
        }
    }
}

