/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.Overlay;
import com.tridium.eas.ui.chart.Series;

public class ChartEvent {
    public static final int REBUILD_REQUIRED = 0;
    public static final int SERIES_ADDED = 1;
    public static final int SERIES_REMOVED = 2;
    public static final int SERIES_MODIFIED = 3;
    public static final int OVERLAY_ADDED = 4;
    public static final int OVERLAY_REMOVED = 5;
    public static final int OVERLAY_MODIFIED = 6;
    public static final int TITLE_MODIFIED = 7;
    private ChartModel model;
    private int eventType;
    private Id id;
    private Series series;
    private Overlay overlay;

    public ChartEvent(ChartModel chartModel) {
        this.model = chartModel;
        this.eventType = 0;
    }

    public ChartEvent(ChartModel chartModel, int n) {
        this.model = chartModel;
        this.eventType = n;
    }

    public ChartEvent(ChartModel chartModel, int n, Id id, Series series) {
        this.model = chartModel;
        this.eventType = n;
        this.id = id;
        this.series = series;
    }

    public ChartEvent(ChartModel chartModel, int n, Id id, Overlay overlay) {
        this.model = chartModel;
        this.eventType = n;
        this.id = id;
        this.overlay = overlay;
    }

    public ChartModel getModel() {
        return this.model;
    }

    public int getEventType() {
        return this.eventType;
    }

    public boolean isSeriesEvent() {
        return ChartEvent.isSeriesEvent(this.eventType);
    }

    public static boolean isSeriesEvent(int n) {
        return n >= 1 && n <= 3;
    }

    public boolean isOverlayEvent() {
        return ChartEvent.isOverlayEvent(this.eventType);
    }

    public static boolean isOverlayEvent(int n) {
        return n >= 4 && n <= 6;
    }

    public Id getId() {
        return this.id;
    }

    public Series getSeries() {
        return this.series;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("ChartEvent { ");
        stringBuffer.append(ChartEvent.eventTypeToString(this.eventType));
        if (this.eventType != 0) {
            if (this.eventType >= 1 && this.eventType <= 3) {
                stringBuffer.append(this.series);
            } else if (this.eventType >= 4 && this.eventType <= 6) {
                stringBuffer.append(this.overlay);
            }
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static String eventTypeToString(int n) {
        switch (n) {
            case 0: {
                return "REBUILD_REQUIRED";
            }
            case 1: {
                return "SERIES_ADDED";
            }
            case 2: {
                return "SERIES_REMOVED";
            }
            case 3: {
                return "SERIES_MODIFIED";
            }
            case 4: {
                return "OVERLAY_ADDED";
            }
            case 5: {
                return "OVERLAY_REMOVED";
            }
            case 6: {
                return "OVERLAY_MODIFIED";
            }
        }
        return "INVALID EVENT TYPE";
    }
}

