/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartConfig;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.Series;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public abstract class ChartCanvas {
    protected Chart chart;
    private Id seriesId;
    protected Axis xaxis;
    protected Axis yaxis;
    private int x;
    private int y;
    private int width;
    private int height;

    public ChartCanvas(Chart chart, Id id) {
        this.chart = chart;
        this.seriesId = id;
    }

    public Chart getChart() {
        return this.chart;
    }

    public Id getSeriesId() {
        return this.seriesId;
    }

    public Series getSeries() {
        return this.getChart().getModel().getSeries(this.seriesId);
    }

    public ChartConfig getConfig() {
        return this.getChart().getModel().getChartConfig(this.seriesId);
    }

    public boolean requiresAxes() {
        return true;
    }

    public boolean useRowTotals() {
        return false;
    }

    public Axis getXAxis() {
        return this.xaxis;
    }

    public void setXAxis(Axis axis) {
        this.xaxis = axis;
    }

    public Axis getYAxis() {
        return this.yaxis;
    }

    public void setYAxis(Axis axis) {
        this.yaxis = axis;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void doLayout() {
    }

    public abstract void paint(Graphics var1);

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

