/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.Series;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.UIManager;

public abstract class Axis
extends JComponent
implements ComponentListener,
MouseListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected static final int TICK_LENGTH = 4;
    protected static final int MARGIN = 4;
    private int orientation;
    private boolean leftBottom = true;
    private String units;
    private boolean drawTicks = true;
    private boolean drawTickLabels = true;
    private int axisLength;
    private int reserved;
    private int fullLength;
    private AxisInfo axisInfo;
    protected Font labelFont;
    protected FontMetrics labelFm;
    protected Font titleFont;
    protected FontMetrics titleFm;
    private Stack zoomStack;
    private Vector users;

    public Axis(int n, AxisInfo axisInfo) {
        this.orientation = n;
        this.axisInfo = axisInfo;
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.setLeftBottom(n == 1);
    }

    public boolean isHorizontal() {
        return this.orientation == 0;
    }

    public AxisInfo getAxisInfo() {
        return this.axisInfo;
    }

    public boolean isShareable(AxisInfo axisInfo) {
        if (this.axisInfo == null || axisInfo == null) {
            return true;
        }
        return axisInfo.isShareableWith(this.axisInfo);
    }

    public void setLeftBottom(boolean bl) {
        this.leftBottom = bl;
    }

    public boolean isLeftBottom() {
        return this.leftBottom;
    }

    public void setReserved(int n) {
        this.reserved = n;
        if (this.isVisible()) {
            this.invalidate();
        }
    }

    public boolean getDrawTicks() {
        return this.drawTicks;
    }

    public void setDrawTicks(boolean bl) {
        this.drawTicks = bl;
    }

    public boolean getDrawTickLabels() {
        return this.drawTickLabels;
    }

    public void setDrawTickLabels(boolean bl) {
        this.drawTickLabels = bl;
    }

    public final String getTickLabel(Object object) {
        String string = null;
        string = this.axisInfo == null || this.axisInfo.useDefaultTickLabels() ? this.getDefaultTickLabel(object) : this.axisInfo.getTickLabel(object);
        return string == null ? "" : string;
    }

    public abstract String getDefaultTickLabel(Object var1);

    public final String getValueLabel(Object object) {
        String string = null;
        string = this.axisInfo == null || this.axisInfo.useDefaultValueLabels() ? this.getDefaultValueLabel(object) : this.axisInfo.getTickLabel(object);
        return string;
    }

    public String getDefaultValueLabel(Object object) {
        return this.getDefaultTickLabel(object);
    }

    public abstract String pixelToLabel(int var1);

    public String getAxisTitle() {
        AxisInfo axisInfo = this.getAxisInfo();
        if (axisInfo == null) {
            return null;
        }
        return axisInfo.getTitle();
    }

    public int getFirstTickSpacing() {
        return this.getTickSpacing();
    }

    public abstract int getTickSpacing();

    public abstract int indexToPixel(Series var1, int var2);

    public abstract int valueToPixel(Object var1);

    public int valueToPixel(double d) {
        throw new UnsupportedOperationException("double values are not supported by this axis type");
    }

    public int valueToPixel(float f) {
        throw new UnsupportedOperationException("float values are not supported by this axis type");
    }

    public int valueToPixel(int n) {
        throw new UnsupportedOperationException("int values are not supported by this axis type");
    }

    public int valueToPixel(long l) {
        throw new UnsupportedOperationException("long values are not supported by this axis type");
    }

    public int valueToPixel(boolean bl) {
        throw new UnsupportedOperationException("boolean values are not supported by this axis type");
    }

    protected void checkFont() {
        if (this.labelFont == null) {
            Font font = UIManager.getFont("MenuItem.acceleratorFont");
            this.labelFont = font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), font.getSize());
            this.labelFm = Toolkit.getDefaultToolkit().getFontMetrics(this.labelFont);
            font = UIManager.getFont("TableHeader.font");
            this.titleFont = font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), font.getSize());
            this.titleFm = Toolkit.getDefaultToolkit().getFontMetrics(this.titleFont);
        }
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        switch (this.orientation) {
            case 0: {
                n = 50;
                n2 = 50;
                break;
            }
            case 1: {
                n = 50;
                n2 = 50;
            }
        }
        return new Dimension(n, n2);
    }

    public void doLayout() {
        if (this.isHorizontal()) {
            this.axisLength = this.getWidth() - this.reserved;
            this.fullLength = this.getWidth();
        } else {
            this.axisLength = this.getHeight() - this.reserved;
            this.fullLength = this.getHeight();
        }
    }

    public int getAxisLength() {
        return this.axisLength;
    }

    public int getFullLength() {
        return this.fullLength;
    }

    protected void resetLayout() {
    }

    public final void paintComponent(Graphics graphics) {
        this.paintAxis(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(Color.black);
        if (this.orientation == 0) {
            if (this.leftBottom) {
                graphics.drawLine(0, 0, n, 0);
            } else {
                graphics.drawLine(0, n2 - 1, n, n2 - 1);
            }
        } else if (this.leftBottom) {
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
        } else {
            graphics.drawLine(0, 0, 0, n2 - 1);
        }
    }

    protected abstract void paintAxis(Graphics var1);

    public void addUser(Object object) {
        if (this.users == null) {
            this.users = new Vector(5);
        }
        this.users.add(object);
    }

    public boolean removeUser(Object object) {
        if (this.users == null) {
            return false;
        }
        return this.users.remove(object);
    }

    public boolean isUsedByCanvas(Object object) {
        if (this.users == null) {
            return false;
        }
        int n = this.users.size();
        for (int i = 0; i < n; ++i) {
            if (this.users.elementAt(i) != object) continue;
            return true;
        }
        return false;
    }

    public boolean isUsed() {
        return this.users == null || this.users.size() == 0;
    }

    public boolean canZoomOut() {
        return this.zoomStack != null && !this.zoomStack.empty();
    }

    public final void zoomIn(int n, int n2) {
        if (this.isHorizontal()) {
            n = Math.max(n, 0);
            n2 = Math.min(n2, this.getWidth());
        } else {
            n = Math.max(n, 0);
            n2 = Math.min(n2, this.getHeight());
        }
        ZoomRec zoomRec = this.doZoomIn(n, n2);
        if (zoomRec != null) {
            this.pushZoom(zoomRec);
            this.resetLayout();
            this.revalidate();
            this.repaint();
        }
    }

    public final void zoomOut() {
        ZoomRec zoomRec = this.popZoom();
        if (zoomRec != null) {
            this.zoomOut(zoomRec);
            this.resetLayout();
            this.revalidate();
            this.repaint();
        }
    }

    protected abstract ZoomRec doZoomIn(int var1, int var2);

    protected abstract void zoomOut(ZoomRec var1);

    private void pushZoom(ZoomRec zoomRec) {
        if (this.zoomStack == null) {
            this.zoomStack = new Stack();
        }
        this.zoomStack.push(zoomRec);
    }

    private ZoomRec popZoom() {
        if (this.zoomStack == null || this.zoomStack.empty()) {
            return null;
        }
        return (ZoomRec)this.zoomStack.pop();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.resetLayout();
        Chart chart = (Chart)this.getParent();
        chart.updateChartArea();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    protected static interface ZoomRec {
    }
}

