/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui;

import com.tridium.eas.api.Meter;
import com.tridium.eas.api.ReportUtil;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.baja.util.Lexicon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NavigationBar
extends JComponent
implements ActionListener {
    private EasApplication app;
    private XpComboBox reportSelector;
    private XpComboBox viewSelector;
    private Lexicon lex;

    public NavigationBar(EasApplication easApplication) {
        this.app = easApplication;
        this.lex = BEasApplet.lex;
        this.viewSelector = this.buildViewSelector();
        this.viewSelector.addActionListener(this);
        this.reportSelector = this.buildReportSelector();
        if (this.reportSelector != null) {
            this.reportSelector.addActionListener(this);
        }
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout(2, 10, 3));
        if (!(this.reportSelector == null || easApplication.getId().equals("dbconfig") || easApplication.getId().equals("reportAdmin") || easApplication.getId().equals("billReconcile") || easApplication.getId().equals("rateComparison") || easApplication.getId().equals("budgetReport"))) {
            jPanel.add(new JLabel(this.lex.getText("report") + ":"));
            jPanel.add(this.reportSelector);
        }
        jPanel.add(new JLabel(this.lex.getText("goto") + ":"));
        jPanel.add(this.viewSelector);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "East");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.viewSelector) {
            ViewKey viewKey = (ViewKey)this.viewSelector.getSelectedItem();
            if (viewKey.id.equals(this.app.getId()) && this.app.getParameter("reportName", null) == null) {
                return;
            }
            if (this.app.getId().equals("dbconfig")) {
                this.app.stopApplication();
            }
            this.app.open(viewKey.path);
        } else if (object == this.reportSelector) {
            Object object2 = this.reportSelector.getSelectedItem();
            if (object2 instanceof ViewKey) {
                if (this.app instanceof EasReport) {
                    ((EasReport)this.app).setKeepParameters(false);
                }
                ViewKey viewKey = (ViewKey)object2;
                this.app.open(viewKey.path);
            } else if (object2 instanceof ReportKey) {
                ReportKey reportKey = (ReportKey)object2;
                String string = ReportUtil.reportNameToUrl(reportKey.id, reportKey.name, reportKey.isPublic);
                this.app.open(string);
            }
        }
    }

    private XpComboBox buildViewSelector() {
        String string = this.app.getId();
        int n = -1;
        XpComboBox xpComboBox = new XpComboBox();
        try {
            String string2 = this.app.getSession().getText("/eas/reports/list");
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    ViewKey viewKey = NavigationBar.parse(string3, this.lex);
                    if (viewKey == null) continue;
                    xpComboBox.addItem(viewKey);
                    if (!viewKey.id.equals(string)) continue;
                    n = xpComboBox.getItemCount() - 1;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            xpComboBox.addItem(this.lex.getText("error"));
        }
        if (Meter.isReportLicensed(this.app.getSession(), "configuration")) {
            xpComboBox.addItem(new ViewKey("dbconfig", this.lex.getText("configuration"), "/dbconfig"));
            if (string.equals("dbconfig")) {
                n = xpComboBox.getItemCount() - 1;
            }
        }
        if (Meter.isReportLicensed(this.app.getSession(), "reportAdmin")) {
            xpComboBox.addItem(new ViewKey("reportAdmin", this.lex.getText("reportAdministration"), "/reportAdmin"));
            if (string.equals("reportAdmin")) {
                n = xpComboBox.getItemCount() - 1;
            }
        }
        xpComboBox.setSelectedIndex(n);
        xpComboBox.setMaximumRowCount(Math.min(15, xpComboBox.getItemCount()));
        return xpComboBox;
    }

    private XpComboBox buildReportSelector() {
        boolean bl;
        XpComboBox xpComboBox;
        block8: {
            String string = this.app.getId();
            xpComboBox = new XpComboBox();
            String string2 = this.app.getParameter("reportName", null);
            if (string.equals("whatIfAnalyzer")) {
                xpComboBox.addItem(new ViewKey("whatIfAnalyzer", this.lex.getText("template"), "/cost/whatIfAnalyzer"));
            } else {
                xpComboBox.addItem(new ViewKey(string, this.lex.getText("template")));
            }
            bl = true;
            try {
                String string3 = this.app.getSession().getText("/eas/savedReports?id=" + string);
                if (string3 == null) break block8;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
                String string4 = null;
                while ((string4 = bufferedReader.readLine()) != null) {
                    String string5 = string4;
                    if (string5.length() == 0) continue;
                    if (string5.equals(string)) {
                        while ((string4 = bufferedReader.readLine()) != null && string4.length() != 0) {
                            boolean bl2 = string4.charAt(0) == '+';
                            String string6 = string4.substring(1);
                            String string7 = ReportUtil.fileNameToReportName(string6);
                            ReportKey reportKey = new ReportKey(string, string7, bl2);
                            xpComboBox.addItem(reportKey);
                            bl = false;
                            if (string2 == null || !string2.equals(reportKey.urlName)) continue;
                            xpComboBox.setSelectedIndex(xpComboBox.getItemCount() - 1);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            return null;
        }
        return xpComboBox;
    }

    public void selectView(String string) {
        int n = this.viewSelector.getItemCount();
        for (int i = 0; i < n; ++i) {
            ViewKey viewKey = (ViewKey)this.viewSelector.getItemAt(i);
            if (!viewKey.id.equals(string)) continue;
            this.viewSelector.setSelectedIndex(i);
        }
    }

    private static ViewKey parse(String string, Lexicon lexicon) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = lexicon.getText(string2);
        String string4 = string.substring(n + 1);
        ViewKey viewKey = new ViewKey(string2, string3, string4);
        return viewKey;
    }

    private static class ReportKey {
        public String id;
        public String name;
        public String urlName;
        public boolean isPublic;

        public ReportKey(String string, String string2, boolean bl) {
            this.id = string;
            this.name = string2;
            this.urlName = ReportUtil.reportNameToUrlParameter(string2);
            this.isPublic = bl;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ViewKey {
        public String id;
        public String name;
        public String path;

        public ViewKey(String string, String string2) {
            this(string, string2, "/reports/" + string);
        }

        public ViewKey(String string, String string2, String string3) {
            this.id = string;
            this.name = string2;
            this.path = string3;
        }

        public String toString() {
            return this.name;
        }
    }
}

