/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.DataCleansingBar;
import com.tridium.eas.ui.NavigationBar;
import com.tridium.eas.ui.NavigationManager;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.StatusDisplay;
import com.tridium.eas.ui.widgets.EasButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;

public abstract class EasApplication
extends JComponent
implements ActionListener,
NavigationManager,
ResourceManager,
RootPaneContainer {
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    public static final int DIVIDER_SIZE = 4;
    private EasSession session;
    public BEasApplet easApplet;
    private Map params;
    private NavigationManager nav;
    private StatusDisplay statusDisplay;
    private JButton homeButton;
    private JButton helpButton;
    private DataCleansingBar dataCleansingBar = null;
    private static boolean lastDataCleanse = false;
    private static int lastDataCleanseWindow = 4;
    private static double lastDataCleansePercentage = 100.0;
    public static int globalBillPeriodMonth = -1;
    public static String globalBillPeriodYear = null;
    public static int globalConsecutiveBillCycles = -1;
    public static boolean globalShowBaseline = false;
    public static int globalBaselineBillPeriodMonth = -1;
    public static String globalBaselineBillPeriodYear = null;
    private MediaTracker media;
    private Map icons;
    private Object appClipboard;
    private FocusListener focusListener = null;

    public EasApplication() {
        this.setLayout(new BorderLayout());
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
        this.enableEvents(8L);
    }

    protected JRootPane createRootPane() {
        JRootPane jRootPane = new JRootPane();
        jRootPane.setOpaque(true);
        return jRootPane;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public abstract String getName();

    public abstract String getId();

    public void setInputEnabled(boolean bl) {
        if (bl && this.focusListener != null) {
            this.getRootPane().getGlassPane().removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        this.getRootPane().getGlassPane().setVisible(!bl);
    }

    public void restrictInputToComponent(Component component) {
        if (this.focusListener != null) {
            throw new IllegalStateException("Input is already restricted to another component");
        }
        this.setInputEnabled(false);
        this.focusListener = new ComponentFocusListener(component);
        this.getRootPane().getGlassPane().addFocusListener(this.focusListener);
    }

    public final void init(EasSession easSession, Map map, NavigationManager navigationManager, StatusDisplay statusDisplay, boolean bl, BEasApplet bEasApplet) {
        JToolBar jToolBar;
        this.session = easSession;
        this.params = map;
        this.nav = navigationManager;
        this.statusDisplay = statusDisplay;
        this.easApplet = bEasApplet;
        this.queueIconImage("/com/tridium/eas/ui/images/help.gif", 30);
        this.queueIconImage("/com/tridium/eas/ui/images/station.png", 1);
        this.queueIconImage("/com/tridium/eas/ui/images/folder.png", 4);
        this.queueIconImage("/com/tridium/eas/ui/images/building.png", 7);
        this.queueIconImage("/com/tridium/eas/ui/images/trend.png", 10);
        this.queueIconImage("/com/tridium/eas/ui/images/property.png", 13);
        this.queueIconImage("/com/tridium/eas/ui/images/delete.png", 16);
        this.queueIconImage("/com/tridium/eas/ui/images/refresh.png", 17);
        this.queueIconImage("/com/tridium/eas/ui/images/save.png", 18);
        this.queueIconImage("/com/tridium/eas/ui/images/tree.png", 19);
        this.queueIconImage("/com/tridium/eas/ui/images/zoomOut.png", 20);
        this.queueIconImage("/com/tridium/eas/ui/images/grid.png", 21);
        this.queueIconImage("/com/tridium/eas/ui/images/table.png", 22);
        this.queueIconImage("/com/tridium/eas/ui/images/home.gif", 23);
        this.queueIconImage("/com/tridium/eas/ui/images/meter.png", 26);
        this.queueIconImage("/com/tridium/eas/ui/images/function.png", 27);
        this.queueIconImage("/com/tridium/eas/ui/images/print.png", 28);
        this.queueIconImage("/com/tridium/eas/ui/images/new.png", 29);
        this.queueIconImage("/com/tridium/eas/ui/images/shortcut.png", 14);
        this.setLayout(new BorderLayout());
        JComponent jComponent = this.getApplicationContent();
        JComponent jComponent2 = this.getApplicationToolBar();
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BorderLayout());
        JToolBar jToolBar2 = this.buildToolBar();
        if (jToolBar2 != null) {
            jPanel.add((Component)jToolBar2, "West");
        }
        if (jComponent2 != null) {
            jPanel.add((Component)jComponent2, "Center");
        }
        if ((jToolBar = this.buildHelpToolBar()) != null) {
            jPanel.add((Component)jToolBar, "East");
        }
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        this.dataCleansingBar = new DataCleansingBar(this);
        jPanel2.add((Component)this.dataCleansingBar, "Center");
        jPanel2.add((Component)new NavigationBar(this), "East");
        this.add((Component)jPanel2, "North");
        this.add((Component)jComponent, "Center");
        this.setOpaque(true);
        if (bl) {
            this.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if (EasApplication.this.getRootPane() != null) {
                        EasApplication.this.getRootPane().getGlassPane().addMouseListener(new MouseAdapter(){});
                        EasApplication.this.getRootPane().getGlassPane().addKeyListener(new KeyAdapter(){});
                        EasApplication.this.removeHierarchyListener(this);
                    }
                }
            });
        } else {
            this.repaint();
        }
        this.setDataCleanse(lastDataCleanse);
        this.setDataCleanseWindow(lastDataCleanseWindow);
        this.setDataCleansePercentage(lastDataCleansePercentage);
        this.initApplication(bl);
    }

    public void initApplication(boolean bl) {
    }

    public EasSession getSession() {
        return this.session;
    }

    private JToolBar buildToolBar() {
        Lexicon lexicon = BEasApplet.lex;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.homeButton = new EasButton((ResourceManager)this, 23, lexicon.getText("home"));
        this.homeButton.addActionListener(this);
        jToolBar.add(this.homeButton);
        return jToolBar;
    }

    protected JComponent getApplicationToolBar() {
        return null;
    }

    private JToolBar buildHelpToolBar() {
        Lexicon lexicon = BEasApplet.lex;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.helpButton = new EasButton((ResourceManager)this, 30, lexicon.getText("help"));
        this.helpButton.addActionListener(this);
        jToolBar.add(this.helpButton);
        return jToolBar;
    }

    protected JComponent getApplicationContent() {
        return new JLabel("");
    }

    public final void start() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                EasApplication.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    EasApplication.this.startApplication();
                }
                finally {
                    EasApplication.this.setCursor(Cursor.getDefaultCursor());
                }
                EasApplication.this.repaint();
            }
        }, "EasApplicationStart");
        thread.start();
    }

    protected void startApplication() {
    }

    public final void stop() {
        lastDataCleanse = this.getDataCleanse();
        lastDataCleanseWindow = this.getDataCleanseWindow();
        lastDataCleansePercentage = this.getDataCleansePercentage();
        this.stopApplication();
    }

    protected void stopApplication() {
    }

    public String getParameter(String string, String string2) {
        String string3 = (String)this.params.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public int getIntParameter(String string, int n) {
        String string2 = (String)this.params.get(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getLongParameter(String string, long l) {
        String string2 = (String)this.params.get(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public boolean getBooleanParameter(String string, boolean bl) {
        String string2 = (String)this.params.get(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        return bl;
    }

    public void open(String string) {
        this.open(string, "_self");
    }

    public void open(String string, String string2) {
        this.nav.open(string, string2);
    }

    public void open(byte[] byArray, String string, String string2, String string3) {
        this.nav.open(byArray, string, string2, string3);
    }

    public void help() {
        try {
            String string = this.session.getText("/eas/helpFile/" + this.getId());
            if (string != null) {
                this.open("/help" + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setStatus(String string) {
        if (this.statusDisplay != null) {
            this.statusDisplay.setStatus(string);
        }
    }

    public void clearStatus() {
        if (this.statusDisplay != null) {
            this.statusDisplay.clearStatus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            this.buttonPressed((JButton)object);
        }
        if (object instanceof JToggleButton) {
            this.buttonToggled((JToggleButton)object, ((JToggleButton)object).isSelected());
        }
    }

    protected void buttonPressed(JButton jButton) {
        if (jButton == this.homeButton) {
            if (this.getId().equals("dbconfig")) {
                this.stop();
            }
            this.nav.open("/");
        } else if (jButton == this.helpButton) {
            if (this.getId().equals("dbconfig")) {
                this.stop();
            }
            this.help();
        }
    }

    protected void buttonToggled(JToggleButton jToggleButton, boolean bl) {
    }

    public ResourceManager getResourceManager() {
        return this;
    }

    public Image loadImage(String string) {
        try {
            int n;
            Class<?> clazz = this.getClass();
            InputStream inputStream = clazz.getResourceAsStream(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            Image image = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
            if (this.media == null) {
                this.media = new MediaTracker(this);
            }
            this.media.addImage(image, 0);
            this.media.waitForID(0);
            this.media.removeImage(image, 0);
            return image;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void queueIconImage(String string, int n) {
        try {
            int n2;
            Class<?> clazz = this.getClass();
            InputStream inputStream = clazz.getResourceAsStream(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            Image image = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
            if (this.media == null) {
                this.media = new MediaTracker(this);
            }
            this.media.addImage(image, n);
            if (this.icons == null) {
                this.icons = new HashMap();
            }
            this.icons.put(new Integer(n), image);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Image getIconImage(int n) {
        try {
            Image image = (Image)this.icons.get(new Integer(n));
            this.media.waitForID(n);
            return image;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Object getClipboard() {
        return this.appClipboard;
    }

    public void setClipboard(Object object) {
        this.appClipboard = object;
    }

    public void clearClipboard() {
        this.appClipboard = null;
    }

    public void dataCleansingChanged() {
    }

    public boolean getDataCleanse() {
        if (this.dataCleansingBar != null) {
            return this.dataCleansingBar.getDataCleanse();
        }
        return false;
    }

    public void setDataCleanse(boolean bl) {
        if (this.dataCleansingBar != null) {
            this.dataCleansingBar.setDataCleanse(bl);
        }
    }

    public int getDataCleanseWindow() {
        if (this.dataCleansingBar != null) {
            return this.dataCleansingBar.getDataCleanseWindow();
        }
        return 4;
    }

    public void setDataCleanseWindow(int n) {
        if (this.dataCleansingBar != null) {
            this.dataCleansingBar.setDataCleanseWindow(n);
        }
    }

    public double getDataCleansePercentage() {
        if (this.dataCleansingBar != null) {
            return this.dataCleansingBar.getDataCleansePercentage();
        }
        return 100.0;
    }

    public void setDataCleansePercentage(double d) {
        if (this.dataCleansingBar != null) {
            this.dataCleansingBar.setDataCleansePercentage(d);
        }
    }

    private static class ComponentFocusListener
    implements FocusListener {
        private Component component;

        public ComponentFocusListener(Component component) {
            this.component = component;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.component.requestFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.component.requestFocus();
        }
    }
}

