/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui;

import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.widgets.NumberTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.baja.util.Lexicon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DataCleansingBar
extends JComponent
implements ActionListener,
FocusListener,
DocumentListener {
    private EasApplication app;
    private JCheckBox dataCleansingCheckBox = null;
    private NumberTextField dataCleanseWindowEditor = null;
    private NumberTextField dataCleansePercentageEditor = null;

    public DataCleansingBar(EasApplication easApplication) {
        JPanel jPanel;
        this.app = easApplication;
        Lexicon lexicon = BEasApplet.lex;
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new FlowLayout(1, 10, 3));
        this.dataCleansingCheckBox = new JCheckBox(lexicon.getText("dataCleanse"));
        this.dataCleansingCheckBox.setSelected(false);
        this.dataCleansingCheckBox.addActionListener(this);
        if (!easApplication.getId().equals("dbconfig") && !easApplication.getId().equals("reportAdmin")) {
            jPanel2.add(this.dataCleansingCheckBox);
        }
        this.dataCleanseWindowEditor = new NumberTextField(3, true);
        this.dataCleanseWindowEditor.setAllowNegative(false);
        this.dataCleanseWindowEditor.setUseLabelAppearanceWhenDisabled(true);
        this.dataCleanseWindowEditor.addFocusListener(this);
        this.dataCleanseWindowEditor.setText(4);
        this.dataCleanseWindowEditor.setEditable(false);
        this.dataCleanseWindowEditor.getDocument().addDocumentListener(this);
        if (!easApplication.getId().equals("dbconfig") && !easApplication.getId().equals("reportAdmin")) {
            jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(1, 3, 0));
            jPanel.add(this.dataCleanseWindowEditor);
            jPanel.add(new JLabel(lexicon.getText("dataCleanseWindow")));
            jPanel2.add(jPanel);
        }
        this.dataCleansePercentageEditor = new NumberTextField(5, false);
        this.dataCleansePercentageEditor.setAllowNegative(false);
        this.dataCleansePercentageEditor.setUseLabelAppearanceWhenDisabled(true);
        this.dataCleansePercentageEditor.addFocusListener(this);
        this.dataCleansePercentageEditor.setText(100.0f);
        this.dataCleansePercentageEditor.setEditable(false);
        this.dataCleansePercentageEditor.getDocument().addDocumentListener(this);
        if (!easApplication.getId().equals("dbconfig") && !easApplication.getId().equals("reportAdmin")) {
            jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(1, 3, 0));
            jPanel.add(this.dataCleansePercentageEditor);
            jPanel.add(new JLabel(lexicon.getText("dataCleansePercentage")));
            jPanel2.add(jPanel);
        }
        this.add((Component)jPanel2, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.dataCleansingCheckBox) {
            boolean bl = this.dataCleansingCheckBox.isSelected();
            this.dataCleanseWindowEditor.setEditable(bl);
            this.dataCleansePercentageEditor.setEditable(bl);
        }
        this.app.dataCleansingChanged();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.app.dataCleansingChanged();
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof JTextField && ((JTextField)component).isEditable()) {
            DataCleansingBar.selectItLater(component);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private static void selectItLater(Component component) {
        if (component instanceof JTextField) {
            final JTextField jTextField = (JTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTextField.selectAll();
                }
            });
        }
    }

    public boolean getDataCleanse() {
        if (this.dataCleansingCheckBox != null) {
            return this.dataCleansingCheckBox.isSelected();
        }
        return false;
    }

    public void setDataCleanse(boolean bl) {
        if (this.dataCleansingCheckBox != null) {
            this.dataCleansingCheckBox.setSelected(bl);
            this.dataCleanseWindowEditor.setEditable(bl);
            this.dataCleansePercentageEditor.setEditable(bl);
        }
    }

    public int getDataCleanseWindow() {
        if (this.dataCleanseWindowEditor != null) {
            return this.dataCleanseWindowEditor.getIntValue();
        }
        return 4;
    }

    public void setDataCleanseWindow(int n) {
        if (this.dataCleanseWindowEditor != null) {
            this.dataCleanseWindowEditor.setText(n);
        }
    }

    public double getDataCleansePercentage() {
        if (this.dataCleansePercentageEditor != null) {
            return this.dataCleansePercentageEditor.getDoubleValue();
        }
        return 100.0;
    }

    public void setDataCleansePercentage(double d) {
        if (this.dataCleansePercentageEditor != null) {
            this.dataCleansePercentageEditor.setText(d);
        }
    }
}

