/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.ParameterMetaData;
import com.tridium.eas.function.Parameters;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.ScalarUnaryOperation;
import com.tridium.eas.function.TransformFunction;
import javax.baja.units.BUnit;

public class VectorUnaryOperation
implements TransformFunction {
    public static final ParameterMetaData PARAMETER_META_DATA = new ParameterMetaData(1, 1, 0, 0, 0, 0);
    private ScalarUnaryOperation op = null;

    public VectorUnaryOperation() {
        this.op = new ScalarUnaryOperation(){

            public double getScalar(double d) {
                return d;
            }

            public boolean isValid(double d) {
                return true;
            }
        };
    }

    public VectorUnaryOperation(ScalarUnaryOperation scalarUnaryOperation) {
        this.op = scalarUnaryOperation;
    }

    public Population getPopulation(Parameters parameters) {
        return new ResultPopulation(parameters.getPopulation(0), this.getOp());
    }

    public Population getPopulation(Population population) {
        return new ResultPopulation(population, this.getOp());
    }

    public ScalarUnaryOperation getOp() {
        return this.op;
    }

    public ParameterMetaData getParameterMetaData() {
        return PARAMETER_META_DATA;
    }

    private static class ResultPopulation
    implements Population {
        private ScalarUnaryOperation op;
        private Population orig;

        public ResultPopulation(Population population, ScalarUnaryOperation scalarUnaryOperation) {
            this.orig = population;
            this.op = scalarUnaryOperation;
        }

        public int getSize() {
            return this.orig.getSize();
        }

        public double getSample(int n) {
            return this.op.getScalar(this.orig.getSample(n));
        }

        public BUnit getUnit() {
            return this.orig.getUnit();
        }

        public boolean isValid(int n) {
            return this.orig.isValid(n) && this.op.isValid(this.orig.getSample(n));
        }
    }
}

