/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.ParameterMetaData;
import com.tridium.eas.function.Parameters;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.ScalarBinaryOperation;
import com.tridium.eas.function.TransformFunction;
import javax.baja.units.BUnit;

public class VectorBinaryOperation
implements TransformFunction {
    public static final ParameterMetaData PARAMETER_META_DATA = new ParameterMetaData(2, 2, 0, 0, 0, 0);
    private ScalarBinaryOperation op = null;

    public VectorBinaryOperation() {
        this.op = new ScalarBinaryOperation(){

            public double getScalar(double d, double d2) {
                return d;
            }

            public boolean isValid(double d, double d2) {
                return true;
            }
        };
    }

    public VectorBinaryOperation(ScalarBinaryOperation scalarBinaryOperation) {
        this.op = scalarBinaryOperation;
    }

    public Population getPopulation(Parameters parameters) {
        return new ResultPopulation(parameters.getPopulation(0), parameters.getPopulation(1), this.getOp());
    }

    public Population getPopulation(Population population, Population population2) {
        return new ResultPopulation(population, population2, this.getOp());
    }

    public static Population getPopulation(Population population, Population population2, ScalarBinaryOperation scalarBinaryOperation, BUnit bUnit) {
        return new ResultPopulation(population, population2, scalarBinaryOperation, bUnit);
    }

    public static Population getPopulation(Population population, Population population2, ScalarBinaryOperation scalarBinaryOperation) {
        return new ResultPopulation(population, population2, scalarBinaryOperation);
    }

    public ScalarBinaryOperation getOp() {
        return this.op;
    }

    public ParameterMetaData getParameterMetaData() {
        return PARAMETER_META_DATA;
    }

    private static class ResultPopulation
    implements Population {
        private ScalarBinaryOperation op;
        private Population orig1;
        private Population orig2;
        private BUnit unit;

        public ResultPopulation(Population population, Population population2, ScalarBinaryOperation scalarBinaryOperation) {
            this(population, population2, scalarBinaryOperation, population.getUnit());
        }

        public ResultPopulation(Population population, Population population2, ScalarBinaryOperation scalarBinaryOperation, BUnit bUnit) {
            this.orig1 = population;
            this.orig2 = population2;
            this.op = scalarBinaryOperation;
            this.unit = bUnit;
        }

        public int getSize() {
            return this.orig1.getSize();
        }

        public double getSample(int n) {
            return this.op.getScalar(this.orig1.getSample(n), this.orig2.getSample(n));
        }

        public BUnit getUnit() {
            return this.unit;
        }

        public boolean isValid(int n) {
            return this.orig1.isValid(n) && this.orig2.isValid(n) && this.op.isValid(this.orig1.getSample(n), this.orig2.getSample(n));
        }
    }
}

