/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.Mean;
import com.tridium.eas.function.ParameterMetaData;
import com.tridium.eas.function.Parameters;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.ScalarFunction;
import com.tridium.eas.function.ValidCount;

public class Variance
implements ScalarFunction {
    public double getScalar(Parameters parameters) {
        return Variance.getVariance(parameters.getPopulation(0));
    }

    public static double getVariance(Population population) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = n = population.getSize();
        while (--n2 >= 0) {
            if (population.isValid(n2)) {
                double d3 = population.getSample(n2);
                d += d3;
                d2 += d3 * d3;
                continue;
            }
            --n;
        }
        return Variance.getVariance(population, d, d2, n);
    }

    public static double getVariance(Population population, double d, double d2, int n) {
        return (d2 - d * d / (double)n) / (double)(n - 1);
    }

    public static double getVariance(Population population, double d, double d2) {
        return Variance.getVariance(population, d, d2, ValidCount.getValidCount(population));
    }

    public static double getVariance(Population population, double d) {
        int n;
        double d2 = 0.0;
        int n2 = n = population.getSize();
        while (--n2 >= 0) {
            if (population.isValid(n2)) {
                double d3 = population.getSample(n2) - d;
                d2 += d3 * d3;
                continue;
            }
            --n;
        }
        return d2 / (double)(n - 1);
    }

    public static double getVarianceByTotal(Population population, double d) {
        return Variance.getVariance(population, Mean.getMean(population, d));
    }

    public ParameterMetaData getParameterMetaData() {
        return ParameterMetaData.SINGLE_POPULATION;
    }
}

