/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.Function;
import com.tridium.eas.function.ParameterMetaData;
import com.tridium.eas.function.Population;

public class SPCLimitsFunction
implements Function {
    private Population pop;
    private double mean;
    private double mR;
    private boolean ready;

    public SPCLimitsFunction(Population population) {
        this.pop = population;
        this.ready = false;
    }

    public double getUpperLimit() {
        if (!this.ready) {
            this.calc();
        }
        return this.mean + (double)2.66f * this.mR;
    }

    public double getLowerLimit() {
        if (!this.ready) {
            this.calc();
        }
        return this.mean - (double)2.66f * this.mR;
    }

    public double getMean() {
        if (!this.ready) {
            this.calc();
        }
        return this.mean;
    }

    public double getMRMean() {
        if (!this.ready) {
            this.calc();
        }
        return this.mR;
    }

    public boolean isValid() {
        return this.ready;
    }

    public void invalidate() {
        this.ready = false;
    }

    public ParameterMetaData getParameterMetaData() {
        return ParameterMetaData.SINGLE_POPULATION;
    }

    private void calc() {
        if (this.pop.getSize() > 3) {
            this.mean = 0.0;
            this.mR = 0.0;
            double d = 0.0;
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            for (int i = 0; i < this.pop.getSize(); ++i) {
                if (this.pop.isValid(i)) {
                    ++n;
                    double d2 = this.pop.getSample(i);
                    this.mean += d2;
                    if (bl) {
                        this.mR += Math.abs(d - d2);
                        ++n2;
                    }
                    d = d2;
                    bl = true;
                    continue;
                }
                bl = false;
            }
            if (n2 > 2) {
                this.mean /= (double)n;
                this.mR /= (double)n2;
                this.ready = true;
            }
        }
    }
}

